/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.polars.jaxrs.api;

import com.sap.sailing.domain.common.security.SecuredDomainType;
import com.sap.sailing.polars.jaxrs.AbstractPolarResource;
import com.sap.sse.ServerInfo;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.TypeRelativeObjectIdentifier;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Logger;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;

@Path(value="/polar_data")
public class PolarDataResource
extends AbstractPolarResource {
    private static final Logger logger = Logger.getLogger(PolarDataResource.class.getName());

    @GET
    @Produces(value={"application/octet-stream;charset=UTF-8"})
    public Response getRegressions() throws IOException {
        Subject subject = SecurityUtils.getSubject();
        logger.info("Polar Data requested by " + (subject.getPrincipal() == null ? "anonymous user" : subject.getPrincipal().toString()));
        subject.checkPermission(SecuredDomainType.POLAR_DATA.getStringPermissionForTypeRelativeIdentifier((HasPermissions.Action)HasPermissions.DefaultActions.READ, new TypeRelativeObjectIdentifier(new String[]{ServerInfo.getName()})));
        return Response.ok((Object)new StreamingOutput(){

            public void write(OutputStream output) throws IOException, WebApplicationException {
                PolarDataResource.this.getPolarDataServiceImpl().serializeForInitialReplication(output);
            }
        }).header("Content-Type", (Object)"application/octet-stream").build();
    }
}

