/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.polars.impl;

import com.sap.sailing.domain.base.BoatClass;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.DomainFactory;
import com.sap.sailing.domain.base.SpeedWithBearingWithConfidence;
import com.sap.sailing.domain.base.SpeedWithConfidence;
import com.sap.sailing.domain.base.impl.SpeedWithBearingWithConfidenceImpl;
import com.sap.sailing.domain.common.LegType;
import com.sap.sailing.domain.common.ManeuverType;
import com.sap.sailing.domain.common.PolarSheetGenerationSettings;
import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.Tack;
import com.sap.sailing.domain.common.confidence.BearingWithConfidence;
import com.sap.sailing.domain.common.confidence.impl.BearingWithConfidenceImpl;
import com.sap.sailing.domain.common.impl.KnotSpeedWithBearingImpl;
import com.sap.sailing.domain.common.impl.PolarSheetGenerationSettingsImpl;
import com.sap.sailing.domain.common.polars.NotEnoughDataHasBeenAddedException;
import com.sap.sailing.domain.common.tracking.GPSFixMoving;
import com.sap.sailing.domain.polars.PolarDataService;
import com.sap.sailing.domain.polars.PolarsChangedListener;
import com.sap.sailing.domain.tracking.GPSFixTrack;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.polars.PolarDataOperation;
import com.sap.sailing.polars.ReplicablePolarService;
import com.sap.sailing.polars.mining.AngleAndSpeedRegression;
import com.sap.sailing.polars.mining.BearingClusterGroup;
import com.sap.sailing.polars.mining.CubicRegressionPerCourseProcessor;
import com.sap.sailing.polars.mining.PolarDataMiner;
import com.sap.sailing.polars.mining.SpeedRegressionPerAngleClusterProcessor;
import com.sap.sailing.polars.regression.impl.IncrementalAnyOrderLeastSquaresImpl;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Speed;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.DegreeBearingImpl;
import com.sap.sse.datamining.data.ClusterGroup;
import com.sap.sse.datamining.shared.GroupKey;
import com.sap.sse.replication.interfaces.impl.AbstractReplicableWithObjectInputStream;
import com.sap.sse.util.ClearStateTestSupport;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.MalformedURLException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.logging.Logger;
import org.apache.commons.math.analysis.polynomials.PolynomialFunction;

public class PolarDataServiceImpl
extends AbstractReplicableWithObjectInputStream<PolarDataService, PolarDataOperation<?>>
implements ReplicablePolarService,
ClearStateTestSupport {
    private static final Logger logger = Logger.getLogger(PolarDataServiceImpl.class.getSimpleName());
    private PolarDataMiner polarDataMiner;
    private DomainFactory domainFactory;

    public PolarDataServiceImpl() {
        this.resetState();
    }

    @Override
    public void resetState() {
        PolarSheetGenerationSettings settings = PolarSheetGenerationSettingsImpl.createBackendPolarSettings();
        ClusterGroup<Bearing> angleClusterGroup = this.createAngleClusterGroup();
        CubicRegressionPerCourseProcessor cubicRegressionPerCourseProcessor = new CubicRegressionPerCourseProcessor();
        SpeedRegressionPerAngleClusterProcessor speedRegressionPerAngleClusterProcessor = new SpeedRegressionPerAngleClusterProcessor(angleClusterGroup);
        this.polarDataMiner = new PolarDataMiner(settings, cubicRegressionPerCourseProcessor, speedRegressionPerAngleClusterProcessor, angleClusterGroup);
    }

    public boolean isCurrentlyActiveAndOrHasQueue() {
        return this.polarDataMiner.isCurrentlyActiveAndOrHasQueue();
    }

    private ClusterGroup<Bearing> createAngleClusterGroup() {
        return new BearingClusterGroup(0, 180, 5);
    }

    public SpeedWithConfidence<Void> getSpeed(BoatClass boatClass, Speed windSpeed, Bearing trueWindAngle) throws NotEnoughDataHasBeenAddedException {
        if (this.polarDataMiner == null) {
            throw new NotEnoughDataHasBeenAddedException("Polar Data Miner is currently unavailable. Maybe we are in the process of replication initial load?");
        }
        return this.polarDataMiner.estimateBoatSpeed(boatClass, windSpeed, trueWindAngle);
    }

    public Util.Pair<List<Speed>, Double> estimateWindSpeeds(BoatClass boatClass, Speed boatSpeed, Bearing trueWindAngle) throws NotEnoughDataHasBeenAddedException {
        if (this.polarDataMiner == null) {
            throw new NotEnoughDataHasBeenAddedException("Polar Data Miner is currently unavailable. Maybe we are in the process of replication initial load?");
        }
        return this.polarDataMiner.estimateWindSpeeds(boatClass, boatSpeed, trueWindAngle);
    }

    public Set<SpeedWithBearingWithConfidence<Void>> getAverageTrueWindSpeedAndAngleCandidates(BoatClass boatClass, Speed speedOverGround, LegType legType, Tack tack) {
        return this.polarDataMiner.estimateTrueWindSpeedAndAngleCandidates(boatClass, speedOverGround, legType, tack);
    }

    public SpeedWithBearingWithConfidence<Void> getAverageSpeedWithTrueWindAngle(BoatClass boatClass, Speed windSpeed, LegType legType, Tack tack) throws NotEnoughDataHasBeenAddedException {
        if (this.polarDataMiner == null) {
            throw new NotEnoughDataHasBeenAddedException("Polar Data Miner is currently unavailable. Maybe we are in the process of replication initial load?");
        }
        SpeedWithBearingWithConfidenceImpl averageSpeedAndCourseOverGround = this.polarDataMiner.getAverageSpeedAndCourseOverGround(boatClass, windSpeed, legType);
        if (tack == Tack.PORT) {
            DegreeBearingImpl bearing = new DegreeBearingImpl(-averageSpeedAndCourseOverGround.getObject().getBearing().getDegrees());
            KnotSpeedWithBearingImpl speed = new KnotSpeedWithBearingImpl(averageSpeedAndCourseOverGround.getObject().getKnots(), (Bearing)bearing);
            averageSpeedAndCourseOverGround = new SpeedWithBearingWithConfidenceImpl((SpeedWithBearing)speed, averageSpeedAndCourseOverGround.getConfidence(), null);
        }
        return averageSpeedAndCourseOverGround;
    }

    public Set<BoatClass> getAllBoatClassesWithPolarSheetsAvailable() {
        return this.polarDataMiner.getAvailableBoatClasses();
    }

    public void competitorPositionChanged(GPSFixMoving fix, Competitor competitor, TrackedRace createdTrackedRace) {
        this.polarDataMiner.addFix(fix, competitor, createdTrackedRace);
    }

    public double getConfidenceForTackJibeSpeedRatio(Speed intoTackSpeed, Speed intoJibeSpeed, BoatClass boatClass) {
        return Math.min(1.0, 0.5 * intoJibeSpeed.getKnots() / intoTackSpeed.getKnots());
    }

    public Util.Pair<Double, SpeedWithBearingWithConfidence<Void>> getManeuverLikelihoodAndTwsTwa(BoatClass boatClass, Speed speedAtManeuverStart, double courseChangeDeg, ManeuverType maneuverType) {
        Util.Pair result;
        assert (maneuverType == ManeuverType.TACK || maneuverType == ManeuverType.JIBE);
        SpeedWithBearingWithConfidence<Void> closestTwsTwa = this.getClosestTwaTws(maneuverType, speedAtManeuverStart, courseChangeDeg, boatClass);
        if (closestTwsTwa == null) {
            result = new Util.Pair((Object)0.0, null);
        } else {
            double targetManeuverAngle = this.getManeuverAngleInDegreesFromTwa(maneuverType, closestTwsTwa.getObject().getBearing());
            double minDiffDeg = Math.abs(Math.abs(targetManeuverAngle) - Math.abs(courseChangeDeg));
            result = new Util.Pair((Object)(1.0 / (1.0 + minDiffDeg / 10.0 * (minDiffDeg / 10.0))), closestTwsTwa);
        }
        return result;
    }

    public SpeedWithBearingWithConfidence<Void> getClosestTwaTws(ManeuverType type, Speed speedAtManeuverStart, double courseChangeDeg, BoatClass boatClass) {
        assert (type == ManeuverType.TACK || type == ManeuverType.JIBE);
        double minDiff = Double.MAX_VALUE;
        SpeedWithBearingWithConfidence<Void> closestTwsTwa = null;
        for (SpeedWithBearingWithConfidence<Void> trueWindSpeedAndAngle : this.getAverageTrueWindSpeedAndAngleCandidates(boatClass, speedAtManeuverStart, type == ManeuverType.TACK ? LegType.UPWIND : LegType.DOWNWIND, type == ManeuverType.TACK ? (courseChangeDeg >= 0.0 ? Tack.PORT : Tack.STARBOARD) : (courseChangeDeg >= 0.0 ? Tack.STARBOARD : Tack.PORT))) {
            double targetManeuverAngle = this.getManeuverAngleInDegreesFromTwa(type, trueWindSpeedAndAngle.getObject().getBearing());
            double diff = Math.abs(Math.abs(targetManeuverAngle) - Math.abs(courseChangeDeg));
            if (!(diff < minDiff)) continue;
            minDiff = diff;
            closestTwsTwa = trueWindSpeedAndAngle;
        }
        return closestTwsTwa;
    }

    public double getManeuverAngleInDegreesFromTwa(ManeuverType type, Bearing twa) {
        assert (type == ManeuverType.TACK || type == ManeuverType.JIBE);
        double maneuverAngle = type == ManeuverType.TACK ? Math.abs(twa.getDegrees() * 2.0) : (180.0 - Math.abs(twa.getDegrees())) * 2.0;
        return maneuverAngle;
    }

    public PolynomialFunction getSpeedRegressionFunction(BoatClass boatClass, LegType legType) throws NotEnoughDataHasBeenAddedException {
        return this.polarDataMiner.getSpeedRegressionFunction(boatClass, legType);
    }

    public PolynomialFunction getAngleRegressionFunction(BoatClass boatClass, LegType legType) throws NotEnoughDataHasBeenAddedException {
        return this.polarDataMiner.getAngleRegressionFunction(boatClass, legType);
    }

    public PolynomialFunction getSpeedRegressionFunction(BoatClass boatClass, double trueWindAngle) throws NotEnoughDataHasBeenAddedException {
        return this.polarDataMiner.getSpeedRegressionFunction(boatClass, Math.abs(trueWindAngle));
    }

    public void raceFinishedLoading(TrackedRace race) {
        this.polarDataMiner.raceFinishedTracking(race);
    }

    public BearingWithConfidence<Void> getManeuverAngle(BoatClass boatClass, ManeuverType maneuverType, Speed windSpeed) throws NotEnoughDataHasBeenAddedException {
        LegType legType;
        if (maneuverType != ManeuverType.TACK && maneuverType != ManeuverType.JIBE) {
            throw new IllegalArgumentException("ManeuverType needs to be tack or jibe.");
        }
        LegType legType2 = legType = maneuverType == ManeuverType.TACK ? LegType.UPWIND : LegType.DOWNWIND;
        if (boatClass == null || windSpeed == null) {
            throw new IllegalArgumentException("Boatclass and windspeed cannot be null.");
        }
        if (this.polarDataMiner == null) {
            throw new NotEnoughDataHasBeenAddedException("Polar Data Miner is currently unavailable. Maybe we are in the process of replication initial load?");
        }
        SpeedWithBearingWithConfidence<Void> speed = this.polarDataMiner.getAverageSpeedAndCourseOverGround(boatClass, windSpeed, legType);
        DegreeBearingImpl bearing = new DegreeBearingImpl(this.getManeuverAngleInDegreesFromTwa(maneuverType, speed.getObject().getBearing()));
        BearingWithConfidenceImpl bearingWithConfidence = new BearingWithConfidenceImpl((Bearing)bearing, speed.getConfidence(), null);
        return bearingWithConfidence;
    }

    public void insertExistingFixes(TrackedRace trackedRace) {
        for (Competitor competitor : trackedRace.getRace().getCompetitors()) {
            GPSFixTrack track = trackedRace.getTrack(competitor);
            track.lockForRead();
            try {
                for (GPSFixMoving fix : track.getFixes()) {
                    this.competitorPositionChanged(fix, competitor, trackedRace);
                }
            }
            finally {
                track.unlockAfterRead();
            }
        }
    }

    public void registerListener(BoatClass boatClass, PolarsChangedListener listener) {
        this.polarDataMiner.registerListener(boatClass, listener);
    }

    public void unregisterListener(BoatClass boatClass, PolarsChangedListener listener) {
        this.polarDataMiner.unregisterListener(boatClass, listener);
    }

    public void clearReplicaState() throws MalformedURLException, IOException, InterruptedException {
        this.polarDataMiner = null;
    }

    public ObjectInputStream createObjectInputStreamResolvingAgainstCache(InputStream is, Map<String, Class<?>> classLoaderCache) throws IOException {
        Object ois;
        if (this.domainFactory != null) {
            ois = this.domainFactory.createObjectInputStreamResolvingAgainstThisFactory(is, null, classLoaderCache);
        } else {
            logger.warning("PolarDataService didn't have a domain factory attached. Replication to this service could fail.");
            ois = new ObjectInputStream(is);
        }
        return ois;
    }

    public void initiallyFillFromInternal(ObjectInputStream is) throws IOException, ClassNotFoundException, InterruptedException {
        PolarSheetGenerationSettings backendPolarSettings = (PolarSheetGenerationSettings)is.readObject();
        CubicRegressionPerCourseProcessor cubicRegressionPerCourseProcessor = (CubicRegressionPerCourseProcessor)is.readObject();
        SpeedRegressionPerAngleClusterProcessor speedRegressionPerAngleClusterProcessor = (SpeedRegressionPerAngleClusterProcessor)is.readObject();
        this.polarDataMiner = new PolarDataMiner(backendPolarSettings, cubicRegressionPerCourseProcessor, speedRegressionPerAngleClusterProcessor, speedRegressionPerAngleClusterProcessor.getAngleCluster());
    }

    public void serializeForInitialReplicationInternal(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.polarDataMiner.getPolarSheetGenerationSettings());
        objectOutputStream.writeObject(this.polarDataMiner.getCubicRegressionPerCourseProcessor());
        objectOutputStream.writeObject(this.polarDataMiner.getSpeedRegressionPerAngleClusterProcessor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDomainFactory(DomainFactory domainFactory) {
        PolarDataServiceImpl polarDataServiceImpl = this;
        synchronized (polarDataServiceImpl) {
            this.domainFactory = domainFactory;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runWithDomainFactory(Consumer<DomainFactory> consumer) throws InterruptedException {
        DomainFactory myDomainFactory;
        PolarDataServiceImpl polarDataServiceImpl = this;
        synchronized (polarDataServiceImpl) {
            myDomainFactory = this.domainFactory;
            while (myDomainFactory == null) {
                this.wait();
                myDomainFactory = this.domainFactory;
            }
        }
        consumer.accept(myDomainFactory);
    }

    public Map<GroupKey, AngleAndSpeedRegression> getCubicRegressionsPerCourse() {
        return this.polarDataMiner.getCubicRegressionPerCourseProcessor().getRegressions();
    }

    public Map<GroupKey, IncrementalAnyOrderLeastSquaresImpl> getSpeedRegressionsPerAngle() {
        return this.polarDataMiner.getSpeedRegressionPerAngleClusterProcessor().getRegressionsImpl();
    }

    public Map<BoatClass, Long> getFixCountPerBoatClass() {
        return this.polarDataMiner.getSpeedRegressionPerAngleClusterProcessor().getFixCountPerBoatClass();
    }

    public void clearState() throws Exception {
        this.resetState();
    }
}

