/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.polars.impl;

import com.sap.sailing.domain.polars.PolarDataService;
import com.sap.sailing.polars.ReplicablePolarService;
import com.sap.sailing.polars.impl.PolarDataServiceImpl;
import com.sap.sailing.polars.jaxrs.client.PolarDataClient;
import com.sap.sse.replication.Replicable;
import com.sap.sse.util.ClearStateTestSupport;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class Activator
implements BundleActivator {
    private static final String POLAR_DATA_SOURCE_URL_PROPERTY_NAME = "polardata.source.url";
    private static final String POLAR_DATA_SOURCE_BEARER_TOKEN_PROPERTY_NAME = "polardata.source.bearertoken";
    private static final Logger logger = Logger.getLogger(Activator.class.getName());
    private final Set<ServiceRegistration<?>> registrations = new HashSet();

    public void start(BundleContext context) throws Exception {
        logger.info("Registering PolarDataService");
        PolarDataServiceImpl service = new PolarDataServiceImpl();
        ServiceRegistration polarDataServiceRegistration = context.registerService(PolarDataService.class, (Object)service, null);
        this.registrations.add(polarDataServiceRegistration);
        Hashtable<String, String> replicableServiceProperties = new Hashtable<String, String>();
        ((Dictionary)replicableServiceProperties).put("ID", service.getId().toString());
        this.registrations.add(context.registerService(Replicable.class, (Object)service, replicableServiceProperties));
        this.registrations.add(context.registerService(ClearStateTestSupport.class.getName(), (Object)service, null));
        String polarDataSourceURL = System.getProperty(POLAR_DATA_SOURCE_URL_PROPERTY_NAME);
        String polarDataBearerToken = System.getProperty(POLAR_DATA_SOURCE_BEARER_TOKEN_PROPERTY_NAME);
        if (polarDataSourceURL != null && !polarDataSourceURL.isEmpty()) {
            this.waitForRacingEventServiceToObtainDomainFactory(polarDataSourceURL, Optional.ofNullable(polarDataBearerToken), service, context, (ServiceRegistration<PolarDataService>)polarDataServiceRegistration);
        }
    }

    private void waitForRacingEventServiceToObtainDomainFactory(String polarDataSourceURL, Optional<String> polarDataBearerToken, ReplicablePolarService polarService, BundleContext context, ServiceRegistration<PolarDataService> polarDataServiceRegistration) {
        Thread t = new Thread(() -> {
            try {
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                logger.info("Waiting for domain factory to be registered with PolarService...");
                polarService.runWithDomainFactory(domainFactory -> {
                    PolarDataClient polarDataClient = new PolarDataClient(polarDataSourceURL, polarService, polarDataBearerToken);
                    try {
                        polarDataServiceRegistration.unregister();
                        polarDataClient.updatePolarDataRegressions();
                        this.registrations.add(context.registerService(PolarDataService.class, (Object)polarService, null));
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "Exception while trying to import polar data from " + polarDataSourceURL, e);
                    }
                });
            }
            catch (InterruptedException e) {
                logger.log(Level.SEVERE, "Interrupted while waiting for UserStore service", e);
            }
        }, "PolarService activator waiting for domain factory to be registered");
        t.setDaemon(true);
        t.start();
    }

    public void stop(BundleContext context) throws Exception {
        logger.info("Unregistering PolarDataService");
        for (ServiceRegistration<?> reg : this.registrations) {
            reg.unregister();
        }
        this.registrations.clear();
    }
}

