/*
 * Decompiled with CFR 0.152.
 */
package smile.stat.distribution;

import java.util.Arrays;
import smile.math.Math;
import smile.stat.distribution.DiscreteDistribution;

public class EmpiricalDistribution
extends DiscreteDistribution {
    private static final long serialVersionUID = 1L;
    private int[] x;
    private int xMin;
    private int xMax;
    private double[] p;
    private double[] cdf;
    private double mean;
    private double var;
    private double sd;
    private double entropy;
    private int[] a;
    private double[] q;

    public EmpiricalDistribution(double[] prob) {
        if (prob.length == 0) {
            throw new IllegalArgumentException("Empty probability set.");
        }
        this.xMin = 0;
        this.xMax = prob.length - 1;
        this.x = new int[prob.length];
        this.p = new double[prob.length];
        this.cdf = new double[prob.length];
        this.mean = 0.0;
        double mean2 = 0.0;
        this.entropy = 0.0;
        this.cdf[0] = prob[0];
        for (int i = 0; i < prob.length; ++i) {
            if (prob[i] < 0.0 || prob[i] > 1.0) {
                throw new IllegalArgumentException("Invalid probability " + this.p[i]);
            }
            this.x[i] = i;
            this.p[i] = prob[i];
            if (i > 0) {
                this.cdf[i] = this.cdf[i - 1] + this.p[i];
            }
            this.mean += (double)this.x[i] * this.p[i];
            mean2 += (double)(this.x[i] * this.x[i]) * this.p[i];
            this.entropy -= this.p[i] * Math.log2(this.p[i]);
        }
        this.var = mean2 - this.mean * this.mean;
        this.sd = Math.sqrt(this.var);
        if (Math.abs(this.cdf[this.cdf.length - 1] - 1.0) > 1.0E-7) {
            throw new IllegalArgumentException("The sum of probabilities is not 1.");
        }
    }

    public EmpiricalDistribution(int[] data) {
        if (data.length == 0) {
            throw new IllegalArgumentException("Empty dataset.");
        }
        this.xMin = Math.min(data);
        this.xMax = Math.max(data);
        int n = this.xMax - this.xMin + 1;
        this.x = new int[n];
        this.p = new double[n];
        this.cdf = new double[n];
        for (int i = 0; i < data.length; ++i) {
            int n2 = data[i] - this.xMin;
            this.p[n2] = this.p[n2] + 1.0;
        }
        this.mean = 0.0;
        double mean2 = 0.0;
        this.entropy = 0.0;
        for (int i = 0; i < n; ++i) {
            this.x[i] = this.xMin + i;
            int n3 = i;
            this.p[n3] = this.p[n3] / (double)data.length;
            if (i == 0) {
                this.cdf[0] = this.p[0];
            } else {
                this.cdf[i] = this.cdf[i - 1] + this.p[i];
            }
            this.mean += (double)this.x[i] * this.p[i];
            mean2 += (double)(this.x[i] * this.x[i]) * this.p[i];
            this.entropy -= this.p[i] * Math.log2(this.p[i]);
        }
        this.var = mean2 - this.mean * this.mean;
        this.sd = Math.sqrt(this.var);
    }

    @Override
    public int npara() {
        return this.p.length;
    }

    @Override
    public double mean() {
        return this.mean;
    }

    @Override
    public double var() {
        return this.var;
    }

    @Override
    public double sd() {
        return this.sd;
    }

    @Override
    public double entropy() {
        return this.entropy;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Empirical Distribution(");
        for (int i = 0; i < this.p.length; ++i) {
            builder.append(this.p[i]);
            builder.append(' ');
        }
        builder.setCharAt(builder.length() - 1, ')');
        return builder.toString();
    }

    @Override
    public double rand() {
        int k;
        if (this.a == null) {
            this.initRand();
        }
        double rU = Math.random() * (double)this.p.length;
        if ((rU -= (double)(k = (int)rU)) < this.q[k]) {
            return k;
        }
        return this.a[k];
    }

    public int[] rand(int n) {
        if (this.a == null) {
            this.initRand();
        }
        int[] ans = new int[n];
        for (int i = 0; i < n; ++i) {
            int k;
            double rU = Math.random() * (double)this.p.length;
            ans[i] = (rU -= (double)(k = (int)rU)) < this.q[k] ? k : this.a[k];
        }
        return ans;
    }

    private synchronized void initRand() {
        int i;
        this.q = new double[this.p.length];
        for (i = 0; i < this.p.length; ++i) {
            this.q[i] = this.p[i] * (double)this.p.length;
        }
        this.a = new int[this.p.length];
        for (i = 0; i < this.p.length; ++i) {
            this.a[i] = i;
        }
        int[] HL = new int[this.p.length];
        int head = 0;
        int tail = this.p.length - 1;
        for (int i2 = 0; i2 < this.p.length; ++i2) {
            if (this.q[i2] >= 1.0) {
                HL[head++] = i2;
                continue;
            }
            HL[tail--] = i2;
        }
        while (head != 0 && tail != this.p.length - 1) {
            int k;
            int j = HL[tail + 1];
            this.a[j] = k = HL[head - 1];
            int n = k;
            this.q[n] = this.q[n] + (this.q[j] - 1.0);
            ++tail;
            if (!(this.q[k] < 1.0)) continue;
            HL[tail--] = k;
            --head;
        }
    }

    @Override
    public double p(int k) {
        if (k < this.xMin || k > this.xMax) {
            return 0.0;
        }
        return this.p[k - this.xMin];
    }

    @Override
    public double logp(int k) {
        if (k < this.xMin || k > this.xMax) {
            return Double.NEGATIVE_INFINITY;
        }
        return Math.log(this.p[k - this.xMin]);
    }

    @Override
    public double cdf(double k) {
        if (k < (double)this.xMin) {
            return 0.0;
        }
        if (k >= (double)this.xMax) {
            return 1.0;
        }
        return this.cdf[(int)Math.floor(k - (double)this.xMin)];
    }

    @Override
    public double quantile(double p) {
        if (p < 0.0 || p > 1.0) {
            throw new IllegalArgumentException("Invalid p: " + p);
        }
        int k = Arrays.binarySearch(this.cdf, p);
        if (k < 0) {
            return this.x[-k - 1];
        }
        return this.x[k];
    }
}

