/*
 * Decompiled with CFR 0.152.
 */
package smile.stat.distribution;

import java.util.ArrayList;
import java.util.List;
import smile.math.Math;
import smile.stat.distribution.DiscreteDistribution;

public class DiscreteMixture
extends DiscreteDistribution {
    private static final long serialVersionUID = 1L;
    List<Component> components = new ArrayList<Component>();

    public DiscreteMixture(List<Component> mixture) {
        this.components.addAll(mixture);
        double sum = 0.0;
        for (Component component : mixture) {
            sum += component.priori;
            if (component.distribution instanceof DiscreteDistribution) continue;
            throw new IllegalArgumentException("Component " + component + " is not a discrete distribution.");
        }
        if (Math.abs(sum - 1.0) > 0.001) {
            throw new IllegalArgumentException("The sum of priori is not equal to 1.");
        }
    }

    @Override
    public double mean() {
        if (this.components.isEmpty()) {
            throw new IllegalStateException("Mixture is empty!");
        }
        double mu = 0.0;
        for (Component c : this.components) {
            mu += c.priori * c.distribution.mean();
        }
        return mu;
    }

    @Override
    public double var() {
        if (this.components.isEmpty()) {
            throw new IllegalStateException("Mixture is empty!");
        }
        double variance = 0.0;
        for (Component c : this.components) {
            variance += c.priori * c.priori * c.distribution.var();
        }
        return variance;
    }

    @Override
    public double sd() {
        return Math.sqrt(this.var());
    }

    @Override
    public double entropy() {
        throw new UnsupportedOperationException("Mixture does not support entropy()");
    }

    @Override
    public double p(int x) {
        if (this.components.isEmpty()) {
            throw new IllegalStateException("Mixture is empty!");
        }
        double p = 0.0;
        for (Component c : this.components) {
            p += c.priori * c.distribution.p(x);
        }
        return p;
    }

    @Override
    public double logp(int x) {
        if (this.components.isEmpty()) {
            throw new IllegalStateException("Mixture is empty!");
        }
        return Math.log(this.p(x));
    }

    @Override
    public double cdf(double x) {
        if (this.components.isEmpty()) {
            throw new IllegalStateException("Mixture is empty!");
        }
        double p = 0.0;
        for (Component c : this.components) {
            p += c.priori * c.distribution.cdf(x);
        }
        return p;
    }

    @Override
    public double rand() {
        if (this.components.isEmpty()) {
            throw new IllegalStateException("Mixture is empty!");
        }
        double r = Math.random();
        double p = 0.0;
        for (Component g : this.components) {
            if (!(r <= (p += g.priori))) continue;
            return g.distribution.rand();
        }
        return this.components.get((int)(this.components.size() - 1)).distribution.rand();
    }

    @Override
    public double quantile(double p) {
        int xu;
        int xl;
        if (this.components.isEmpty()) {
            throw new IllegalStateException("Mixture is empty!");
        }
        if (p < 0.0 || p > 1.0) {
            throw new IllegalArgumentException("Invalid p: " + p);
        }
        int inc = 1;
        int x = (int)this.mean();
        if (p < this.cdf(x)) {
            while (p < this.cdf(x -= (inc *= 2))) {
            }
            xl = x;
            xu = x + inc / 2;
        } else {
            while (p > this.cdf(x += (inc *= 2))) {
            }
            xu = x;
            xl = x - inc / 2;
        }
        return this.quantile(p, xl, xu);
    }

    @Override
    public int npara() {
        if (this.components.isEmpty()) {
            throw new IllegalStateException("Mixture is empty!");
        }
        int f = 0;
        for (int i = 0; i < this.components.size(); ++i) {
            f += this.components.get((int)i).distribution.npara();
        }
        return f;
    }

    public int size() {
        return this.components.size();
    }

    public double bic(double[] data) {
        if (this.components.isEmpty()) {
            throw new IllegalStateException("Mixture is empty!");
        }
        int n = data.length;
        double logLikelihood = 0.0;
        for (double x : data) {
            double p = this.p(x);
            if (!(p > 0.0)) continue;
            logLikelihood += Math.log(p);
        }
        return logLikelihood - 0.5 * (double)this.npara() * Math.log(n);
    }

    public List<Component> getComponents() {
        return this.components;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Mixture[");
        builder.append(this.components.size());
        builder.append("]:{");
        for (Component c : this.components) {
            builder.append(" (");
            builder.append(c.distribution);
            builder.append(':');
            builder.append(String.format("%.4f", c.priori));
            builder.append(')');
        }
        builder.append("}");
        return builder.toString();
    }

    public static class Component {
        public DiscreteDistribution distribution;
        public double priori;
    }
}

