/*
 * Decompiled with CFR 0.152.
 */
package smile.sort;

import smile.sort.SortUtils;

public class IntHeapSelect {
    private int k;
    private int n;
    private boolean sorted;
    private int[] heap;

    public IntHeapSelect(int k) {
        this(new int[k]);
    }

    public IntHeapSelect(int[] heap) {
        this.heap = heap;
        this.k = heap.length;
        this.n = 0;
        this.sorted = false;
    }

    public void add(int datum) {
        this.sorted = false;
        if (this.n < this.k) {
            this.heap[this.n++] = datum;
            if (this.n == this.k) {
                IntHeapSelect.heapify(this.heap);
            }
        } else {
            ++this.n;
            if (datum < this.heap[0]) {
                this.heap[0] = datum;
                SortUtils.siftDown(this.heap, 0, this.k - 1);
            }
        }
    }

    public int peek() {
        return this.heap[0];
    }

    public int get(int i) {
        if (i > Math.min(this.k, this.n) - 1) {
            throw new IllegalArgumentException("HeapSelect i is greater than the number of data received so far.");
        }
        if (i == this.k - 1) {
            return this.heap[0];
        }
        if (!this.sorted) {
            IntHeapSelect.sort(this.heap, Math.min(this.k, this.n));
            this.sorted = true;
        }
        return this.heap[this.k - 1 - i];
    }

    public void sort() {
        if (!this.sorted) {
            IntHeapSelect.sort(this.heap, Math.min(this.k, this.n));
            this.sorted = true;
        }
    }

    private static void heapify(int[] arr) {
        int n = arr.length;
        for (int i = n / 2 - 1; i >= 0; --i) {
            SortUtils.siftDown(arr, i, n - 1);
        }
    }

    private static void sort(int[] a, int n) {
        int inc = 1;
        do {
            inc *= 3;
        } while (++inc <= n);
        do {
            for (int i = inc /= 3; i < n; ++i) {
                int v = a[i];
                int j = i;
                while (a[j - inc] < v) {
                    a[j] = a[j - inc];
                    if ((j -= inc) >= inc) continue;
                }
                a[j] = v;
            }
        } while (inc > 1);
    }
}

