/*
 * Decompiled with CFR 0.152.
 */
package smile.math.distance;

import smile.math.distance.Metric;

public class EuclideanDistance
implements Metric<double[]> {
    private static final long serialVersionUID = 1L;
    private double[] weight = null;

    public EuclideanDistance() {
    }

    public EuclideanDistance(double[] weight) {
        for (int i = 0; i < weight.length; ++i) {
            if (!(weight[i] < 0.0)) continue;
            throw new IllegalArgumentException(String.format("Weight has to be nonnegative: %f", weight[i]));
        }
        this.weight = weight;
    }

    public String toString() {
        if (this.weight != null) {
            return "weighted Euclidean distance";
        }
        return "Euclidean distance";
    }

    @Override
    public double d(int[] x, int[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException(String.format("Arrays have different length: x[%d], y[%d]", x.length, y.length));
        }
        double dist = 0.0;
        if (this.weight == null) {
            for (int i = 0; i < x.length; ++i) {
                double d = x[i] - y[i];
                dist += d * d;
            }
        } else {
            if (x.length != this.weight.length) {
                throw new IllegalArgumentException(String.format("Input vectors and weight vector have different length: %d, %d", x.length, this.weight.length));
            }
            for (int i = 0; i < x.length; ++i) {
                double d = x[i] - y[i];
                dist += this.weight[i] * d * d;
            }
        }
        return Math.sqrt(dist);
    }

    @Override
    public double d(float[] x, float[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException(String.format("Arrays have different length: x[%d], y[%d]", x.length, y.length));
        }
        int n = x.length;
        int m = 0;
        double dist = 0.0;
        if (this.weight == null) {
            for (int i = 0; i < n; ++i) {
                if (Float.isNaN(x[i]) || Float.isNaN(y[i])) continue;
                ++m;
                double d = x[i] - y[i];
                dist += d * d;
            }
        } else {
            if (x.length != this.weight.length) {
                throw new IllegalArgumentException(String.format("Input vectors and weight vector have different length: %d, %d", x.length, this.weight.length));
            }
            for (int i = 0; i < n; ++i) {
                if (Float.isNaN(x[i]) || Float.isNaN(y[i])) continue;
                ++m;
                double d = x[i] - y[i];
                dist += this.weight[i] * d * d;
            }
        }
        dist = m == 0 ? Double.NaN : (double)n * dist / (double)m;
        return Math.sqrt(dist);
    }

    @Override
    public double d(double[] x, double[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException(String.format("Arrays have different length: x[%d], y[%d]", x.length, y.length));
        }
        int n = x.length;
        int m = 0;
        double dist = 0.0;
        if (this.weight == null) {
            for (int i = 0; i < n; ++i) {
                if (Double.isNaN(x[i]) || Double.isNaN(y[i])) continue;
                ++m;
                double d = x[i] - y[i];
                dist += d * d;
            }
        } else {
            if (x.length != this.weight.length) {
                throw new IllegalArgumentException(String.format("Input vectors and weight vector have different length: %d, %d", x.length, this.weight.length));
            }
            for (int i = 0; i < n; ++i) {
                if (Double.isNaN(x[i]) || Double.isNaN(y[i])) continue;
                ++m;
                double d = x[i] - y[i];
                dist += this.weight[i] * d * d;
            }
        }
        dist = m == 0 ? Double.NaN : (double)n * dist / (double)m;
        return Math.sqrt(dist);
    }
}

