/*
 * Decompiled with CFR 0.152.
 */
package smile.math;

import java.lang.reflect.Array;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.ForkJoinPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smile.math.DifferentiableFunction;
import smile.math.DifferentiableMultivariateFunction;
import smile.math.Function;
import smile.math.MultivariateFunction;
import smile.math.Random;
import smile.math.SparseArray;
import smile.sort.QuickSelect;
import smile.sort.QuickSort;
import smile.sort.SortUtils;

public class Math {
    private static final Logger logger;
    public static final double E = java.lang.Math.E;
    public static final double PI = java.lang.Math.PI;
    public static double EPSILON;
    public static int RADIX;
    public static int DIGITS;
    public static int ROUND_STYLE;
    public static int MACHEP;
    public static int NEGEP;
    private static boolean firstRNG;
    private static ThreadLocal<Random> random;
    private static final double LOG2;

    private Math() {
    }

    public static double abs(double a) {
        return java.lang.Math.abs(a);
    }

    public static float abs(float a) {
        return java.lang.Math.abs(a);
    }

    public static int abs(int a) {
        return java.lang.Math.abs(a);
    }

    public static long abs(long a) {
        return java.lang.Math.abs(a);
    }

    public static double acos(double a) {
        return java.lang.Math.acos(a);
    }

    public static double asin(double a) {
        return java.lang.Math.asin(a);
    }

    public static double atan(double a) {
        return java.lang.Math.atan(a);
    }

    public static double atan2(double y, double x) {
        return java.lang.Math.atan2(y, x);
    }

    public static double cbrt(double a) {
        return java.lang.Math.cbrt(a);
    }

    public static double ceil(double a) {
        return java.lang.Math.ceil(a);
    }

    public static double copySign(double magnitude, double sign) {
        return java.lang.Math.copySign(magnitude, sign);
    }

    public static float copySign(float magnitude, float sign) {
        return java.lang.Math.copySign(magnitude, sign);
    }

    public static double cos(double a) {
        return java.lang.Math.cos(a);
    }

    public static double cosh(double x) {
        return java.lang.Math.cosh(x);
    }

    public static double exp(double a) {
        return java.lang.Math.exp(a);
    }

    public static double expm1(double x) {
        return java.lang.Math.expm1(x);
    }

    public static double floor(double a) {
        return java.lang.Math.floor(a);
    }

    public static int getExponent(double d) {
        return java.lang.Math.getExponent(d);
    }

    public static int getExponent(float f) {
        return java.lang.Math.getExponent(f);
    }

    public static double hypot(double x, double y) {
        return java.lang.Math.hypot(x, y);
    }

    public static double IEEEremainder(double f1, double f2) {
        return java.lang.Math.IEEEremainder(f1, f2);
    }

    public static double log(double a) {
        return java.lang.Math.log(a);
    }

    public static double log10(double a) {
        return java.lang.Math.log10(a);
    }

    public static double log1p(double x) {
        return java.lang.Math.log1p(x);
    }

    public static double max(double a, double b) {
        return java.lang.Math.max(a, b);
    }

    public static float max(float a, float b) {
        return java.lang.Math.max(a, b);
    }

    public static int max(int a, int b) {
        return java.lang.Math.max(a, b);
    }

    public static long max(long a, long b) {
        return java.lang.Math.max(a, b);
    }

    public static double min(double a, double b) {
        return java.lang.Math.min(a, b);
    }

    public static float min(float a, float b) {
        return java.lang.Math.min(a, b);
    }

    public static int min(int a, int b) {
        return java.lang.Math.min(a, b);
    }

    public static long min(long a, long b) {
        return java.lang.Math.min(a, b);
    }

    public static double nextAfter(double start, double direction) {
        return java.lang.Math.nextAfter(start, direction);
    }

    public static float nextAfter(float start, double direction) {
        return java.lang.Math.nextAfter(start, direction);
    }

    public static double nextUp(double d) {
        return java.lang.Math.nextUp(d);
    }

    public static float nextUp(float f) {
        return java.lang.Math.nextUp(f);
    }

    public static double pow(double a, double b) {
        return java.lang.Math.pow(a, b);
    }

    public static double rint(double a) {
        return java.lang.Math.rint(a);
    }

    public static long round(double a) {
        return java.lang.Math.round(a);
    }

    public static int round(float a) {
        return java.lang.Math.round(a);
    }

    public static double scalb(double d, int scaleFactor) {
        return java.lang.Math.scalb(d, scaleFactor);
    }

    public static float scalb(float f, int scaleFactor) {
        return java.lang.Math.scalb(f, scaleFactor);
    }

    public static double signum(double d) {
        return java.lang.Math.signum(d);
    }

    public static float signum(float f) {
        return java.lang.Math.signum(f);
    }

    public static double sin(double a) {
        return java.lang.Math.sin(a);
    }

    public static double sinh(double x) {
        return java.lang.Math.sinh(x);
    }

    public static double sqrt(double a) {
        return java.lang.Math.sqrt(a);
    }

    public static double tan(double a) {
        return java.lang.Math.tan(a);
    }

    public static double tanh(double x) {
        return java.lang.Math.tanh(x);
    }

    public static double toDegrees(double angrad) {
        return java.lang.Math.toDegrees(angrad);
    }

    public static double toRadians(double angdeg) {
        return java.lang.Math.toRadians(angdeg);
    }

    public static double ulp(double d) {
        return java.lang.Math.ulp(d);
    }

    public static float ulp(float f) {
        return java.lang.Math.ulp(f);
    }

    public static double log2(double x) {
        return java.lang.Math.log(x) / LOG2;
    }

    public static boolean equals(double a, double b) {
        if (a == b) {
            return true;
        }
        double absa = Math.abs(a);
        double absb = Math.abs(b);
        return Math.abs(a - b) <= Math.min(absa, absb) * 2.220446049250313E-16;
    }

    public static double logistic(double x) {
        double y = 0.0;
        y = x < -40.0 ? 2.353853E17 : (x > 40.0 ? 1.0 : 1.0 + Math.exp(-x));
        return 1.0 / y;
    }

    public static double sqr(double x) {
        return x * x;
    }

    public static boolean isPower2(int x) {
        return x > 0 && (x & x - 1) == 0;
    }

    public static double round(double x, int decimal) {
        if (decimal < 0) {
            return (double)Math.round(x / Math.pow(10.0, (double)(-decimal))) * Math.pow(10.0, (double)(-decimal));
        }
        return (double)Math.round(x * Math.pow(10.0, (double)decimal)) / Math.pow(10.0, (double)decimal);
    }

    public static double factorial(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("n has to be nonnegative.");
        }
        double f = 1.0;
        for (int i = 2; i <= n; ++i) {
            f *= (double)i;
        }
        return f;
    }

    public static double logFactorial(int n) {
        if (n < 0) {
            throw new IllegalArgumentException(String.format("n has to be nonnegative: %d", n));
        }
        double f = 0.0;
        for (int i = 2; i <= n; ++i) {
            f += Math.log(i);
        }
        return f;
    }

    public static double choose(int n, int k) {
        if (n < 0 || k < 0) {
            throw new IllegalArgumentException(String.format("Invalid n = %d, k = %d", n, k));
        }
        if (n < k) {
            return 0.0;
        }
        return Math.floor(0.5 + Math.exp(Math.logChoose(n, k)));
    }

    public static double logChoose(int n, int k) {
        if (n < 0 || k < 0 || k > n) {
            throw new IllegalArgumentException(String.format("Invalid n = %d, k = %d", n, k));
        }
        return Math.logFactorial(n) - Math.logFactorial(k) - Math.logFactorial(n - k);
    }

    public static void setSeed(long seed) {
        random.get().setSeed(seed);
    }

    public static int random(double[] prob) {
        int[] ans = Math.random(prob, 1);
        return ans[0];
    }

    public static int[] random(double[] prob, int n) {
        double[] q = new double[prob.length];
        for (int i = 0; i < prob.length; ++i) {
            q[i] = prob[i] * (double)prob.length;
        }
        int[] a = new int[prob.length];
        for (int i = 0; i < prob.length; ++i) {
            a[i] = i;
        }
        int[] HL = new int[prob.length];
        int head = 0;
        int tail = prob.length - 1;
        for (int i = 0; i < prob.length; ++i) {
            if (q[i] >= 1.0) {
                HL[head++] = i;
                continue;
            }
            HL[tail--] = i;
        }
        while (head != 0 && tail != prob.length - 1) {
            int k;
            int j = HL[tail + 1];
            a[j] = k = HL[head - 1];
            int n2 = k;
            q[n2] = q[n2] + (q[j] - 1.0);
            ++tail;
            if (!(q[k] < 1.0)) continue;
            HL[tail--] = k;
            --head;
        }
        int[] ans = new int[n];
        for (int i = 0; i < n; ++i) {
            int k;
            double rU = Math.random() * (double)prob.length;
            ans[i] = (rU -= (double)(k = (int)rU)) < q[k] ? k : a[k];
        }
        return ans;
    }

    public static double random() {
        return random.get().nextDouble();
    }

    public static double[] random(int n) {
        double[] x = new double[n];
        random.get().nextDoubles(x);
        return x;
    }

    public static double random(double lo, double hi) {
        return random.get().nextDouble(lo, hi);
    }

    public static double[] random(double lo, double hi, int n) {
        double[] x = new double[n];
        random.get().nextDoubles(x, lo, hi);
        return x;
    }

    public static int randomInt(int n) {
        return random.get().nextInt(n);
    }

    public static int randomInt(int lo, int hi) {
        int w = hi - lo;
        return lo + random.get().nextInt(w);
    }

    public static int[] permutate(int n) {
        return random.get().permutate(n);
    }

    public static void permutate(int[] x) {
        random.get().permutate(x);
    }

    public static void permutate(float[] x) {
        random.get().permutate(x);
    }

    public static void permutate(double[] x) {
        random.get().permutate(x);
    }

    public static void permutate(Object[] x) {
        random.get().permutate(x);
    }

    public static int[] c(int ... x) {
        return x;
    }

    public static float[] c(float ... x) {
        return x;
    }

    public static double[] c(double ... x) {
        return x;
    }

    public static String[] c(String ... x) {
        return x;
    }

    public static int[] c(int[] ... list) {
        int n = Arrays.stream(list).mapToInt(x -> ((int[])x).length).sum();
        int[] y = new int[n];
        int pos = 0;
        for (int[] x2 : list) {
            System.arraycopy(x2, 0, y, pos, x2.length);
            pos += x2.length;
        }
        return y;
    }

    public static float[] c(float[] ... list) {
        int n = Arrays.stream(list).mapToInt(x -> ((float[])x).length).sum();
        float[] y = new float[n];
        int pos = 0;
        for (float[] x2 : list) {
            System.arraycopy(x2, 0, y, pos, x2.length);
            pos += x2.length;
        }
        return y;
    }

    public static double[] c(double[] ... list) {
        int n = Arrays.stream(list).mapToInt(x -> ((double[])x).length).sum();
        double[] y = new double[n];
        int pos = 0;
        for (double[] x2 : list) {
            System.arraycopy(x2, 0, y, pos, x2.length);
            pos += x2.length;
        }
        return y;
    }

    public static String[] c(String[] ... list) {
        int n = Arrays.stream(list).mapToInt(x -> ((String[])x).length).sum();
        String[] y = new String[n];
        int pos = 0;
        for (String[] x2 : list) {
            System.arraycopy(x2, 0, y, pos, x2.length);
            pos += x2.length;
        }
        return y;
    }

    public static int[] cbind(int[] ... x) {
        return Math.c(x);
    }

    public static float[] cbind(float[] ... x) {
        return Math.c(x);
    }

    public static double[] cbind(double[] ... x) {
        return Math.c(x);
    }

    public static String[] cbind(String[] ... x) {
        return Math.c(x);
    }

    public static int[][] rbind(int[] ... x) {
        return x;
    }

    public static float[][] rbind(float[] ... x) {
        return x;
    }

    public static double[][] rbind(double[] ... x) {
        return x;
    }

    public static String[][] rbind(String[] ... x) {
        return x;
    }

    public static <E> E[] slice(E[] data, int[] index) {
        int n = index.length;
        Object[] x = (Object[])Array.newInstance(data.getClass().getComponentType(), n);
        for (int i = 0; i < n; ++i) {
            x[i] = data[index[i]];
        }
        return x;
    }

    public static int[] slice(int[] data, int[] index) {
        int n = index.length;
        int[] x = new int[n];
        for (int i = 0; i < n; ++i) {
            x[i] = data[index[i]];
        }
        return x;
    }

    public static float[] slice(float[] data, int[] index) {
        int n = index.length;
        float[] x = new float[n];
        for (int i = 0; i < n; ++i) {
            x[i] = data[index[i]];
        }
        return x;
    }

    public static double[] slice(double[] data, int[] index) {
        int n = index.length;
        double[] x = new double[n];
        for (int i = 0; i < n; ++i) {
            x[i] = data[index[i]];
        }
        return x;
    }

    public static boolean contains(double[][] polygon, double[] point) {
        return Math.contains(polygon, point[0], point[1]);
    }

    /*
     * Unable to fully structure code
     */
    public static boolean contains(double[][] polygon, double x, double y) {
        if (polygon.length <= 2) {
            return false;
        }
        hits = 0;
        n = polygon.length;
        lastx = polygon[n - 1][0];
        lasty = polygon[n - 1][1];
        for (i = 0; i < n; ++i) {
            block8: {
                block11: {
                    block12: {
                        block10: {
                            block9: {
                                curx = polygon[i][0];
                                cury = polygon[i][1];
                                if (cury == lasty) break block8;
                                if (!(curx < lastx)) break block9;
                                if (x >= lastx) break block8;
                                leftx = curx;
                                break block10;
                            }
                            if (x >= curx) break block8;
                            leftx = lastx;
                        }
                        if (!(cury < lasty)) break block11;
                        if (y < cury || y >= lasty) break block8;
                        if (!(x < leftx)) break block12;
                        ++hits;
                        break block8;
                    }
                    test1 = x - curx;
                    test2 = y - cury;
                    ** GOTO lbl35
                }
                if (y < lasty || y >= cury) break block8;
                if (x < leftx) {
                    ++hits;
                } else {
                    test1 = x - lastx;
                    test2 = y - lasty;
lbl35:
                    // 2 sources

                    if (test1 < test2 / (lasty - cury) * (lastx - curx)) {
                        ++hits;
                    }
                }
            }
            lastx = curx;
            lasty = cury;
        }
        return (hits & true) != false;
    }

    public static void reverse(int[] a) {
        int i = 0;
        int j = a.length - 1;
        while (i < j) {
            SortUtils.swap(a, i++, j--);
        }
    }

    public static void reverse(float[] a) {
        int i = 0;
        int j = a.length - 1;
        while (i < j) {
            SortUtils.swap(a, i++, j--);
        }
    }

    public static void reverse(double[] a) {
        int i = 0;
        int j = a.length - 1;
        while (i < j) {
            SortUtils.swap(a, i++, j--);
        }
    }

    public static <T> void reverse(T[] a) {
        int i = 0;
        int j = a.length - 1;
        while (i < j) {
            SortUtils.swap(a, i++, j--);
        }
    }

    public static int min(int a, int b, int c) {
        return Math.min(Math.min(a, b), c);
    }

    public static double min(float a, float b, float c) {
        return Math.min(Math.min(a, b), c);
    }

    public static double min(double a, double b, double c) {
        return Math.min(Math.min(a, b), c);
    }

    public static int max(int a, int b, int c) {
        return Math.max(Math.max(a, b), c);
    }

    public static float max(float a, float b, float c) {
        return Math.max(Math.max(a, b), c);
    }

    public static double max(double a, double b, double c) {
        return Math.max(Math.max(a, b), c);
    }

    public static int min(int[] x) {
        int m = x[0];
        for (int n : x) {
            if (n >= m) continue;
            m = n;
        }
        return m;
    }

    public static float min(float[] x) {
        float m = Float.POSITIVE_INFINITY;
        for (float n : x) {
            if (!(n < m)) continue;
            m = n;
        }
        return m;
    }

    public static double min(double[] x) {
        double m = Double.POSITIVE_INFINITY;
        for (double n : x) {
            if (!(n < m)) continue;
            m = n;
        }
        return m;
    }

    public static int whichMin(int[] x) {
        int m = x[0];
        int which = 0;
        for (int i = 1; i < x.length; ++i) {
            if (x[i] >= m) continue;
            m = x[i];
            which = i;
        }
        return which;
    }

    public static int whichMin(float[] x) {
        float m = Float.POSITIVE_INFINITY;
        int which = 0;
        for (int i = 0; i < x.length; ++i) {
            if (!(x[i] < m)) continue;
            m = x[i];
            which = i;
        }
        return which;
    }

    public static int whichMin(double[] x) {
        double m = Double.POSITIVE_INFINITY;
        int which = 0;
        for (int i = 0; i < x.length; ++i) {
            if (!(x[i] < m)) continue;
            m = x[i];
            which = i;
        }
        return which;
    }

    public static int max(int[] x) {
        int m = x[0];
        for (int n : x) {
            if (n <= m) continue;
            m = n;
        }
        return m;
    }

    public static float max(float[] x) {
        float m = Float.NEGATIVE_INFINITY;
        for (float n : x) {
            if (!(n > m)) continue;
            m = n;
        }
        return m;
    }

    public static double max(double[] x) {
        double m = Double.NEGATIVE_INFINITY;
        for (double n : x) {
            if (!(n > m)) continue;
            m = n;
        }
        return m;
    }

    public static int whichMax(int[] x) {
        int m = x[0];
        int which = 0;
        for (int i = 1; i < x.length; ++i) {
            if (x[i] <= m) continue;
            m = x[i];
            which = i;
        }
        return which;
    }

    public static int whichMax(float[] x) {
        float m = Float.NEGATIVE_INFINITY;
        int which = 0;
        for (int i = 0; i < x.length; ++i) {
            if (!(x[i] > m)) continue;
            m = x[i];
            which = i;
        }
        return which;
    }

    public static int whichMax(double[] x) {
        double m = Double.NEGATIVE_INFINITY;
        int which = 0;
        for (int i = 0; i < x.length; ++i) {
            if (!(x[i] > m)) continue;
            m = x[i];
            which = i;
        }
        return which;
    }

    public static int min(int[][] matrix) {
        int m = matrix[0][0];
        int[][] nArray = matrix;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int[] x;
            for (int y : x = nArray[i]) {
                if (m <= y) continue;
                m = y;
            }
        }
        return m;
    }

    public static double min(double[][] matrix) {
        double m = Double.POSITIVE_INFINITY;
        double[][] dArray = matrix;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            double[] x;
            for (double y : x = dArray[i]) {
                if (!(m > y)) continue;
                m = y;
            }
        }
        return m;
    }

    public static int max(int[][] matrix) {
        int m = matrix[0][0];
        int[][] nArray = matrix;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int[] x;
            for (int y : x = nArray[i]) {
                if (m >= y) continue;
                m = y;
            }
        }
        return m;
    }

    public static double max(double[][] matrix) {
        double m = Double.NEGATIVE_INFINITY;
        double[][] dArray = matrix;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            double[] x;
            for (double y : x = dArray[i]) {
                if (!(m < y)) continue;
                m = y;
            }
        }
        return m;
    }

    public static double[][] transpose(double[][] A) {
        int m = A.length;
        int n = A[0].length;
        double[][] matrix = new double[n][m];
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                matrix[j][i] = A[i][j];
            }
        }
        return matrix;
    }

    public static double[] rowMin(double[][] data) {
        double[] x = new double[data.length];
        for (int i = 0; i < x.length; ++i) {
            x[i] = Math.min(data[i]);
        }
        return x;
    }

    public static double[] rowMax(double[][] data) {
        double[] x = new double[data.length];
        for (int i = 0; i < x.length; ++i) {
            x[i] = Math.max(data[i]);
        }
        return x;
    }

    public static double[] rowSums(double[][] data) {
        double[] x = new double[data.length];
        for (int i = 0; i < x.length; ++i) {
            x[i] = Math.sum(data[i]);
        }
        return x;
    }

    public static double[] rowMeans(double[][] data) {
        double[] x = new double[data.length];
        for (int i = 0; i < x.length; ++i) {
            x[i] = Math.mean(data[i]);
        }
        return x;
    }

    public static double[] rowSds(double[][] data) {
        double[] x = new double[data.length];
        for (int i = 0; i < x.length; ++i) {
            x[i] = Math.sd(data[i]);
        }
        return x;
    }

    public static double[] colMin(double[][] data) {
        int i;
        double[] x = new double[data[0].length];
        for (i = 0; i < x.length; ++i) {
            x[i] = Double.POSITIVE_INFINITY;
        }
        for (i = 0; i < data.length; ++i) {
            for (int j = 0; j < x.length; ++j) {
                if (!(x[j] > data[i][j])) continue;
                x[j] = data[i][j];
            }
        }
        return x;
    }

    public static double[] colMax(double[][] data) {
        int i;
        double[] x = new double[data[0].length];
        for (i = 0; i < x.length; ++i) {
            x[i] = Double.NEGATIVE_INFINITY;
        }
        for (i = 0; i < data.length; ++i) {
            for (int j = 0; j < x.length; ++j) {
                if (!(x[j] < data[i][j])) continue;
                x[j] = data[i][j];
            }
        }
        return x;
    }

    public static double[] colSums(double[][] data) {
        double[] x = (double[])data[0].clone();
        for (int i = 1; i < data.length; ++i) {
            for (int j = 0; j < x.length; ++j) {
                int n = j;
                x[n] = x[n] + data[i][j];
            }
        }
        return x;
    }

    public static double[] colMeans(double[][] data) {
        double[] x = (double[])data[0].clone();
        for (int i = 1; i < data.length; ++i) {
            for (int j = 0; j < x.length; ++j) {
                int n = j;
                x[n] = x[n] + data[i][j];
            }
        }
        Math.scale(1.0 / (double)data.length, x);
        return x;
    }

    public static double[] colSds(double[][] data) {
        if (data.length < 2) {
            throw new IllegalArgumentException("Array length is less than 2.");
        }
        int p = data[0].length;
        double[] sum = new double[p];
        double[] sumsq = new double[p];
        for (double[] x : data) {
            for (int i = 0; i < p; ++i) {
                int n = i;
                sum[n] = sum[n] + x[i];
                int n2 = i;
                sumsq[n2] = sumsq[n2] + x[i] * x[i];
            }
        }
        int n = data.length - 1;
        for (int i = 0; i < p; ++i) {
            sumsq[i] = java.lang.Math.sqrt(sumsq[i] / (double)n - sum[i] / (double)data.length * (sum[i] / (double)n));
        }
        return sumsq;
    }

    public static int sum(int[] x) {
        double sum = 0.0;
        for (int n : x) {
            sum += (double)n;
        }
        if (sum > 2.147483647E9 || sum < -2.147483647E9) {
            throw new ArithmeticException("Sum overflow: " + sum);
        }
        return (int)sum;
    }

    public static double sum(float[] x) {
        double sum = 0.0;
        for (float n : x) {
            sum += (double)n;
        }
        return sum;
    }

    public static double sum(double[] x) {
        double sum = 0.0;
        for (double n : x) {
            sum += n;
        }
        return sum;
    }

    public static int median(int[] a) {
        return QuickSelect.median(a);
    }

    public static float median(float[] a) {
        return QuickSelect.median(a);
    }

    public static double median(double[] a) {
        return QuickSelect.median(a);
    }

    public static <T extends Comparable<? super T>> T median(T[] a) {
        return (T)QuickSelect.median(a);
    }

    public static int q1(int[] a) {
        return QuickSelect.q1(a);
    }

    public static float q1(float[] a) {
        return QuickSelect.q1(a);
    }

    public static double q1(double[] a) {
        return QuickSelect.q1(a);
    }

    public static <T extends Comparable<? super T>> T q1(T[] a) {
        return (T)QuickSelect.q1(a);
    }

    public static int q3(int[] a) {
        return QuickSelect.q3(a);
    }

    public static float q3(float[] a) {
        return QuickSelect.q3(a);
    }

    public static double q3(double[] a) {
        return QuickSelect.q3(a);
    }

    public static <T extends Comparable<? super T>> T q3(T[] a) {
        return (T)QuickSelect.q3(a);
    }

    public static double mean(int[] x) {
        return (double)Math.sum(x) / (double)x.length;
    }

    public static double mean(float[] x) {
        return Math.sum(x) / (double)x.length;
    }

    public static double mean(double[] x) {
        return Math.sum(x) / (double)x.length;
    }

    public static double var(int[] x) {
        if (x.length < 2) {
            throw new IllegalArgumentException("Array length is less than 2.");
        }
        double sum = 0.0;
        double sumsq = 0.0;
        for (int xi : x) {
            sum += (double)xi;
            sumsq += (double)(xi * xi);
        }
        int n = x.length - 1;
        return sumsq / (double)n - sum / (double)x.length * (sum / (double)n);
    }

    public static double var(float[] x) {
        if (x.length < 2) {
            throw new IllegalArgumentException("Array length is less than 2.");
        }
        double sum = 0.0;
        double sumsq = 0.0;
        for (float xi : x) {
            sum += (double)xi;
            sumsq += (double)(xi * xi);
        }
        int n = x.length - 1;
        return sumsq / (double)n - sum / (double)x.length * (sum / (double)n);
    }

    public static double var(double[] x) {
        if (x.length < 2) {
            throw new IllegalArgumentException("Array length is less than 2.");
        }
        double sum = 0.0;
        double sumsq = 0.0;
        for (double xi : x) {
            sum += xi;
            sumsq += xi * xi;
        }
        int n = x.length - 1;
        return sumsq / (double)n - sum / (double)x.length * (sum / (double)n);
    }

    public static double sd(int[] x) {
        return Math.sqrt(Math.var(x));
    }

    public static double sd(float[] x) {
        return Math.sqrt(Math.var(x));
    }

    public static double sd(double[] x) {
        return Math.sqrt(Math.var(x));
    }

    public static double mad(int[] x) {
        int m = Math.median(x);
        for (int i = 0; i < x.length; ++i) {
            x[i] = Math.abs(x[i] - m);
        }
        return Math.median(x);
    }

    public static double mad(float[] x) {
        float m = Math.median(x);
        for (int i = 0; i < x.length; ++i) {
            x[i] = Math.abs(x[i] - m);
        }
        return Math.median(x);
    }

    public static double mad(double[] x) {
        double m = Math.median(x);
        for (int i = 0; i < x.length; ++i) {
            x[i] = Math.abs(x[i] - m);
        }
        return Math.median(x);
    }

    public static boolean all(boolean[] x) {
        for (boolean b : x) {
            if (b) continue;
            return false;
        }
        return true;
    }

    public static boolean any(boolean[] x) {
        for (boolean b : x) {
            if (!b) continue;
            return true;
        }
        return false;
    }

    public static double distance(int[] x, int[] y) {
        return Math.sqrt(Math.squaredDistance(x, y));
    }

    public static double distance(float[] x, float[] y) {
        return Math.sqrt(Math.squaredDistance(x, y));
    }

    public static double distance(double[] x, double[] y) {
        return Math.sqrt(Math.squaredDistance(x, y));
    }

    public static double distance(SparseArray x, SparseArray y) {
        return Math.sqrt(Math.squaredDistance(x, y));
    }

    public static double[][] pdist(double[][] x) {
        int n = x.length;
        double[][] dist = new double[n][n];
        Math.pdist(x, dist, false, false);
        return dist;
    }

    public static void pdist(double[][] x, double[][] dist, boolean squared, boolean half) {
        int n = x.length;
        if (n < 100) {
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < i; ++j) {
                    double d;
                    dist[i][j] = d = Math.distance(x[i], x[j]);
                    dist[j][i] = d;
                }
            }
        } else {
            int nprocs = Runtime.getRuntime().availableProcessors();
            ArrayList<PdistTask> tasks = new ArrayList<PdistTask>();
            for (int i = 0; i < nprocs; ++i) {
                PdistTask task = new PdistTask(x, dist, nprocs, i, squared, half);
                tasks.add(task);
            }
            ForkJoinPool.commonPool().invokeAll(tasks);
        }
    }

    public static double squaredDistance(int[] x, int[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException("Input vector sizes are different.");
        }
        double sum = 0.0;
        for (int i = 0; i < x.length; ++i) {
            sum += Math.sqr(x[i] - y[i]);
        }
        return sum;
    }

    public static double squaredDistance(float[] x, float[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException("Input vector sizes are different.");
        }
        double sum = 0.0;
        for (int i = 0; i < x.length; ++i) {
            sum += Math.sqr(x[i] - y[i]);
        }
        return sum;
    }

    public static double squaredDistance(double[] x, double[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException("Input vector sizes are different.");
        }
        double sum = 0.0;
        for (int i = 0; i < x.length; ++i) {
            sum += Math.sqr(x[i] - y[i]);
        }
        return sum;
    }

    public static double squaredDistance(SparseArray x, SparseArray y) {
        Iterator<SparseArray.Entry> it1 = x.iterator();
        Iterator<SparseArray.Entry> it2 = y.iterator();
        SparseArray.Entry e1 = it1.hasNext() ? it1.next() : null;
        SparseArray.Entry e2 = it2.hasNext() ? it2.next() : null;
        double sum = 0.0;
        while (e1 != null && e2 != null) {
            if (e1.i == e2.i) {
                sum += Math.sqr(e1.x - e2.x);
                e1 = it1.hasNext() ? it1.next() : null;
                e2 = it2.hasNext() ? it2.next() : null;
                continue;
            }
            if (e1.i > e2.i) {
                sum += Math.sqr(e2.x);
                e2 = it2.hasNext() ? it2.next() : null;
                continue;
            }
            sum += Math.sqr(e1.x);
            e1 = it1.hasNext() ? it1.next() : null;
        }
        while (it1.hasNext()) {
            sum += Math.sqr(it1.next().x);
        }
        while (it2.hasNext()) {
            sum += Math.sqr(it2.next().x);
        }
        return sum;
    }

    public static double KullbackLeiblerDivergence(double[] x, double[] y) {
        boolean intersection = false;
        double kl = 0.0;
        for (int i = 0; i < x.length; ++i) {
            if (x[i] == 0.0 || y[i] == 0.0) continue;
            intersection = true;
            kl += x[i] * Math.log(x[i] / y[i]);
        }
        if (intersection) {
            return kl;
        }
        return Double.POSITIVE_INFINITY;
    }

    public static double KullbackLeiblerDivergence(SparseArray x, SparseArray y) {
        if (x.isEmpty()) {
            throw new IllegalArgumentException("List x is empty.");
        }
        if (y.isEmpty()) {
            throw new IllegalArgumentException("List y is empty.");
        }
        Iterator<SparseArray.Entry> iterX = x.iterator();
        Iterator<SparseArray.Entry> iterY = y.iterator();
        SparseArray.Entry a = iterX.hasNext() ? iterX.next() : null;
        SparseArray.Entry b = iterY.hasNext() ? iterY.next() : null;
        boolean intersection = false;
        double kl = 0.0;
        while (a != null && b != null) {
            if (a.i < b.i) {
                a = iterX.hasNext() ? iterX.next() : null;
                continue;
            }
            if (a.i > b.i) {
                b = iterY.hasNext() ? iterY.next() : null;
                continue;
            }
            intersection = true;
            kl += a.x * Math.log(a.x / b.x);
            a = iterX.hasNext() ? iterX.next() : null;
            b = iterY.hasNext() ? iterY.next() : null;
        }
        if (intersection) {
            return kl;
        }
        return Double.POSITIVE_INFINITY;
    }

    public static double KullbackLeiblerDivergence(double[] x, SparseArray y) {
        return Math.KullbackLeiblerDivergence(y, x);
    }

    public static double KullbackLeiblerDivergence(SparseArray x, double[] y) {
        if (x.isEmpty()) {
            throw new IllegalArgumentException("List x is empty.");
        }
        Iterator<SparseArray.Entry> iter = x.iterator();
        boolean intersection = false;
        double kl = 0.0;
        while (iter.hasNext()) {
            SparseArray.Entry b = iter.next();
            int i = b.i;
            if (!(y[i] > 0.0)) continue;
            intersection = true;
            kl += b.x * Math.log(b.x / y[i]);
        }
        if (intersection) {
            return kl;
        }
        return Double.POSITIVE_INFINITY;
    }

    public static double JensenShannonDivergence(double[] x, double[] y) {
        double[] m = new double[x.length];
        for (int i = 0; i < m.length; ++i) {
            m[i] = (x[i] + y[i]) / 2.0;
        }
        return (Math.KullbackLeiblerDivergence(x, m) + Math.KullbackLeiblerDivergence(y, m)) / 2.0;
    }

    public static double JensenShannonDivergence(SparseArray x, SparseArray y) {
        if (x.isEmpty()) {
            throw new IllegalArgumentException("List x is empty.");
        }
        if (y.isEmpty()) {
            throw new IllegalArgumentException("List y is empty.");
        }
        Iterator<SparseArray.Entry> iterX = x.iterator();
        Iterator<SparseArray.Entry> iterY = y.iterator();
        SparseArray.Entry a = iterX.hasNext() ? iterX.next() : null;
        SparseArray.Entry b = iterY.hasNext() ? iterY.next() : null;
        double js = 0.0;
        while (a != null && b != null) {
            double mi;
            if (a.i < b.i) {
                mi = a.x / 2.0;
                js += a.x * Math.log(a.x / mi);
                a = iterX.hasNext() ? iterX.next() : null;
                continue;
            }
            if (a.i > b.i) {
                mi = b.x / 2.0;
                js += b.x * Math.log(b.x / mi);
                b = iterY.hasNext() ? iterY.next() : null;
                continue;
            }
            mi = (a.x + b.x) / 2.0;
            js += a.x * Math.log(a.x / mi) + b.x * Math.log(b.x / mi);
            a = iterX.hasNext() ? iterX.next() : null;
            b = iterY.hasNext() ? iterY.next() : null;
        }
        return js / 2.0;
    }

    public static double JensenShannonDivergence(double[] x, SparseArray y) {
        return Math.JensenShannonDivergence(y, x);
    }

    public static double JensenShannonDivergence(SparseArray x, double[] y) {
        if (x.isEmpty()) {
            throw new IllegalArgumentException("List x is empty.");
        }
        Iterator<SparseArray.Entry> iter = x.iterator();
        double js = 0.0;
        while (iter.hasNext()) {
            SparseArray.Entry b = iter.next();
            int i = b.i;
            double mi = (b.x + y[i]) / 2.0;
            js += b.x * Math.log(b.x / mi);
            if (!(y[i] > 0.0)) continue;
            js += y[i] * Math.log(y[i] / mi);
        }
        return js / 2.0;
    }

    public static double dot(int[] x, int[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException("Arrays have different length.");
        }
        double p = 0.0;
        for (int i = 0; i < x.length; ++i) {
            p += (double)(x[i] * y[i]);
        }
        return p;
    }

    public static double dot(float[] x, float[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException("Arrays have different length.");
        }
        double p = 0.0;
        for (int i = 0; i < x.length; ++i) {
            p += (double)(x[i] * y[i]);
        }
        return p;
    }

    public static double dot(double[] x, double[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException("Arrays have different length.");
        }
        double p = 0.0;
        for (int i = 0; i < x.length; ++i) {
            p += x[i] * y[i];
        }
        return p;
    }

    public static double dot(SparseArray x, SparseArray y) {
        Iterator<SparseArray.Entry> it1 = x.iterator();
        Iterator<SparseArray.Entry> it2 = y.iterator();
        SparseArray.Entry e1 = it1.hasNext() ? it1.next() : null;
        SparseArray.Entry e2 = it2.hasNext() ? it2.next() : null;
        double s = 0.0;
        while (e1 != null && e2 != null) {
            if (e1.i == e2.i) {
                s += e1.x * e2.x;
                e1 = it1.hasNext() ? it1.next() : null;
                e2 = it2.hasNext() ? it2.next() : null;
                continue;
            }
            if (e1.i > e2.i) {
                e2 = it2.hasNext() ? it2.next() : null;
                continue;
            }
            e1 = it1.hasNext() ? it1.next() : null;
        }
        return s;
    }

    public static double cov(int[] x, int[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException("Arrays have different length.");
        }
        if (x.length < 3) {
            throw new IllegalArgumentException("array length has to be at least 3.");
        }
        double mx = Math.mean(x);
        double my = Math.mean(y);
        double Sxy = 0.0;
        for (int i = 0; i < x.length; ++i) {
            double dx = (double)x[i] - mx;
            double dy = (double)y[i] - my;
            Sxy += dx * dy;
        }
        return Sxy / (double)(x.length - 1);
    }

    public static double cov(float[] x, float[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException("Arrays have different length.");
        }
        if (x.length < 3) {
            throw new IllegalArgumentException("array length has to be at least 3.");
        }
        double mx = Math.mean(x);
        double my = Math.mean(y);
        double Sxy = 0.0;
        for (int i = 0; i < x.length; ++i) {
            double dx = (double)x[i] - mx;
            double dy = (double)y[i] - my;
            Sxy += dx * dy;
        }
        return Sxy / (double)(x.length - 1);
    }

    public static double cov(double[] x, double[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException("Arrays have different length.");
        }
        if (x.length < 3) {
            throw new IllegalArgumentException("array length has to be at least 3.");
        }
        double mx = Math.mean(x);
        double my = Math.mean(y);
        double Sxy = 0.0;
        for (int i = 0; i < x.length; ++i) {
            double dx = x[i] - mx;
            double dy = y[i] - my;
            Sxy += dx * dy;
        }
        return Sxy / (double)(x.length - 1);
    }

    public static double[][] cov(double[][] data) {
        return Math.cov(data, Math.colMeans(data));
    }

    public static double[][] cov(double[][] data, double[] mu) {
        int k;
        int j;
        double[][] sigma = new double[data[0].length][data[0].length];
        for (int i = 0; i < data.length; ++i) {
            for (j = 0; j < mu.length; ++j) {
                for (k = 0; k <= j; ++k) {
                    double[] dArray = sigma[j];
                    int n = k;
                    dArray[n] = dArray[n] + (data[i][j] - mu[j]) * (data[i][k] - mu[k]);
                }
            }
        }
        int n = data.length - 1;
        for (j = 0; j < mu.length; ++j) {
            for (k = 0; k <= j; ++k) {
                double[] dArray = sigma[j];
                int n2 = k;
                dArray[n2] = dArray[n2] / (double)n;
                sigma[k][j] = sigma[j][k];
            }
        }
        return sigma;
    }

    public static double cor(int[] x, int[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException("Arrays have different length.");
        }
        if (x.length < 3) {
            throw new IllegalArgumentException("array length has to be at least 3.");
        }
        double Sxy = Math.cov(x, y);
        double Sxx = Math.var(x);
        double Syy = Math.var(y);
        if (Sxx == 0.0 || Syy == 0.0) {
            return Double.NaN;
        }
        return Sxy / java.lang.Math.sqrt(Sxx * Syy);
    }

    public static double cor(float[] x, float[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException("Arrays have different length.");
        }
        if (x.length < 3) {
            throw new IllegalArgumentException("array length has to be at least 3.");
        }
        double Sxy = Math.cov(x, y);
        double Sxx = Math.var(x);
        double Syy = Math.var(y);
        if (Sxx == 0.0 || Syy == 0.0) {
            return Double.NaN;
        }
        return Sxy / java.lang.Math.sqrt(Sxx * Syy);
    }

    public static double cor(double[] x, double[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException("Arrays have different length.");
        }
        if (x.length < 3) {
            throw new IllegalArgumentException("array length has to be at least 3.");
        }
        double Sxy = Math.cov(x, y);
        double Sxx = Math.var(x);
        double Syy = Math.var(y);
        if (Sxx == 0.0 || Syy == 0.0) {
            return Double.NaN;
        }
        return Sxy / java.lang.Math.sqrt(Sxx * Syy);
    }

    public static double[][] cor(double[][] data) {
        return Math.cor(data, Math.colMeans(data));
    }

    public static double[][] cor(double[][] data, double[] mu) {
        int i;
        double[][] sigma = Math.cov(data, mu);
        int n = data[0].length;
        double[] sd = new double[n];
        for (i = 0; i < n; ++i) {
            sd[i] = Math.sqrt(sigma[i][i]);
        }
        for (i = 0; i < n; ++i) {
            for (int j = 0; j <= i; ++j) {
                double[] dArray = sigma[i];
                int n2 = j;
                dArray[n2] = dArray[n2] / (sd[i] * sd[j]);
                sigma[j][i] = sigma[i][j];
            }
        }
        return sigma;
    }

    private static double crank(double[] w) {
        int n = w.length;
        double s = 0.0;
        int j = 1;
        while (j < n) {
            int jt;
            if (w[j] != w[j - 1]) {
                w[j - 1] = j;
                ++j;
                continue;
            }
            for (jt = j + 1; jt <= n && w[jt - 1] == w[j - 1]; ++jt) {
            }
            double rank = 0.5 * (double)(j + jt - 1);
            for (int ji = j; ji <= jt - 1; ++ji) {
                w[ji - 1] = rank;
            }
            double t = jt - j;
            s += t * t * t - t;
            j = jt;
        }
        if (j == n) {
            w[n - 1] = n;
        }
        return s;
    }

    public static double spearman(int[] x, int[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException("Input vector sizes are different.");
        }
        int n = x.length;
        double[] wksp1 = new double[n];
        double[] wksp2 = new double[n];
        for (int j = 0; j < n; ++j) {
            wksp1[j] = x[j];
            wksp2[j] = y[j];
        }
        QuickSort.sort(wksp1, wksp2);
        double sf = Math.crank(wksp1);
        QuickSort.sort(wksp2, wksp1);
        double sg = Math.crank(wksp2);
        double d = 0.0;
        for (int j = 0; j < n; ++j) {
            d += Math.sqr(wksp1[j] - wksp2[j]);
        }
        int en = n;
        double en3n = en * en * en - en;
        double fac = (1.0 - sf / en3n) * (1.0 - sg / en3n);
        double rs = (1.0 - 6.0 / en3n * (d + (sf + sg) / 12.0)) / Math.sqrt(fac);
        return rs;
    }

    public static double spearman(float[] x, float[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException("Input vector sizes are different.");
        }
        int n = x.length;
        double[] wksp1 = new double[n];
        double[] wksp2 = new double[n];
        for (int j = 0; j < n; ++j) {
            wksp1[j] = x[j];
            wksp2[j] = y[j];
        }
        QuickSort.sort(wksp1, wksp2);
        double sf = Math.crank(wksp1);
        QuickSort.sort(wksp2, wksp1);
        double sg = Math.crank(wksp2);
        double d = 0.0;
        for (int j = 0; j < n; ++j) {
            d += Math.sqr(wksp1[j] - wksp2[j]);
        }
        int en = n;
        double en3n = en * en * en - en;
        double fac = (1.0 - sf / en3n) * (1.0 - sg / en3n);
        double rs = (1.0 - 6.0 / en3n * (d + (sf + sg) / 12.0)) / Math.sqrt(fac);
        return rs;
    }

    public static double spearman(double[] x, double[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException("Input vector sizes are different.");
        }
        int n = x.length;
        double[] wksp1 = new double[n];
        double[] wksp2 = new double[n];
        for (int j = 0; j < n; ++j) {
            wksp1[j] = x[j];
            wksp2[j] = y[j];
        }
        QuickSort.sort(wksp1, wksp2);
        double sf = Math.crank(wksp1);
        QuickSort.sort(wksp2, wksp1);
        double sg = Math.crank(wksp2);
        double d = 0.0;
        for (int j = 0; j < n; ++j) {
            d += Math.sqr(wksp1[j] - wksp2[j]);
        }
        int en = n;
        double en3n = en * en * en - en;
        double fac = (1.0 - sf / en3n) * (1.0 - sg / en3n);
        double rs = (1.0 - 6.0 / en3n * (d + (sf + sg) / 12.0)) / Math.sqrt(fac);
        return rs;
    }

    public static double kendall(int[] x, int[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException("Input vector sizes are different.");
        }
        int is = 0;
        int n2 = 0;
        int n1 = 0;
        int n = x.length;
        for (int j = 0; j < n - 1; ++j) {
            for (int k = j + 1; k < n; ++k) {
                double a1 = x[j] - x[k];
                double a2 = y[j] - y[k];
                double aa = a1 * a2;
                if (aa != 0.0) {
                    ++n1;
                    ++n2;
                    if (aa > 0.0) {
                        ++is;
                        continue;
                    }
                    --is;
                    continue;
                }
                if (a1 != 0.0) {
                    ++n1;
                }
                if (a2 == 0.0) continue;
                ++n2;
            }
        }
        double tau = (double)is / (Math.sqrt(n1) * Math.sqrt(n2));
        return tau;
    }

    public static double kendall(float[] x, float[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException("Input vector sizes are different.");
        }
        int is = 0;
        int n2 = 0;
        int n1 = 0;
        int n = x.length;
        for (int j = 0; j < n - 1; ++j) {
            for (int k = j + 1; k < n; ++k) {
                double a1 = x[j] - x[k];
                double a2 = y[j] - y[k];
                double aa = a1 * a2;
                if (aa != 0.0) {
                    ++n1;
                    ++n2;
                    if (aa > 0.0) {
                        ++is;
                        continue;
                    }
                    --is;
                    continue;
                }
                if (a1 != 0.0) {
                    ++n1;
                }
                if (a2 == 0.0) continue;
                ++n2;
            }
        }
        double tau = (double)is / (Math.sqrt(n1) * Math.sqrt(n2));
        return tau;
    }

    public static double kendall(double[] x, double[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException("Input vector sizes are different.");
        }
        int is = 0;
        int n2 = 0;
        int n1 = 0;
        int n = x.length;
        for (int j = 0; j < n - 1; ++j) {
            for (int k = j + 1; k < n; ++k) {
                double a1 = x[j] - x[k];
                double a2 = y[j] - y[k];
                double aa = a1 * a2;
                if (aa != 0.0) {
                    ++n1;
                    ++n2;
                    if (aa > 0.0) {
                        ++is;
                        continue;
                    }
                    --is;
                    continue;
                }
                if (a1 != 0.0) {
                    ++n1;
                }
                if (a2 == 0.0) continue;
                ++n2;
            }
        }
        double tau = (double)is / (Math.sqrt(n1) * Math.sqrt(n2));
        return tau;
    }

    public static double norm1(double[] x) {
        double norm = 0.0;
        for (double n : x) {
            norm += Math.abs(n);
        }
        return norm;
    }

    public static double norm2(double[] x) {
        double norm = 0.0;
        for (double n : x) {
            norm += n * n;
        }
        norm = Math.sqrt(norm);
        return norm;
    }

    public static double normInf(double[] x) {
        int n = x.length;
        double f = Math.abs(x[0]);
        for (int i = 1; i < n; ++i) {
            f = Math.max(f, Math.abs(x[i]));
        }
        return f;
    }

    public static double norm(double[] x) {
        return Math.norm2(x);
    }

    public static void standardize(double[] x) {
        double mu = Math.mean(x);
        double sigma = Math.sd(x);
        if (Math.isZero(sigma)) {
            logger.warn("array has variance of 0.");
            return;
        }
        for (int i = 0; i < x.length; ++i) {
            x[i] = (x[i] - mu) / sigma;
        }
    }

    public static void scale(double[][] x) {
        Math.scale(x, 0.0, 1.0);
    }

    public static void scale(double[][] x, double lo, double hi) {
        int n = x.length;
        int p = x[0].length;
        double[] min = Math.colMin(x);
        double[] max = Math.colMax(x);
        for (int j = 0; j < p; ++j) {
            int i;
            double scale = max[j] - min[j];
            if (!Math.isZero(scale)) {
                for (i = 0; i < n; ++i) {
                    x[i][j] = (x[i][j] - min[j]) / scale;
                }
                continue;
            }
            for (i = 0; i < n; ++i) {
                x[i][j] = 0.5;
            }
        }
    }

    public static void standardize(double[][] x) {
        int j;
        int n = x.length;
        int p = x[0].length;
        double[] center = Math.colMeans(x);
        for (int i = 0; i < n; ++i) {
            for (j = 0; j < p; ++j) {
                x[i][j] = x[i][j] - center[j];
            }
        }
        double[] scale = new double[p];
        for (j = 0; j < p; ++j) {
            int i;
            for (i = 0; i < n; ++i) {
                int n2 = j;
                scale[n2] = scale[n2] + Math.sqr(x[i][j]);
            }
            scale[j] = Math.sqrt(scale[j] / (double)(n - 1));
            if (Math.isZero(scale[j])) continue;
            for (i = 0; i < n; ++i) {
                double[] dArray = x[i];
                int n3 = j;
                dArray[n3] = dArray[n3] / scale[j];
            }
        }
    }

    public static void normalize(double[][] x) {
        Math.normalize(x, false);
    }

    public static void normalize(double[][] x, boolean centerizing) {
        int j;
        int i;
        int n = x.length;
        int p = x[0].length;
        if (centerizing) {
            double[] center = Math.colMeans(x);
            for (i = 0; i < n; ++i) {
                for (j = 0; j < p; ++j) {
                    x[i][j] = x[i][j] - center[j];
                }
            }
        }
        double[] scale = new double[p];
        for (int j2 = 0; j2 < p; ++j2) {
            for (int i2 = 0; i2 < n; ++i2) {
                int n2 = j2;
                scale[n2] = scale[n2] + Math.sqr(x[i2][j2]);
            }
            scale[j2] = Math.sqrt(scale[j2]);
        }
        for (i = 0; i < n; ++i) {
            for (j = 0; j < p; ++j) {
                if (Math.isZero(scale[j])) continue;
                double[] dArray = x[i];
                int n3 = j;
                dArray[n3] = dArray[n3] / scale[j];
            }
        }
    }

    public static void unitize(double[] x) {
        Math.unitize2(x);
    }

    public static void unitize1(double[] x) {
        double n = Math.norm1(x);
        int i = 0;
        while (i < x.length) {
            int n2 = i++;
            x[n2] = x[n2] / n;
        }
    }

    public static void unitize2(double[] x) {
        double n = Math.norm(x);
        int i = 0;
        while (i < x.length) {
            int n2 = i++;
            x[n2] = x[n2] / n;
        }
    }

    private static double smoothed(int x, double slope, double intercept) {
        return Math.exp(intercept + slope * Math.log(x));
    }

    private static int row(int[] r, int f) {
        int i;
        for (i = 0; i < r.length && r[i] < f; ++i) {
        }
        return i < r.length && r[i] == f ? i : -1;
    }

    public static double GoodTuring(int[] r, int[] Nr, double[] p) {
        int j;
        int i;
        double CONFID_FACTOR = 1.96;
        if (r.length != Nr.length) {
            throw new IllegalArgumentException("The sizes of r and Nr are not same.");
        }
        int len = r.length;
        double[] logR = new double[len];
        double[] logZ = new double[len];
        double[] Z = new double[len];
        int N = 0;
        for (int j2 = 0; j2 < len; ++j2) {
            N += r[j2] * Nr[j2];
        }
        int n1 = r[0] != 1 ? 0 : Nr[0];
        double p0 = (double)n1 / (double)N;
        for (int j3 = 0; j3 < len; ++j3) {
            int q = j3 == 0 ? 0 : r[j3 - 1];
            int t = j3 == len - 1 ? 2 * r[j3] - q : r[j3 + 1];
            Z[j3] = 2.0 * (double)Nr[j3] / (double)(t - q);
            logR[j3] = Math.log(r[j3]);
            logZ[j3] = Math.log(Z[j3]);
        }
        double XYs = 0.0;
        double Xsquares = 0.0;
        double meanX = 0.0;
        double meanY = 0.0;
        for (i = 0; i < len; ++i) {
            meanX += logR[i];
            meanY += logZ[i];
        }
        meanX /= (double)len;
        meanY /= (double)len;
        for (i = 0; i < len; ++i) {
            XYs += (logR[i] - meanX) * (logZ[i] - meanY);
            Xsquares += Math.sqr(logR[i] - meanX);
        }
        double slope = XYs / Xsquares;
        double intercept = meanY - slope * meanX;
        boolean indiffValsSeen = false;
        for (int j4 = 0; j4 < len; ++j4) {
            double y = (double)(r[j4] + 1) * Math.smoothed(r[j4] + 1, slope, intercept) / Math.smoothed(r[j4], slope, intercept);
            if (Math.row(r, r[j4] + 1) < 0) {
                indiffValsSeen = true;
            }
            if (!indiffValsSeen) {
                int n = Nr[Math.row(r, r[j4] + 1)];
                double x = (double)((r[j4] + 1) * n) / (double)Nr[j4];
                if (Math.abs(x - y) <= 1.96 * Math.sqrt(Math.sqr((double)r[j4] + 1.0) * (double)n / Math.sqr(Nr[j4]) * (1.0 + (double)n / (double)Nr[j4]))) {
                    indiffValsSeen = true;
                } else {
                    p[j4] = x;
                }
            }
            if (!indiffValsSeen) continue;
            p[j4] = y;
        }
        double Nprime = 0.0;
        for (j = 0; j < len; ++j) {
            Nprime += (double)Nr[j] * p[j];
        }
        for (j = 0; j < len; ++j) {
            p[j] = (1.0 - p0) * p[j] / Nprime;
        }
        return p0;
    }

    public static boolean equals(int[] x, int[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException(String.format("Arrays have different length: x[%d], y[%d]", x.length, y.length));
        }
        for (int i = 0; i < x.length; ++i) {
            if (x[i] == y[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(float[] x, float[] y) {
        return Math.equals(x, y, 1.0E-7f);
    }

    public static boolean equals(float[] x, float[] y, float epsilon) {
        if (x.length != y.length) {
            throw new IllegalArgumentException(String.format("Arrays have different length: x[%d], y[%d]", x.length, y.length));
        }
        for (int i = 0; i < x.length; ++i) {
            if (!(Math.abs(x[i] - y[i]) > epsilon)) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(double[] x, double[] y) {
        return Math.equals(x, y, 1.0E-10);
    }

    public static boolean equals(double[] x, double[] y, double eps) {
        if (x.length != y.length) {
            throw new IllegalArgumentException(String.format("Arrays have different length: x[%d], y[%d]", x.length, y.length));
        }
        if (eps <= 0.0) {
            throw new IllegalArgumentException("Invalid epsilon: " + eps);
        }
        for (int i = 0; i < x.length; ++i) {
            if (!(Math.abs(x[i] - y[i]) > eps)) continue;
            return false;
        }
        return true;
    }

    public static <T extends Comparable<? super T>> boolean equals(T[] x, T[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException(String.format("Arrays have different length: x[%d], y[%d]", x.length, y.length));
        }
        for (int i = 0; i < x.length; ++i) {
            if (x[i].compareTo(y[i]) == 0) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(int[][] x, int[][] y) {
        if (x.length != y.length || x[0].length != y[0].length) {
            throw new IllegalArgumentException(String.format("Matrices have different rows: %d x %d vs %d x %d", x.length, x[0].length, y.length, y[0].length));
        }
        for (int i = 0; i < x.length; ++i) {
            for (int j = 0; j < x[i].length; ++j) {
                if (x[i][j] == y[i][j]) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean equals(float[][] x, float[][] y) {
        return Math.equals(x, y, 1.0E-7f);
    }

    public static boolean equals(float[][] x, float[][] y, float epsilon) {
        if (x.length != y.length || x[0].length != y[0].length) {
            throw new IllegalArgumentException(String.format("Matrices have different rows: %d x %d vs %d x %d", x.length, x[0].length, y.length, y[0].length));
        }
        for (int i = 0; i < x.length; ++i) {
            for (int j = 0; j < x[i].length; ++j) {
                if (!(Math.abs(x[i][j] - y[i][j]) > epsilon)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean equals(double[][] x, double[][] y) {
        return Math.equals(x, y, 1.0E-10);
    }

    public static boolean equals(double[][] x, double[][] y, double eps) {
        if (x.length != y.length || x[0].length != y[0].length) {
            throw new IllegalArgumentException(String.format("Matrices have different rows: %d x %d vs %d x %d", x.length, x[0].length, y.length, y[0].length));
        }
        if (eps <= 0.0) {
            throw new IllegalArgumentException("Invalid epsilon: " + eps);
        }
        for (int i = 0; i < x.length; ++i) {
            for (int j = 0; j < x[i].length; ++j) {
                if (!(Math.abs(x[i][j] - y[i][j]) > eps)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isZero(float x) {
        return Math.isZero((double)x, EPSILON);
    }

    public static boolean isZero(float x, float epsilon) {
        return Math.abs(x) < epsilon;
    }

    public static boolean isZero(double x) {
        return Math.isZero(x, EPSILON);
    }

    public static boolean isZero(double x, double epsilon) {
        return Math.abs(x) < epsilon;
    }

    public static <T extends Comparable<? super T>> boolean equals(T[][] x, T[][] y) {
        if (x.length != y.length || x[0].length != y[0].length) {
            throw new IllegalArgumentException(String.format("Matrices have different rows: %d x %d vs %d x %d", x.length, x[0].length, y.length, y[0].length));
        }
        for (int i = 0; i < x.length; ++i) {
            for (int j = 0; j < x[i].length; ++j) {
                if (x[i][j].compareTo(y[i][j]) == 0) continue;
                return false;
            }
        }
        return true;
    }

    public static int[][] clone(int[][] x) {
        int[][] matrix = new int[x.length][];
        for (int i = 0; i < x.length; ++i) {
            matrix[i] = (int[])x[i].clone();
        }
        return matrix;
    }

    public static float[][] clone(float[][] x) {
        float[][] matrix = new float[x.length][];
        for (int i = 0; i < x.length; ++i) {
            matrix[i] = (float[])x[i].clone();
        }
        return matrix;
    }

    public static double[][] clone(double[][] x) {
        double[][] matrix = new double[x.length][];
        for (int i = 0; i < x.length; ++i) {
            matrix[i] = (double[])x[i].clone();
        }
        return matrix;
    }

    public static void swap(int[] x, int i, int j) {
        int s = x[i];
        x[i] = x[j];
        x[j] = s;
    }

    public static void swap(float[] x, int i, int j) {
        float s = x[i];
        x[i] = x[j];
        x[j] = s;
    }

    public static void swap(double[] x, int i, int j) {
        double s = x[i];
        x[i] = x[j];
        x[j] = s;
    }

    public static void swap(Object[] x, int i, int j) {
        Object s = x[i];
        x[i] = x[j];
        x[j] = s;
    }

    public static void swap(int[] x, int[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException(String.format("Arrays have different length: x[%d], y[%d]", x.length, y.length));
        }
        for (int i = 0; i < x.length; ++i) {
            int s = x[i];
            x[i] = y[i];
            y[i] = s;
        }
    }

    public static void swap(float[] x, float[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException(String.format("Arrays have different length: x[%d], y[%d]", x.length, y.length));
        }
        for (int i = 0; i < x.length; ++i) {
            float s = x[i];
            x[i] = y[i];
            y[i] = s;
        }
    }

    public static void swap(double[] x, double[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException(String.format("Arrays have different length: x[%d], y[%d]", x.length, y.length));
        }
        for (int i = 0; i < x.length; ++i) {
            double s = x[i];
            x[i] = y[i];
            y[i] = s;
        }
    }

    public static <E> void swap(E[] x, E[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException(String.format("Arrays have different length: x[%d], y[%d]", x.length, y.length));
        }
        for (int i = 0; i < x.length; ++i) {
            E s = x[i];
            x[i] = y[i];
            y[i] = s;
        }
    }

    public static void copy(int[] x, int[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException(String.format("Arrays have different length: x[%d], y[%d]", x.length, y.length));
        }
        System.arraycopy(x, 0, y, 0, x.length);
    }

    public static void copy(float[] x, float[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException(String.format("Arrays have different length: x[%d], y[%d]", x.length, y.length));
        }
        System.arraycopy(x, 0, y, 0, x.length);
    }

    public static void copy(double[] x, double[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException(String.format("Arrays have different length: x[%d], y[%d]", x.length, y.length));
        }
        System.arraycopy(x, 0, y, 0, x.length);
    }

    public static void copy(int[][] x, int[][] y) {
        if (x.length != y.length || x[0].length != y[0].length) {
            throw new IllegalArgumentException(String.format("Matrices have different rows: %d x %d vs %d x %d", x.length, x[0].length, y.length, y[0].length));
        }
        for (int i = 0; i < x.length; ++i) {
            System.arraycopy(x[i], 0, y[i], 0, x[i].length);
        }
    }

    public static void copy(float[][] x, float[][] y) {
        if (x.length != y.length || x[0].length != y[0].length) {
            throw new IllegalArgumentException(String.format("Matrices have different rows: %d x %d vs %d x %d", x.length, x[0].length, y.length, y[0].length));
        }
        for (int i = 0; i < x.length; ++i) {
            System.arraycopy(x[i], 0, y[i], 0, x[i].length);
        }
    }

    public static void copy(double[][] x, double[][] y) {
        if (x.length != y.length || x[0].length != y[0].length) {
            throw new IllegalArgumentException(String.format("Matrices have different rows: %d x %d vs %d x %d", x.length, x[0].length, y.length, y[0].length));
        }
        for (int i = 0; i < x.length; ++i) {
            System.arraycopy(x[i], 0, y[i], 0, x[i].length);
        }
    }

    public static void plus(double[] y, double[] x) {
        if (x.length != y.length) {
            throw new IllegalArgumentException(String.format("Arrays have different length: x[%d], y[%d]", x.length, y.length));
        }
        for (int i = 0; i < x.length; ++i) {
            int n = i;
            y[n] = y[n] + x[i];
        }
    }

    public static void minus(double[] y, double[] x) {
        if (x.length != y.length) {
            throw new IllegalArgumentException(String.format("Arrays have different length: x[%d], y[%d]", x.length, y.length));
        }
        for (int i = 0; i < x.length; ++i) {
            int n = i;
            y[n] = y[n] - x[i];
        }
    }

    public static void scale(double a, double[] x) {
        int i = 0;
        while (i < x.length) {
            int n = i++;
            x[n] = x[n] * a;
        }
    }

    public static void scale(double a, double[] x, double[] y) {
        for (int i = 0; i < x.length; ++i) {
            y[i] = a * x[i];
        }
    }

    public static double[] axpy(double a, double[] x, double[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException(String.format("Arrays have different length: x[%d], y[%d]", x.length, y.length));
        }
        for (int i = 0; i < x.length; ++i) {
            int n = i;
            y[n] = y[n] + a * x[i];
        }
        return y;
    }

    public static double[] pow(double[] x, double n) {
        double[] array = new double[x.length];
        for (int i = 0; i < x.length; ++i) {
            array[i] = Math.pow(x[i], n);
        }
        return array;
    }

    public static int[] unique(int[] x) {
        HashSet<Integer> hash = new HashSet<Integer>();
        for (int i = 0; i < x.length; ++i) {
            hash.add(x[i]);
        }
        int[] y = new int[hash.size()];
        Iterator keys = hash.iterator();
        for (int i = 0; i < y.length; ++i) {
            y[i] = (Integer)keys.next();
        }
        return y;
    }

    public static String[] unique(String[] x) {
        HashSet<String> hash = new HashSet<String>(Arrays.asList(x));
        String[] y = new String[hash.size()];
        Iterator<String> keys = hash.iterator();
        for (int i = 0; i < y.length; ++i) {
            y[i] = keys.next();
        }
        return y;
    }

    public static int[][] sort(double[][] x) {
        int n = x.length;
        int p = x[0].length;
        double[] a = new double[n];
        int[][] index = new int[p][];
        for (int j = 0; j < p; ++j) {
            for (int i = 0; i < n; ++i) {
                a[i] = x[i][j];
            }
            index[j] = QuickSort.sort(a);
        }
        return index;
    }

    public static double[] solve(double[] a, double[] b, double[] c, double[] r) {
        int j;
        if (b[0] == 0.0) {
            throw new IllegalArgumentException("Invalid value of b[0] == 0. The equations should be rewritten as a set of order n - 1.");
        }
        int n = a.length;
        double[] u = new double[n];
        double[] gam = new double[n];
        double bet = b[0];
        u[0] = r[0] / bet;
        for (j = 1; j < n; ++j) {
            gam[j] = c[j - 1] / bet;
            bet = b[j] - a[j] * gam[j];
            if (bet == 0.0) {
                throw new IllegalArgumentException("The tridagonal matrix is not of diagonal dominance.");
            }
            u[j] = (r[j] - a[j] * u[j - 1]) / bet;
        }
        for (j = n - 2; j >= 0; --j) {
            int n2 = j;
            u[n2] = u[n2] - gam[j + 1] * u[j + 1];
        }
        return u;
    }

    public static double root(Function func, double x1, double x2, double tol) {
        return Math.root(func, x1, x2, tol, 100);
    }

    public static double root(Function func, double x1, double x2, double tol, int maxIter) {
        if (tol <= 0.0) {
            throw new IllegalArgumentException("Invalid tolerance: " + tol);
        }
        if (maxIter <= 0) {
            throw new IllegalArgumentException("Invalid maximum number of iterations: " + maxIter);
        }
        double a = x1;
        double b = x2;
        double c = x2;
        double d = 0.0;
        double e = 0.0;
        double fa = func.f(a);
        double fb = func.f(b);
        if (fa > 0.0 && fb > 0.0 || fa < 0.0 && fb < 0.0) {
            throw new IllegalArgumentException("Root must be bracketed.");
        }
        double fc = fb;
        for (int iter = 1; iter <= maxIter; ++iter) {
            if (fb > 0.0 && fc > 0.0 || fb < 0.0 && fc < 0.0) {
                c = a;
                fc = fa;
                e = d = b - a;
            }
            if (Math.abs(fc) < Math.abs(fb)) {
                a = b;
                b = c;
                c = a;
                fa = fb;
                fb = fc;
                fc = fa;
            }
            tol = 2.0 * EPSILON * Math.abs(b) + 0.5 * tol;
            double xm = 0.5 * (c - b);
            if (iter % 10 == 0) {
                logger.info(String.format("Brent: the root after %3d iterations: %.5g, error = %.5g", iter, b, xm));
            }
            if (Math.abs(xm) <= tol || fb == 0.0) {
                logger.info(String.format("Brent: the root after %3d iterations: %.5g, error = %.5g", iter, b, xm));
                return b;
            }
            if (Math.abs(e) >= tol && Math.abs(fa) > Math.abs(fb)) {
                double min2;
                double q;
                double p;
                double s = fb / fa;
                if (a == c) {
                    p = 2.0 * xm * s;
                    q = 1.0 - s;
                } else {
                    q = fa / fc;
                    double r = fb / fc;
                    p = s * (2.0 * xm * q * (q - r) - (b - a) * (r - 1.0));
                    q = (q - 1.0) * (r - 1.0) * (s - 1.0);
                }
                if (p > 0.0) {
                    q = -q;
                }
                p = Math.abs(p);
                double min1 = 3.0 * xm * q - Math.abs(tol * q);
                double d2 = min1 < (min2 = Math.abs(e * q)) ? min1 : min2;
                if (2.0 * p < d2) {
                    e = d;
                    d = p / q;
                } else {
                    e = d = xm;
                }
            } else {
                e = d = xm;
            }
            a = b;
            fa = fb;
            b = Math.abs(d) > tol ? (b += d) : (b += Math.copySign(tol, xm));
            fb = func.f(b);
        }
        logger.error("Brent's method exceeded the maximum number of iterations.");
        return b;
    }

    public static double root(DifferentiableFunction func, double x1, double x2, double tol) {
        return Math.root(func, x1, x2, tol, 100);
    }

    public static double root(DifferentiableFunction func, double x1, double x2, double tol, int maxIter) {
        double dxold;
        double xh;
        double xl;
        if (tol <= 0.0) {
            throw new IllegalArgumentException("Invalid tolerance: " + tol);
        }
        if (maxIter <= 0) {
            throw new IllegalArgumentException("Invalid maximum number of iterations: " + maxIter);
        }
        double fl = func.f(x1);
        double fh = func.f(x2);
        if (fl > 0.0 && fh > 0.0 || fl < 0.0 && fh < 0.0) {
            throw new IllegalArgumentException("Root must be bracketed in rtsafe");
        }
        if (fl == 0.0) {
            return x1;
        }
        if (fh == 0.0) {
            return x2;
        }
        if (fl < 0.0) {
            xl = x1;
            xh = x2;
        } else {
            xh = x1;
            xl = x2;
        }
        double rts = 0.5 * (x1 + x2);
        double dx = dxold = Math.abs(x2 - x1);
        double f = func.f(rts);
        double df = func.df(rts);
        for (int iter = 1; iter <= maxIter; ++iter) {
            if (((rts - xh) * df - f) * ((rts - xl) * df - f) > 0.0 || Math.abs(2.0 * f) > Math.abs(dxold * df)) {
                dxold = dx;
                dx = 0.5 * (xh - xl);
                rts = xl + dx;
                if (xl == rts) {
                    logger.info(String.format("Newton-Raphson: the root after %3d iterations: %.5g, error = %.5g", iter, rts, dx));
                    return rts;
                }
            } else {
                dxold = dx;
                double temp = rts;
                dx = f / df;
                if (temp == (rts -= dx)) {
                    logger.info(String.format("Newton-Raphson: the root after %3d iterations: %.5g, error = %.5g", iter, rts, dx));
                    return rts;
                }
            }
            if (iter % 10 == 0) {
                logger.info(String.format("Newton-Raphson: the root after %3d iterations: %.5g, error = %.5g", iter, rts, dx));
            }
            if (Math.abs(dx) < tol) {
                logger.info(String.format("Newton-Raphson: the root after %3d iterations: %.5g, error = %.5g", iter, rts, dx));
                return rts;
            }
            f = func.f(rts);
            df = func.df(rts);
            if (f < 0.0) {
                xl = rts;
                continue;
            }
            xh = rts;
        }
        logger.error("Newton-Raphson method exceeded the maximum number of iterations.");
        return rts;
    }

    static double linesearch(MultivariateFunction func, double[] xold, double fold, double[] g, double[] p, double[] x, double stpmax) {
        int i;
        if (stpmax <= 0.0) {
            throw new IllegalArgumentException("Invalid upper bound of linear search step: " + stpmax);
        }
        double xtol = EPSILON;
        double ftol = 1.0E-4;
        int n = xold.length;
        double pnorm = Math.norm(p);
        if (pnorm > stpmax) {
            double r = stpmax / pnorm;
            i = 0;
            while (i < n) {
                int n2 = i++;
                p[n2] = p[n2] * r;
            }
        }
        double slope = 0.0;
        for (i = 0; i < n; ++i) {
            slope += g[i] * p[i];
        }
        if (slope >= 0.0) {
            throw new IllegalArgumentException("Line Search: the search direction is not a descent direction, which may be caused by roundoff problem.");
        }
        double test = 0.0;
        for (int i2 = 0; i2 < n; ++i2) {
            double temp = Math.abs(p[i2]) / Math.max(xold[i2], 1.0);
            if (!(temp > test)) continue;
            test = temp;
        }
        double alammin = xtol / test;
        double alam = 1.0;
        double alam2 = 0.0;
        double f2 = 0.0;
        while (true) {
            double tmpalam;
            for (int i3 = 0; i3 < n; ++i3) {
                x[i3] = xold[i3] + alam * p[i3];
            }
            double f = func.f(x);
            if (alam < alammin) {
                System.arraycopy(xold, 0, x, 0, n);
                return f;
            }
            if (f <= fold + 1.0E-4 * alam * slope) {
                return f;
            }
            if (alam == 1.0) {
                tmpalam = -slope / (2.0 * (f - fold - slope));
            } else {
                double disc;
                double rhs1 = f - fold - alam * slope;
                double rhs2 = f2 - fold - alam2 * slope;
                double a = (rhs1 / (alam * alam) - rhs2 / (alam2 * alam2)) / (alam - alam2);
                double b = (-alam2 * rhs1 / (alam * alam) + alam * rhs2 / (alam2 * alam2)) / (alam - alam2);
                tmpalam = a == 0.0 ? -slope / (2.0 * b) : ((disc = b * b - 3.0 * a * slope) < 0.0 ? 0.5 * alam : (b <= 0.0 ? (-b + Math.sqrt(disc)) / (3.0 * a) : -slope / (b + Math.sqrt(disc))));
                if (tmpalam > 0.5 * alam) {
                    tmpalam = 0.5 * alam;
                }
            }
            alam2 = alam;
            f2 = f;
            alam = Math.max(tmpalam, 0.1 * alam);
        }
    }

    public static double min(DifferentiableMultivariateFunction func, int m, double[] x, double gtol) {
        return Math.min(func, m, x, gtol, 200);
    }

    public static double min(DifferentiableMultivariateFunction func, int m, double[] x, double gtol, int maxIter) {
        if (m <= 0) {
            throw new IllegalArgumentException("Invalid m: " + m);
        }
        double TOLX = 4.0 * EPSILON;
        double STPMX = 100.0;
        int n = x.length;
        double[] xnew = new double[n];
        double[] gnew = new double[n];
        double[] xi = new double[n];
        double[][] s = new double[m][n];
        double[][] y = new double[m][n];
        double[] rho = new double[m];
        double[] a = new double[m];
        double diag = 1.0;
        double[] g = new double[n];
        double f = func.f(x, g);
        logger.info(String.format("L-BFGS: initial function value: %.5g", f));
        double sum = 0.0;
        for (int i = 0; i < n; ++i) {
            xi[i] = -g[i];
            sum += x[i] * x[i];
        }
        double stpmax = 100.0 * Math.max(Math.sqrt(sum), (double)n);
        int k = 0;
        for (int iter = 1; iter <= maxIter; ++iter) {
            int i;
            Math.linesearch(func, x, f, g, xi, xnew, stpmax);
            f = func.f(xnew, gnew);
            for (int i2 = 0; i2 < n; ++i2) {
                s[k][i2] = xnew[i2] - x[i2];
                y[k][i2] = gnew[i2] - g[i2];
                x[i2] = xnew[i2];
                g[i2] = gnew[i2];
            }
            double test = 0.0;
            for (int i3 = 0; i3 < n; ++i3) {
                double temp = Math.abs(s[k][i3]) / Math.max(Math.abs(x[i3]), 1.0);
                if (!(temp > test)) continue;
                test = temp;
            }
            if (test < TOLX) {
                logger.info(String.format("L-BFGS: the function value after %3d iterations: %.5g", iter, f));
                return f;
            }
            test = 0.0;
            double den = Math.max(f, 1.0);
            for (int i4 = 0; i4 < n; ++i4) {
                double temp = Math.abs(g[i4]) * Math.max(Math.abs(x[i4]), 1.0) / den;
                if (!(temp > test)) continue;
                test = temp;
            }
            if (test < gtol) {
                logger.info(String.format("L-BFGS: the function value after %3d iterations: %.5g", iter, f));
                return f;
            }
            if (iter % 10 == 0) {
                logger.info(String.format("L-BFGS: the function value after %3d iterations: %.5g", iter, f));
            }
            double ys = Math.dot(y[k], s[k]);
            double yy = Math.dot(y[k], y[k]);
            diag = ys / yy;
            rho[k] = 1.0 / ys;
            for (int i5 = 0; i5 < n; ++i5) {
                xi[i5] = -g[i5];
            }
            int cp = k;
            int bound = iter > m ? m : iter;
            for (i = 0; i < bound; ++i) {
                a[cp] = rho[cp] * Math.dot(s[cp], xi);
                Math.axpy(-a[cp], y[cp], xi);
                if (--cp != -1) continue;
                cp = m - 1;
            }
            i = 0;
            while (i < n) {
                int n2 = i++;
                xi[n2] = xi[n2] * diag;
            }
            for (i = 0; i < bound; ++i) {
                if (++cp == m) {
                    cp = 0;
                }
                double b = rho[cp] * Math.dot(y[cp], xi);
                Math.axpy(a[cp] - b, s[cp], xi);
            }
            if (++k != m) continue;
            k = 0;
        }
        throw new IllegalStateException("L-BFGS: Too many iterations.");
    }

    public static double min(DifferentiableMultivariateFunction func, double[] x, double gtol) {
        return Math.min(func, x, gtol, 200);
    }

    public static double min(DifferentiableMultivariateFunction func, double[] x, double gtol, int maxIter) {
        double TOLX = 4.0 * EPSILON;
        double STPMX = 100.0;
        int n = x.length;
        double[] dg = new double[n];
        double[] g = new double[n];
        double[] hdg = new double[n];
        double[] xnew = new double[n];
        double[] xi = new double[n];
        double[][] hessin = new double[n][n];
        double f = func.f(x, g);
        logger.info(String.format("BFGS: initial function value: %.5g", f));
        double sum = 0.0;
        for (int i = 0; i < n; ++i) {
            hessin[i][i] = 1.0;
            xi[i] = -g[i];
            sum += x[i] * x[i];
        }
        double stpmax = 100.0 * Math.max(Math.sqrt(sum), (double)n);
        for (int iter = 1; iter <= maxIter; ++iter) {
            int j;
            double temp;
            int i;
            f = Math.linesearch(func, x, f, g, xi, xnew, stpmax);
            if (iter % 10 == 0) {
                logger.info(String.format("BFGS: the function value after %3d iterations: %.5g", iter, f));
            }
            for (i = 0; i < n; ++i) {
                xi[i] = xnew[i] - x[i];
                x[i] = xnew[i];
            }
            double test = 0.0;
            for (i = 0; i < n; ++i) {
                temp = Math.abs(xi[i]) / Math.max(Math.abs(x[i]), 1.0);
                if (!(temp > test)) continue;
                test = temp;
            }
            if (test < TOLX) {
                logger.info(String.format("BFGS: the function value after %3d iterations: %.5g", iter, f));
                return f;
            }
            System.arraycopy(g, 0, dg, 0, n);
            func.f(x, g);
            double den = Math.max(f, 1.0);
            test = 0.0;
            for (i = 0; i < n; ++i) {
                temp = Math.abs(g[i]) * Math.max(Math.abs(x[i]), 1.0) / den;
                if (!(temp > test)) continue;
                test = temp;
            }
            if (test < gtol) {
                logger.info(String.format("BFGS: the function value after %3d iterations: %.5g", iter, f));
                return f;
            }
            for (i = 0; i < n; ++i) {
                dg[i] = g[i] - dg[i];
            }
            for (i = 0; i < n; ++i) {
                hdg[i] = 0.0;
                for (j = 0; j < n; ++j) {
                    int n2 = i;
                    hdg[n2] = hdg[n2] + hessin[i][j] * dg[j];
                }
            }
            double sumxi = 0.0;
            double sumdg = 0.0;
            double fae = 0.0;
            double fac = 0.0;
            for (i = 0; i < n; ++i) {
                fac += dg[i] * xi[i];
                fae += dg[i] * hdg[i];
                sumdg += dg[i] * dg[i];
                sumxi += xi[i] * xi[i];
            }
            if (fac > Math.sqrt(EPSILON * sumdg * sumxi)) {
                fac = 1.0 / fac;
                double fad = 1.0 / fae;
                for (i = 0; i < n; ++i) {
                    dg[i] = fac * xi[i] - fad * hdg[i];
                }
                for (i = 0; i < n; ++i) {
                    for (j = i; j < n; ++j) {
                        double[] dArray = hessin[i];
                        int n3 = j;
                        dArray[n3] = dArray[n3] + (fac * xi[i] * xi[j] - fad * hdg[i] * hdg[j] + fae * dg[i] * dg[j]);
                        hessin[j][i] = hessin[i][j];
                    }
                }
            }
            Arrays.fill(xi, 0.0);
            for (i = 0; i < n; ++i) {
                for (j = 0; j < n; ++j) {
                    int n4 = i;
                    xi[n4] = xi[n4] - hessin[i][j] * g[j];
                }
            }
        }
        throw new IllegalStateException("BFGS: Too many iterations.");
    }

    static {
        double temp;
        logger = LoggerFactory.getLogger(Math.class);
        EPSILON = Math.pow(2.0, -52.0);
        RADIX = 2;
        DIGITS = 53;
        ROUND_STYLE = 2;
        MACHEP = -52;
        NEGEP = -53;
        firstRNG = true;
        random = new ThreadLocal<Random>(){

            @Override
            protected synchronized Random initialValue() {
                if (firstRNG) {
                    firstRNG = false;
                    return new Random();
                }
                SecureRandom sr = new SecureRandom();
                byte[] bytes = sr.generateSeed(8);
                long seed = 0L;
                for (int i = 0; i < 8; ++i) {
                    seed <<= 8;
                    seed |= (long)(bytes[i] & 0xFF);
                }
                return new Random(seed);
            }
        };
        double ONE = 1.0;
        double TWO = ONE + ONE;
        double ZERO = ONE - ONE;
        double a = ONE;
        double temp1 = ONE;
        while (temp1 - ONE == ZERO) {
            a += a;
            temp = a + ONE;
            temp1 = temp - a;
        }
        double b = ONE;
        int itemp = 0;
        while (itemp == 0) {
            b += b;
            temp = a + b;
            itemp = (int)(temp - a);
        }
        RADIX = itemp;
        double beta = RADIX;
        DIGITS = 0;
        b = ONE;
        temp1 = ONE;
        while (temp1 - ONE == ZERO) {
            ++DIGITS;
            temp = (b *= beta) + ONE;
            temp1 = temp - b;
        }
        ROUND_STYLE = 0;
        double betah = beta / TWO;
        temp = a + betah;
        if (temp - a != ZERO) {
            ROUND_STYLE = 1;
        }
        double tempa = a + beta;
        temp = tempa + betah;
        if (ROUND_STYLE == 0 && temp - tempa != ZERO) {
            ROUND_STYLE = 2;
        }
        NEGEP = DIGITS + 3;
        double betain = ONE / beta;
        a = ONE;
        for (int i = 0; i < NEGEP; ++i) {
            a *= betain;
        }
        b = a;
        temp = ONE - a;
        while (temp - ONE == ZERO) {
            --NEGEP;
            temp = ONE - (a *= beta);
        }
        NEGEP = -NEGEP;
        MACHEP = -DIGITS - 3;
        a = b;
        temp = ONE + a;
        while (temp - ONE == ZERO) {
            ++MACHEP;
            temp = ONE + (a *= beta);
        }
        EPSILON = a;
        LOG2 = java.lang.Math.log(2.0);
    }

    private static class PdistTask
    implements Callable<Void> {
        double[][] x;
        double[][] dist;
        int nprocs;
        int pid;
        boolean half;
        boolean squared;

        PdistTask(double[][] x, double[][] dist, int nprocs, int pid, boolean squared, boolean half) {
            this.x = x;
            this.dist = dist;
            this.nprocs = nprocs;
            this.pid = pid;
            this.squared = squared;
            this.half = half;
        }

        @Override
        public Void call() {
            int n = this.x.length;
            for (int i = this.pid; i < n; i += this.nprocs) {
                for (int j = 0; j < i; ++j) {
                    double d;
                    this.dist[i][j] = d = this.squared ? Math.squaredDistance(this.x[i], this.x[j]) : Math.distance(this.x[i], this.x[j]);
                    if (this.half) continue;
                    this.dist[j][i] = d;
                }
            }
            return null;
        }
    }
}

