/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.landscape.ssh;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import com.sap.sse.landscape.ssh.SshCommandChannel;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SshCommandChannelImpl
implements SshCommandChannel {
    private static final Logger logger = Logger.getLogger(SshCommandChannelImpl.class.getName());
    private final ChannelExec channel;
    private InputStream stdout;

    public SshCommandChannelImpl(ChannelExec channel) throws IOException, JSchException, InterruptedException {
        this.channel = channel;
    }

    @Override
    public int getExitStatus() {
        return this.channel.getExitStatus();
    }

    @Override
    public String runCommandAndReturnStdoutAndLogStderr(String commandLine, String stderrLogPrefix, Level stderrLogLevel) throws IOException, InterruptedException, JSchException {
        ByteArrayOutputStream stderr = new ByteArrayOutputStream();
        try {
            String result;
            this.sendCommandLineSynchronously(commandLine, stderr);
            if (stderrLogLevel != null && stderr.size() > 0) {
                logger.log(stderrLogLevel, String.valueOf(stderrLogPrefix == null ? "" : String.valueOf(stderrLogPrefix) + ": ") + stderr.toString());
            }
            String string = result = this.getStreamContentsAsString();
            return string;
        }
        finally {
            this.disconnect();
        }
    }

    @Override
    public InputStream sendCommandLineSynchronously(String commandLine, OutputStream stderr) throws IOException, InterruptedException, JSchException {
        this.stdout = this.channel.getInputStream();
        this.channel.setCommand(commandLine);
        this.channel.setExtOutputStream(stderr);
        this.channel.connect(5000);
        return this.stdout;
    }

    @Override
    public byte[] getStreamContentsAsByteArray() throws IOException, JSchException {
        ByteArrayOutputStream bos = this.readStdout();
        return bos.toByteArray();
    }

    @Override
    public String getStreamContentsAsString() throws IOException, JSchException {
        ByteArrayOutputStream bos = this.readStdout();
        return bos.toString();
    }

    private ByteArrayOutputStream readStdout() throws IOException, JSchException {
        int read;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] buf = new byte[8192];
        while ((read = this.stdout.read(buf, 0, buf.length)) >= 0) {
            bos.write(buf, 0, read);
        }
        this.stdout.close();
        while (!this.channel.isClosed()) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exc) {
                logger.warning("Warning: Error closing session to host " + this.getHost() + ": " + exc.getMessage());
            }
        }
        this.channel.disconnect();
        return bos;
    }

    private String getHost() throws JSchException {
        return this.channel.getSession().getHost();
    }

    @Override
    public void disconnect() throws JSchException {
        if (this.channel.getSession() != null) {
            this.channel.getSession().disconnect();
        }
    }
}

