/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.landscape.mongodb;

import com.sap.sse.common.Duration;
import com.sap.sse.common.Named;
import com.sap.sse.landscape.mongodb.Database;
import com.sap.sse.landscape.mongodb.MongoEndpoint;
import com.sap.sse.landscape.mongodb.MongoProcess;
import com.sap.sse.landscape.mongodb.MongoProcessInReplicaSet;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Function;
import java.util.logging.Logger;

public interface MongoReplicaSet
extends Named,
MongoEndpoint {
    public static final Logger logger = Logger.getLogger(MongoReplicaSet.class.getName());

    public Iterable<MongoProcessInReplicaSet> getInstances();

    @Override
    default public URI getURI(Optional<Database> optionalDb) throws URISyntaxException {
        return this.getURI(optionalDb, (MongoProcess mongoProcess) -> mongoProcess.getHost().getHostname());
    }

    default public URI getURI(Optional<Database> optionalDb, Function<MongoProcess, String> addressSupplier) throws URISyntaxException {
        StringBuilder result = new StringBuilder("mongodb://");
        ArrayList<String> hostSpecs = new ArrayList<String>();
        for (MongoProcess mongoProcess : this.getInstances()) {
            String hostname = addressSupplier.apply(mongoProcess);
            if (hostname != null) {
                logger.fine("Adding MongoDB process running on " + hostname + " to replica set " + this.getName());
                StringBuilder hostSpec = new StringBuilder();
                hostSpec.append(hostname);
                if (mongoProcess.getPort() != 27017) {
                    hostSpec.append(":");
                    hostSpec.append(mongoProcess.getPort());
                }
                hostSpecs.add(hostSpec.toString());
                continue;
            }
            logger.warning("Not adding MongoDB process running on instance " + mongoProcess.getHost() + " to replica set " + this.getName() + " because its IP address cannot be determined. Probably it is not running.");
        }
        result.append(String.join((CharSequence)",", hostSpecs));
        result.append("/");
        optionalDb.ifPresent(db -> {
            StringBuilder stringBuilder2 = result.append(db.getName());
        });
        this.appendReplicaSetParametersToURI(this.getName(), result);
        return new URI(result.toString());
    }

    @Override
    default public URI getURI(Optional<Database> optionalDb, Optional<Duration> timeoutEmptyMeansForever) throws URISyntaxException {
        return this.getURI(optionalDb, (MongoProcess mongoProcess) -> {
            try {
                return mongoProcess.getHost().getPublicAddress(timeoutEmptyMeansForever).getHostAddress();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    public void addReplica(MongoProcessInReplicaSet var1);

    public void removeReplica(MongoProcessInReplicaSet var1);
}

