/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.landscape.mongodb;

import com.mongodb.client.MongoDatabase;
import com.sap.sse.common.Named;
import com.sap.sse.landscape.DefaultProcessConfigurationVariables;
import com.sap.sse.landscape.ProcessConfigurationVariable;
import com.sap.sse.landscape.UserDataProvider;
import com.sap.sse.landscape.mongodb.MongoEndpoint;
import com.sap.sse.landscape.mongodb.impl.DatabaseImpl;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;

public interface Database
extends UserDataProvider,
Named {
    public static final Logger logger = Logger.getLogger(Database.class.getName());

    default public URI getConnectionURI() throws URISyntaxException {
        return this.getEndpoint().getURI(Optional.of(this));
    }

    public MongoEndpoint getEndpoint();

    default public String getMD5Hash() throws URISyntaxException {
        return this.getEndpoint().getMD5Hash(this.getMongoDatabase());
    }

    default public MongoDatabase getMongoDatabase() throws URISyntaxException {
        return this.getEndpoint().getMongoDatabase(this.getName());
    }

    @Override
    default public Map<ProcessConfigurationVariable, String> getUserData() {
        HashMap<ProcessConfigurationVariable, String> result = new HashMap<ProcessConfigurationVariable, String>();
        try {
            result.put(DefaultProcessConfigurationVariables.MONGODB_URI, this.getConnectionURI().toString());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    default public void drop() throws URISyntaxException {
        logger.info("Dropping database " + this);
        this.getMongoDatabase().drop();
    }

    public static Database of(MongoEndpoint mongoEndpoint, String databaseName) {
        return new DatabaseImpl(mongoEndpoint, databaseName);
    }

    default public Database getWithDifferentName(String differentName) {
        return new DatabaseImpl(this.getEndpoint(), differentName);
    }
}

