/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.landscape;

import com.sap.sse.common.Duration;
import com.sap.sse.landscape.MachineImage;
import com.sap.sse.landscape.Region;
import com.sap.sse.landscape.SecurityGroup;
import com.sap.sse.landscape.rabbitmq.RabbitMQEndpoint;
import java.util.Optional;

public interface Landscape<ShardingKey> {
    public static final String IMAGE_TYPE_TAG_NAME = "image-type";
    public static final Optional<Duration> WAIT_FOR_HOST_TIMEOUT = Optional.of(Duration.ONE_HOUR.times(2L));
    public static final Optional<Duration> WAIT_FOR_PROCESS_TIMEOUT = Optional.of(Duration.ONE_MINUTE);

    public SecurityGroup getDefaultSecurityGroupForApplicationHosts(Region var1);

    public SecurityGroup getDefaultSecurityGroupForApplicationLoadBalancer(Region var1);

    public Iterable<SecurityGroup> getDefaultSecurityGroupsForReverseProxy(Region var1);

    public Iterable<SecurityGroup> getDefaultSecurityGroupsForMongoDBHosts(Region var1);

    public RabbitMQEndpoint getDefaultRabbitConfiguration(Region var1);

    public Iterable<Region> getRegions();

    public MachineImage getLatestImageWithTag(Region var1, String var2, String var3);

    public MachineImage getLatestImageWithType(Region var1, String var2);
}

