/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.serialization.racelog.impl;

import com.sap.sailing.domain.abstractlog.race.RaceLog;
import com.sap.sailing.domain.abstractlog.race.RaceLogEvent;
import com.sap.sse.shared.json.JsonSerializer;
import java.util.UUID;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class RaceLogSerializer
implements JsonSerializer<RaceLog> {
    public static final String FIELD_EVENTS = "events";
    public static final String FIELD_RACELOG_IDENTIFIER = "racelog_id";
    private final JsonSerializer<RaceLogEvent> itemSerializer;
    private final UUID clientUuid;

    public RaceLogSerializer(JsonSerializer<RaceLogEvent> raceLogEventSerializer, UUID clientUuid) {
        this.itemSerializer = raceLogEventSerializer;
        this.clientUuid = clientUuid;
    }

    public JSONObject serialize(RaceLog object) {
        JSONObject result = new JSONObject();
        object.lockForRead();
        try {
            JSONArray events = new JSONArray();
            for (RaceLogEvent event : object.getRawFixes(this.clientUuid)) {
                events.add((Object)this.itemSerializer.serialize((Object)event));
            }
            result.put((Object)FIELD_EVENTS, (Object)events);
            result.put((Object)FIELD_RACELOG_IDENTIFIER, (Object)object.getId().toString());
        }
        finally {
            object.unlockAfterRead();
        }
        return result;
    }
}

