/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.serialization.racelog.impl;

import com.sap.sailing.domain.abstractlog.orc.RaceLogORCLegDataEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLogEvent;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.server.gateway.serialization.racelog.impl.BaseRaceLogEventSerializer;
import com.sap.sse.shared.json.JsonSerializer;
import org.json.simple.JSONObject;

public class RaceLogORCLegDataEventSerializer
extends BaseRaceLogEventSerializer {
    public static final String VALUE_CLASS = RaceLogORCLegDataEvent.class.getSimpleName();
    public static final String ORC_LEG_NR = "legNr";
    public static final String ORC_LEG_TWA = "twaDeg";
    public static final String ORC_LEG_LENGTH = "lengthNauticalMiles";
    public static final String ORC_LEG_TYPE = "type";

    public RaceLogORCLegDataEventSerializer(JsonSerializer<Competitor> competitorSerializer) {
        super(competitorSerializer);
    }

    @Override
    public JSONObject serialize(RaceLogEvent object) {
        RaceLogORCLegDataEvent legData = (RaceLogORCLegDataEvent)object;
        JSONObject result = super.serialize((RaceLogEvent)legData);
        result.put((Object)ORC_LEG_NR, (Object)legData.getOneBasedLegNumber());
        result.put((Object)ORC_LEG_LENGTH, legData.getLength() == null ? null : Double.valueOf(legData.getLength().getNauticalMiles()));
        result.put((Object)ORC_LEG_TWA, legData.getTwa() == null ? null : Double.valueOf(legData.getTwa().getDegrees()));
        result.put((Object)ORC_LEG_TYPE, (Object)legData.getType().name());
        return result;
    }

    @Override
    protected String getClassFieldValue() {
        return VALUE_CLASS;
    }
}

