/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.serialization.racegroup.impl;

import com.sap.sailing.domain.abstractlog.race.RaceLog;
import com.sap.sailing.domain.base.racegroup.RaceCell;
import com.sap.sailing.domain.common.TargetTimeInfo;
import com.sap.sse.shared.json.JsonSerializer;
import org.json.simple.JSONObject;

public class RaceCellJsonSerializer
implements JsonSerializer<RaceCell> {
    public static final String FIELD_NAME = "name";
    public static final String FIELD_RACE_LOG = "raceLog";
    public static final String FIELD_COMPETITORS = "competitors";
    public static final String FIELD_FACTOR = "factor";
    public static final String FIELD_EXPLICIT_FACTOR = "explicitfactor";
    public static final String FIELD_ZERO_BASED_INDEX_IN_FLEET = "zerobasedindexinfleet";
    public static final String FIELD_TARGET_TIME_INFO = "targettimeinfo";
    private final JsonSerializer<RaceLog> logSerializer;
    private final JsonSerializer<TargetTimeInfo> targetTimeInfoSerializer;

    public RaceCellJsonSerializer(JsonSerializer<RaceLog> logSerializer, JsonSerializer<TargetTimeInfo> targetTimeInfoSerializer) {
        this.logSerializer = logSerializer;
        this.targetTimeInfoSerializer = targetTimeInfoSerializer;
    }

    public JSONObject serialize(RaceCell object) {
        JSONObject result = new JSONObject();
        result.put((Object)FIELD_NAME, (Object)object.getName());
        result.put((Object)FIELD_FACTOR, (Object)object.getFactor());
        result.put((Object)FIELD_EXPLICIT_FACTOR, (Object)object.getExplicitFactor());
        result.put((Object)FIELD_ZERO_BASED_INDEX_IN_FLEET, (Object)object.getZeroBasedIndexInFleet());
        result.put((Object)FIELD_RACE_LOG, (Object)this.logSerializer.serialize((Object)object.getRaceLog()));
        TargetTimeInfo targetTime = object.getTargetTime();
        result.put((Object)FIELD_TARGET_TIME_INFO, targetTime == null ? null : this.targetTimeInfoSerializer.serialize((Object)targetTime));
        return result;
    }
}

