/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.serialization.impl;

import com.sap.sailing.domain.base.Boat;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.CompetitorWithBoat;
import com.sap.sailing.domain.base.Nationality;
import com.sap.sailing.domain.base.Team;
import com.sap.sailing.server.gateway.serialization.impl.BoatClassJsonSerializer;
import com.sap.sailing.server.gateway.serialization.impl.BoatJsonSerializer;
import com.sap.sailing.server.gateway.serialization.impl.TeamJsonSerializer;
import com.sap.sse.common.Color;
import com.sap.sse.common.CountryCode;
import com.sap.sse.shared.json.JsonSerializer;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.json.simple.JSONObject;

public class CompetitorJsonSerializer
implements JsonSerializer<Competitor> {
    public static final String FIELD_ID = "id";
    private final JsonSerializer<Team> teamJsonSerializer;
    private final JsonSerializer<Boat> boatJsonSerializer;
    private final boolean serializeNonPublicFields;

    public static CompetitorJsonSerializer create() {
        return CompetitorJsonSerializer.create(true);
    }

    public static CompetitorJsonSerializer create(boolean serializeBoat) {
        return new CompetitorJsonSerializer(TeamJsonSerializer.create(), serializeBoat ? BoatJsonSerializer.create() : null, false);
    }

    public static CompetitorJsonSerializer create(boolean serializeBoat, boolean serializeNonPublicCompetitorFields) {
        return CompetitorJsonSerializer.create(serializeBoat, serializeNonPublicCompetitorFields, true);
    }

    public static CompetitorJsonSerializer create(boolean serializeBoat, boolean serializeNonPublicCompetitorFields, boolean verboseBoatClassSerializer) {
        return new CompetitorJsonSerializer(TeamJsonSerializer.create(), serializeBoat ? new BoatJsonSerializer(new BoatClassJsonSerializer(verboseBoatClassSerializer)) : null, serializeNonPublicCompetitorFields);
    }

    public CompetitorJsonSerializer() {
        this(null, null, false);
    }

    public CompetitorJsonSerializer(JsonSerializer<Team> teamJsonSerializer, JsonSerializer<Boat> boatJsonSerializer, boolean serializeNonPublicFields) {
        this.teamJsonSerializer = teamJsonSerializer;
        this.boatJsonSerializer = boatJsonSerializer;
        this.serializeNonPublicFields = serializeNonPublicFields;
    }

    public static JSONObject getCompetitorIdQuery(Competitor competitor) {
        JSONObject result = new JSONObject();
        Object competitorId = competitor.getId() instanceof UUID ? competitor.getId().toString() : competitor.getId();
        result.put((Object)FIELD_ID, competitorId);
        return result;
    }

    public JSONObject serialize(Competitor competitor) {
        Color color;
        JSONObject result = new JSONObject();
        result.put((Object)"idtype", (Object)competitor.getId().getClass().getName());
        Set entries = CompetitorJsonSerializer.getCompetitorIdQuery(competitor).entrySet();
        for (Map.Entry idKeyAndValue : entries) {
            result.put(idKeyAndValue.getKey(), idKeyAndValue.getValue());
        }
        result.put((Object)"name", (Object)competitor.getName());
        result.put((Object)"shortName", (Object)competitor.getShortName());
        if (competitor.hasBoat()) {
            result.put((Object)"sailID", (Object)((CompetitorWithBoat)competitor).getBoat().getSailID());
        }
        result.put((Object)"displayColor", (Object)((color = this.getColor(competitor)) == null ? null : color.getAsHtml()));
        if (this.serializeNonPublicFields) {
            result.put((Object)"email", (Object)competitor.getEmail());
        }
        result.put((Object)"searchTag", (Object)competitor.getSearchTag());
        Nationality nationality = competitor.getTeam() == null ? null : competitor.getTeam().getNationality();
        result.put((Object)"nationality", (Object)(nationality == null ? "" : nationality.getThreeLetterIOCAcronym()));
        CountryCode countryCode = nationality == null ? null : nationality.getCountryCode();
        result.put((Object)"nationalityISO2", (Object)(countryCode == null ? "" : countryCode.getTwoLetterISOCode()));
        result.put((Object)"nationalityISO3", (Object)(countryCode == null ? "" : countryCode.getThreeLetterISOCode()));
        if (competitor.getFlagImage() != null) {
            result.put((Object)"flagImageUri", (Object)competitor.getFlagImage().toString());
        }
        if (this.teamJsonSerializer != null) {
            result.put((Object)"team", (Object)this.teamJsonSerializer.serialize((Object)competitor.getTeam()));
        }
        if (this.boatJsonSerializer != null && competitor.hasBoat()) {
            result.put((Object)"boat", (Object)this.boatJsonSerializer.serialize((Object)((CompetitorWithBoat)competitor).getBoat()));
        }
        result.put((Object)"timeOnTimeFactor", (Object)competitor.getTimeOnTimeFactor());
        result.put((Object)"timeOnDistanceAllowanceInSecondsPerNauticalMile", competitor.getTimeOnDistanceAllowancePerNauticalMile() == null ? null : Double.valueOf(competitor.getTimeOnDistanceAllowancePerNauticalMile().asSeconds()));
        return result;
    }

    protected Color getColor(Competitor competitor) {
        return competitor.getColor();
    }
}

