/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.deserialization.racelog.impl;

import com.sap.sailing.domain.abstractlog.AbstractLogEventAuthor;
import com.sap.sailing.domain.abstractlog.impl.LogEventAuthorImpl;
import com.sap.sailing.domain.abstractlog.race.RaceLogEvent;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.impl.DynamicCompetitor;
import com.sap.sailing.server.gateway.deserialization.impl.Helpers;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.shared.json.JsonDeserializationException;
import com.sap.sse.shared.json.JsonDeserializer;
import com.sap.sse.shared.util.impl.UUIDHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public abstract class BaseRaceLogEventDeserializer
implements JsonDeserializer<RaceLogEvent> {
    protected JsonDeserializer<DynamicCompetitor> competitorDeserializer;

    public BaseRaceLogEventDeserializer(JsonDeserializer<DynamicCompetitor> competitorDeserializer) {
        this.competitorDeserializer = competitorDeserializer;
    }

    protected abstract RaceLogEvent deserialize(JSONObject var1, Serializable var2, TimePoint var3, AbstractLogEventAuthor var4, TimePoint var5, int var6, List<Competitor> var7) throws JsonDeserializationException;

    public RaceLogEvent deserialize(JSONObject object) throws JsonDeserializationException {
        Serializable id = (Serializable)object.get((Object)"id");
        Number createdAt = (Number)object.get((Object)"createdAt");
        Number timeStamp = (Number)object.get((Object)"timestamp");
        Number passId = (Number)object.get((Object)"passId");
        JSONArray jsonCompetitors = Helpers.getNestedArraySafe(object, "competitors");
        ArrayList<Competitor> competitors = new ArrayList<Competitor>();
        for (Object competitorObject : jsonCompetitors) {
            JSONObject jsonCompetitor = (JSONObject)competitorObject;
            DynamicCompetitor competitor = (DynamicCompetitor)this.competitorDeserializer.deserialize(jsonCompetitor);
            competitors.add((Competitor)competitor);
        }
        String authorName = (String)object.get((Object)"authorName");
        Number authorPriority = (Number)object.get((Object)"authorPriority");
        LogEventAuthorImpl author = authorName != null && authorPriority != null ? new LogEventAuthorImpl(authorName, authorPriority.intValue()) : new LogEventAuthorImpl("default", 4);
        return this.deserialize(object, UUIDHelper.tryUuidConversion((Serializable)id), (TimePoint)new MillisecondsTimePoint(createdAt.longValue()), (AbstractLogEventAuthor)author, (TimePoint)(timeStamp == null ? null : new MillisecondsTimePoint(timeStamp.longValue())), passId.intValue(), competitors);
    }
}

