/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.deserialization.impl;

import com.sap.sailing.domain.common.LegType;
import com.sap.sailing.domain.common.TargetTimeInfo;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.common.impl.MeterDistance;
import com.sap.sailing.domain.common.impl.TargetTimeInfoImpl;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Distance;
import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.impl.DegreeBearingImpl;
import com.sap.sse.common.impl.MillisecondsDurationImpl;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.shared.json.JsonDeserializationException;
import com.sap.sse.shared.json.JsonDeserializer;
import java.util.ArrayList;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class TargetTimeInfoDeserializer
implements JsonDeserializer<TargetTimeInfo> {
    final JsonDeserializer<Wind> windDeserializer;

    public TargetTimeInfoDeserializer(JsonDeserializer<Wind> windDeserializer) {
        this.windDeserializer = windDeserializer;
    }

    public TargetTimeInfo deserialize(JSONObject object) throws JsonDeserializationException {
        ArrayList<TargetTimeInfoImpl.LegTargetTimeInfoImpl> legInfos = new ArrayList<TargetTimeInfoImpl.LegTargetTimeInfoImpl>();
        JSONArray legsAsJson = (JSONArray)object.get((Object)"legs");
        for (Object legAsObject : legsAsJson) {
            JSONObject legAsJson = (JSONObject)legAsObject;
            MillisecondsDurationImpl expectedDuration = new MillisecondsDurationImpl(((Number)legAsJson.get((Object)"legDurationMillis")).longValue());
            MillisecondsTimePoint expectedStartTime = new MillisecondsTimePoint(((Number)legAsJson.get((Object)"legStartMillis")).longValue());
            DegreeBearingImpl legBearing = new DegreeBearingImpl(((Number)legAsJson.get((Object)"legBearingDegrees")).doubleValue());
            MeterDistance legDistance = new MeterDistance(((Number)legAsJson.get((Object)"legDistanceMeters")).doubleValue());
            LegType legType = LegType.valueOf((String)((String)legAsJson.get((Object)"legType")));
            Wind legWind = (Wind)this.windDeserializer.deserialize((JSONObject)legAsJson.get((Object)"legWind"));
            TargetTimeInfoImpl.LegTargetTimeInfoImpl legInfo = new TargetTimeInfoImpl.LegTargetTimeInfoImpl((Distance)legDistance, legWind, (Bearing)legBearing, (Duration)expectedDuration, (TimePoint)expectedStartTime, legType, (Distance)Distance.NULL);
            legInfos.add(legInfo);
        }
        return new TargetTimeInfoImpl(legInfos);
    }
}

