/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.deserialization.impl;

import com.sap.sailing.domain.base.configuration.RacingProcedureConfiguration;
import com.sap.sailing.domain.base.configuration.RegattaConfiguration;
import com.sap.sailing.domain.base.configuration.impl.RegattaConfigurationImpl;
import com.sap.sailing.domain.base.configuration.procedures.ESSConfiguration;
import com.sap.sailing.domain.base.configuration.procedures.GateStartConfiguration;
import com.sap.sailing.domain.base.configuration.procedures.LeagueConfiguration;
import com.sap.sailing.domain.base.configuration.procedures.RRS26Configuration;
import com.sap.sailing.domain.base.configuration.procedures.SWCStartConfiguration;
import com.sap.sailing.domain.common.CourseDesignerMode;
import com.sap.sailing.domain.common.racelog.RacingProcedureType;
import com.sap.sailing.server.gateway.deserialization.impl.ESSConfigurationJsonDeserializer;
import com.sap.sailing.server.gateway.deserialization.impl.GateStartConfigurationJsonDeserializer;
import com.sap.sailing.server.gateway.deserialization.impl.Helpers;
import com.sap.sailing.server.gateway.deserialization.impl.LeagueConfigurationJsonDeserializer;
import com.sap.sailing.server.gateway.deserialization.impl.RRS26ConfigurationJsonDeserializer;
import com.sap.sailing.server.gateway.deserialization.impl.RacingProcedureConfigurationJsonDeserializer;
import com.sap.sailing.server.gateway.deserialization.impl.SWCStartConfigurationJsonDeserializer;
import com.sap.sse.common.Duration;
import com.sap.sse.common.impl.MillisecondsDurationImpl;
import com.sap.sse.shared.json.JsonDeserializationException;
import com.sap.sse.shared.json.JsonDeserializer;
import org.json.simple.JSONObject;

public class RegattaConfigurationJsonDeserializer
implements JsonDeserializer<RegattaConfiguration> {
    private final RRS26ConfigurationJsonDeserializer rrs26Deserializer;
    private final SWCStartConfigurationJsonDeserializer swcStartDeserializer;
    private final GateStartConfigurationJsonDeserializer gateStartDeserializer;
    private final ESSConfigurationJsonDeserializer essDeserializer;
    private final RacingProcedureConfigurationJsonDeserializer basicDeserializer;
    private final LeagueConfigurationJsonDeserializer leagueDeserializer;

    public static RegattaConfigurationJsonDeserializer create() {
        return new RegattaConfigurationJsonDeserializer(RRS26ConfigurationJsonDeserializer.create(), SWCStartConfigurationJsonDeserializer.create(), GateStartConfigurationJsonDeserializer.create(), ESSConfigurationJsonDeserializer.create(), RacingProcedureConfigurationJsonDeserializer.create(), LeagueConfigurationJsonDeserializer.create());
    }

    public RegattaConfigurationJsonDeserializer(RRS26ConfigurationJsonDeserializer rrs26, SWCStartConfigurationJsonDeserializer swcStart, GateStartConfigurationJsonDeserializer gateStart, ESSConfigurationJsonDeserializer ess, RacingProcedureConfigurationJsonDeserializer basicDeserializer, LeagueConfigurationJsonDeserializer leagueDeserializer) {
        this.rrs26Deserializer = rrs26;
        this.swcStartDeserializer = swcStart;
        this.gateStartDeserializer = gateStart;
        this.essDeserializer = ess;
        this.basicDeserializer = basicDeserializer;
        this.leagueDeserializer = leagueDeserializer;
    }

    public RegattaConfiguration deserialize(JSONObject object) throws JsonDeserializationException {
        RegattaConfigurationImpl configuration = this.createConfiguration();
        if (object.containsKey((Object)"defaultRacingProcedureType")) {
            RacingProcedureType type = RacingProcedureType.valueOf((String)object.get((Object)"defaultRacingProcedureType").toString());
            configuration.setDefaultRacingProcedureType(type);
        }
        if (object.containsKey((Object)"defaultCourseDesignerMode")) {
            CourseDesignerMode mode = CourseDesignerMode.valueOf((String)object.get((Object)"defaultCourseDesignerMode").toString());
            configuration.setDefaultCourseDesignerMode(mode);
        }
        if (object.containsKey((Object)"defaultProtestTimeDurationMillis")) {
            Number defaultProtestTimeDurationInMillis = (Number)object.get((Object)"defaultProtestTimeDurationMillis");
            configuration.setDefaultProtestTimeDuration((Duration)(defaultProtestTimeDurationInMillis == null ? null : new MillisecondsDurationImpl(defaultProtestTimeDurationInMillis.longValue())));
        }
        if (object.containsKey((Object)"rrs26")) {
            RRS26Configuration rrs26Configuration = this.rrs26Deserializer.deserialize(Helpers.getNestedObjectSafe(object, "rrs26"));
            configuration.setRRS26Configuration(rrs26Configuration);
        }
        if (object.containsKey((Object)"swcStart")) {
            SWCStartConfiguration swcStartConfiguration = this.swcStartDeserializer.deserialize(Helpers.getNestedObjectSafe(object, "swcStart"));
            configuration.setSWCStartConfiguration(swcStartConfiguration);
        }
        if (object.containsKey((Object)"gateStart")) {
            GateStartConfiguration gateStartConfiguration = this.gateStartDeserializer.deserialize(Helpers.getNestedObjectSafe(object, "gateStart"));
            configuration.setGateStartConfiguration(gateStartConfiguration);
        }
        if (object.containsKey((Object)"ess")) {
            ESSConfiguration essConfiguration = this.essDeserializer.deserialize(Helpers.getNestedObjectSafe(object, "ess"));
            configuration.setESSConfiguration(essConfiguration);
        }
        if (object.containsKey((Object)"basic")) {
            RacingProcedureConfiguration basicConfiguration = this.basicDeserializer.deserialize(Helpers.getNestedObjectSafe(object, "basic"));
            configuration.setBasicConfiguration(basicConfiguration);
        }
        if (object.containsKey((Object)"league")) {
            LeagueConfiguration leagueConfiguration = this.leagueDeserializer.deserialize(Helpers.getNestedObjectSafe(object, "league"));
            configuration.setLeagueConfiguration(leagueConfiguration);
        }
        return configuration;
    }

    protected RegattaConfigurationImpl createConfiguration() {
        return new RegattaConfigurationImpl();
    }
}

