/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.deserialization.impl;

import com.sap.sailing.domain.base.BoatClass;
import com.sap.sailing.domain.base.BoatFactory;
import com.sap.sailing.domain.base.SharedDomainFactory;
import com.sap.sailing.domain.base.impl.BoatImpl;
import com.sap.sailing.domain.base.impl.DynamicBoat;
import com.sap.sailing.server.gateway.deserialization.impl.BoatClassJsonDeserializer;
import com.sap.sailing.server.gateway.deserialization.impl.Helpers;
import com.sap.sse.common.Color;
import com.sap.sse.common.impl.RGBColor;
import com.sap.sse.shared.json.JsonDeserializationException;
import com.sap.sse.shared.json.JsonDeserializer;
import com.sap.sse.shared.util.impl.UUIDHelper;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.UUID;
import org.json.simple.JSONObject;

public class LegacyBoatJsonDeserializer
implements JsonDeserializer<DynamicBoat> {
    private final BoatClassJsonDeserializer boatClassDeserializer;

    public static LegacyBoatJsonDeserializer create(SharedDomainFactory<?> baseDomainFactory) {
        return new LegacyBoatJsonDeserializer((BoatFactory)baseDomainFactory, new BoatClassJsonDeserializer(baseDomainFactory));
    }

    public LegacyBoatJsonDeserializer(BoatFactory boatFactory, BoatClassJsonDeserializer boatClassDeserializer) {
        this.boatClassDeserializer = boatClassDeserializer;
    }

    public DynamicBoat deserialize(JSONObject object) throws JsonDeserializationException {
        Serializable boatId = (Serializable)object.get((Object)"id");
        try {
            String colorAsString;
            if (boatId == null) {
                boatId = UUID.randomUUID();
            } else {
                Class<?> idClass = Class.forName((String)object.get((Object)"idtype"));
                if (Number.class.isAssignableFrom(idClass)) {
                    Constructor<?> constructorFromString = idClass.getConstructor(String.class);
                    boatId = (Serializable)constructorFromString.newInstance(boatId.toString());
                } else if (UUID.class.isAssignableFrom(idClass)) {
                    boatId = UUIDHelper.tryUuidConversion((Serializable)boatId);
                }
            }
            String name = (String)object.get((Object)"name");
            Object sailID = object.get((Object)"sailId");
            String sailId = sailID == null ? null : sailID.toString();
            BoatClass boatClass = null;
            if (this.boatClassDeserializer != null) {
                boatClass = this.boatClassDeserializer.deserialize(Helpers.getNestedObjectSafe(object, "boatClass"));
            }
            RGBColor color = (colorAsString = (String)object.get((Object)"color")) == null || colorAsString.isEmpty() ? null : new RGBColor(colorAsString);
            BoatImpl boat = new BoatImpl(boatId, name, boatClass, sailId, (Color)color);
            return boat;
        }
        catch (Exception e) {
            throw new JsonDeserializationException((Throwable)e);
        }
    }
}

