/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.deserialization.impl;

import com.sap.sailing.domain.base.CourseArea;
import com.sap.sailing.domain.base.SharedDomainFactory;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.impl.MeterDistance;
import com.sap.sailing.server.gateway.deserialization.impl.PositionJsonDeserializer;
import com.sap.sse.common.Distance;
import com.sap.sse.shared.json.JsonDeserializationException;
import com.sap.sse.shared.json.JsonDeserializer;
import com.sap.sse.shared.util.impl.UUIDHelper;
import java.io.Serializable;
import java.util.UUID;
import org.json.simple.JSONObject;

public class CourseAreaJsonDeserializer
implements JsonDeserializer<CourseArea> {
    private SharedDomainFactory<?> factory;

    public CourseAreaJsonDeserializer(SharedDomainFactory<?> factory) {
        this.factory = factory;
    }

    public CourseArea deserialize(JSONObject object) throws JsonDeserializationException {
        String name = (String)object.get((Object)"name");
        Serializable id = (Serializable)object.get((Object)"id");
        JSONObject centerPositionJson = (JSONObject)object.get((Object)"centerPosition");
        Position centerPosition = centerPositionJson != null ? new PositionJsonDeserializer().deserialize(centerPositionJson) : null;
        Number radiusNumber = (Number)object.get((Object)"radiusInMeters");
        MeterDistance radius = radiusNumber != null ? new MeterDistance(radiusNumber.doubleValue()) : null;
        CourseArea result = this.factory.getOrCreateCourseArea((UUID)UUIDHelper.tryUuidConversion((Serializable)id), name, centerPosition, (Distance)radius);
        return result;
    }
}

