/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.deserialization.impl;

import com.sap.sailing.domain.base.BoatFactory;
import com.sap.sailing.domain.base.CompetitorFactory;
import com.sap.sailing.domain.base.SharedDomainFactory;
import com.sap.sailing.domain.base.impl.DynamicBoat;
import com.sap.sailing.domain.base.impl.DynamicTeam;
import com.sap.sailing.server.gateway.deserialization.impl.CompetitorJsonDeserializer;
import com.sap.sailing.server.gateway.deserialization.impl.NationalityJsonDeserializer;
import com.sap.sailing.server.gateway.deserialization.impl.PersonJsonDeserializer;
import com.sap.sailing.server.gateway.deserialization.impl.TeamJsonDeserializer;
import com.sap.sse.shared.json.JsonDeserializer;
import com.sap.sse.shared.util.impl.UUIDHelper;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.UUID;
import org.json.simple.JSONObject;

public class CompetitorWithBoatRefJsonDeserializer
extends CompetitorJsonDeserializer {
    private final BoatFactory boatFactory;

    public static CompetitorWithBoatRefJsonDeserializer create(SharedDomainFactory<?> baseDomainFactory) {
        return new CompetitorWithBoatRefJsonDeserializer((CompetitorFactory)baseDomainFactory, (BoatFactory)baseDomainFactory, new TeamJsonDeserializer(new PersonJsonDeserializer(new NationalityJsonDeserializer(baseDomainFactory))));
    }

    public CompetitorWithBoatRefJsonDeserializer(CompetitorFactory competitorFactory, BoatFactory boatFactory) {
        this(competitorFactory, boatFactory, null);
    }

    public CompetitorWithBoatRefJsonDeserializer(CompetitorFactory competitorFactory, BoatFactory boatFactory, JsonDeserializer<DynamicTeam> teamJsonDeserializer) {
        super(competitorFactory, teamJsonDeserializer, null, false);
        this.boatFactory = boatFactory;
    }

    @Override
    protected DynamicBoat getBoat(JSONObject object, Serializable defaultId) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Serializable boatId = (Serializable)object.get((Object)"boatId");
        if (boatId != null) {
            Class<?> boatIdClass = Class.forName((String)object.get((Object)"boatidtype"));
            if (Number.class.isAssignableFrom(boatIdClass)) {
                Constructor<?> constructorFromString = boatIdClass.getConstructor(String.class);
                boatId = (Serializable)constructorFromString.newInstance(boatId.toString());
            } else if (UUID.class.isAssignableFrom(boatIdClass)) {
                boatId = UUIDHelper.tryUuidConversion((Serializable)boatId);
            }
        }
        DynamicBoat existingBoat = boatId != null ? this.boatFactory.getExistingBoatById(boatId) : null;
        return existingBoat;
    }
}

