/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.deserialization.impl;

import com.sap.sailing.domain.base.BoatClass;
import com.sap.sailing.domain.base.BoatFactory;
import com.sap.sailing.domain.base.SharedDomainFactory;
import com.sap.sailing.domain.base.impl.DynamicBoat;
import com.sap.sailing.server.gateway.deserialization.impl.BoatClassJsonDeserializer;
import com.sap.sailing.server.gateway.deserialization.impl.Helpers;
import com.sap.sse.common.Color;
import com.sap.sse.common.impl.RGBColor;
import com.sap.sse.shared.json.JsonDeserializationException;
import com.sap.sse.shared.json.JsonDeserializer;
import com.sap.sse.shared.util.impl.UUIDHelper;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.UUID;
import java.util.logging.Logger;
import org.json.simple.JSONObject;

public class BoatJsonDeserializer
implements JsonDeserializer<DynamicBoat> {
    private static final Logger logger = Logger.getLogger(BoatJsonDeserializer.class.getName());
    private final BoatClassJsonDeserializer boatClassDeserializer;
    private final BoatFactory boatFactory;
    private final boolean storeDeserializedCompetitorsPersistently;

    public static BoatJsonDeserializer create(SharedDomainFactory<?> baseDomainFactory, boolean storeDeserializedCompetitorsPersistently) {
        return new BoatJsonDeserializer((BoatFactory)baseDomainFactory, new BoatClassJsonDeserializer(baseDomainFactory), storeDeserializedCompetitorsPersistently);
    }

    public static BoatJsonDeserializer create(SharedDomainFactory<?> baseDomainFactory) {
        return BoatJsonDeserializer.create(baseDomainFactory, true);
    }

    public BoatJsonDeserializer(BoatFactory boatFactory, BoatClassJsonDeserializer boatClassDeserializer) {
        this(boatFactory, boatClassDeserializer, true);
    }

    public BoatJsonDeserializer(BoatFactory boatFactory, BoatClassJsonDeserializer boatClassDeserializer, boolean storeDeserializedCompetitorsPersistently) {
        this.boatFactory = boatFactory;
        this.boatClassDeserializer = boatClassDeserializer;
        this.storeDeserializedCompetitorsPersistently = storeDeserializedCompetitorsPersistently;
    }

    public DynamicBoat deserialize(JSONObject object) throws JsonDeserializationException {
        return this.deserialize(object, null);
    }

    public DynamicBoat deserialize(JSONObject object, Serializable defaultId) throws JsonDeserializationException {
        Serializable boatIdFromJson = (Serializable)object.get((Object)"id");
        String idType = (String)object.get((Object)"idtype");
        try {
            String colorAsString;
            Serializable boatId;
            if (boatIdFromJson == null || idType == null) {
                if (defaultId != null) {
                    boatId = defaultId;
                } else {
                    boatId = UUID.randomUUID();
                    logger.warning("Trying to de-serialize a boat from " + object + " that comes without an ID. Generated new ID " + boatId);
                }
            } else {
                Class<?> idClass = Class.forName(idType);
                if (Number.class.isAssignableFrom(idClass)) {
                    Constructor<?> constructorFromString = idClass.getConstructor(String.class);
                    boatId = (Serializable)constructorFromString.newInstance(boatIdFromJson.toString());
                } else {
                    boatId = UUID.class.isAssignableFrom(idClass) ? UUIDHelper.tryUuidConversion((Serializable)boatIdFromJson) : boatIdFromJson;
                }
            }
            String name = (String)object.get((Object)"name");
            String sailId = (String)object.get((Object)"sailId");
            BoatClass boatClass = null;
            if (this.boatClassDeserializer != null) {
                boatClass = this.boatClassDeserializer.deserialize(Helpers.getNestedObjectSafe(object, "boatClass"));
            }
            RGBColor color = (colorAsString = (String)object.get((Object)"color")) == null || colorAsString.isEmpty() ? null : new RGBColor(colorAsString);
            DynamicBoat boat = this.boatFactory.getOrCreateBoat(boatId, name, boatClass, sailId, (Color)color, this.storeDeserializedCompetitorsPersistently);
            return boat;
        }
        catch (Exception e) {
            throw new JsonDeserializationException((Throwable)e);
        }
    }
}

