/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.expeditionconnector.impl;

import com.sap.sailing.expeditionconnector.impl.HttpServletMessageReceiver;
import com.sap.sse.common.Base64Utils;
import com.sap.sse.util.HttpUrlConnectionHelper;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.logging.Logger;

public class HttpServletMessageReceiverReader
implements Runnable {
    private static final Logger logger = Logger.getLogger(HttpServletMessageReceiverReader.class.getName());
    private static final int BUF_SIZE = 65536;
    private boolean stopped;
    private Reader reader;
    private final URL url;
    private final HttpServletMessageReceiver.Receiver receiver;
    private final HttpServletMessageReceiver owner;

    public HttpServletMessageReceiverReader(URL url, HttpServletMessageReceiver.Receiver receiver, HttpServletMessageReceiver owner) throws IOException {
        this.url = url;
        this.receiver = receiver;
        this.owner = owner;
        this.establishConnection();
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public void stop() {
        this.stopped = true;
        new Thread("ExpeditionHttpReceiverReader closer"){

            @Override
            public void run() {
                try {
                    HttpServletMessageReceiverReader.this.reader.close();
                }
                catch (IOException e) {
                    logger.info("Exception trying to close reader");
                }
            }
        }.start();
    }

    @Override
    public void run() {
        StringBuilder bos = new StringBuilder();
        while (!this.isStopped()) {
            try {
                char[] buf = new char[65536];
                int read = this.reader.read(buf);
                while (!this.isStopped() && read != -1) {
                    int i = 0;
                    while (i < read) {
                        if (buf[i] == '\u0000') {
                            if (this.receivedMessage(bos.toString())) {
                                this.stop();
                            }
                            bos.delete(0, bos.length());
                        } else {
                            bos.append(buf[i]);
                        }
                        ++i;
                    }
                    if (this.isStopped()) continue;
                    read = this.reader.read(buf);
                }
                logger.info("Reached EOF");
                this.reader.close();
            }
            catch (IOException e) {
                logger.throwing(HttpServletMessageReceiver.class.getName(), "connect", e);
            }
            if (this.isStopped()) continue;
            logger.info("Reconnecting because not stopped");
            try {
                this.establishConnection();
            }
            catch (IOException e) {
                logger.info("Can't re-connect. Giving up.");
                logger.throwing(HttpServletMessageReceiver.class.getName(), "connect", e);
                this.stop();
            }
        }
    }

    private boolean receivedMessage(String bos) {
        boolean stopReceiving = false;
        if (bos.equals("<pong>")) {
            this.owner.receivedHeartbeatResponse();
        } else {
            stopReceiving = this.receiver.received(Base64Utils.fromBase64((String)bos));
        }
        return stopReceiving;
    }

    private void establishConnection() throws IOException {
        HttpURLConnection connection = (HttpURLConnection)this.url.openConnection();
        Charset charset = HttpUrlConnectionHelper.getCharsetFromConnectionOrDefault((URLConnection)connection, (String)"UTF-8");
        this.reader = new InputStreamReader(connection.getInputStream(), charset);
    }
}

