/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.expeditionconnector.impl;

import com.sap.sailing.expeditionconnector.impl.HttpServletMessageReceiverReader;
import com.sap.sse.util.impl.ThreadFactoryWithPriority;
import java.io.IOException;
import java.net.URL;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

public class HttpServletMessageReceiver {
    private static final Logger logger = Logger.getLogger(HttpServletMessageReceiver.class.getName());
    private static final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1, (ThreadFactory)new ThreadFactoryWithPriority(5, Boolean.valueOf(true)));
    private final Receiver receiver;
    private long timestampOfLastHeartbeatReceived;
    private final URL url;
    private boolean stop = false;

    public HttpServletMessageReceiver(URL url, Receiver receiver) {
        this.receiver = receiver;
        this.url = url;
    }

    public void connect() throws IOException, InterruptedException {
        HttpServletMessageReceiverReader readerRunnable = new HttpServletMessageReceiverReader(this.url, this.receiver, this);
        Thread readerThread = new Thread((Runnable)readerRunnable, String.valueOf(this.getClass().getName()) + " reader");
        readerThread.start();
        this.scheduleTimeoutHandler(readerRunnable);
    }

    private void scheduleTimeoutHandler(final HttpServletMessageReceiverReader readerRunnable) {
        Runnable timeoutChecker = new Runnable(){

            @Override
            public void run() {
                if (System.currentTimeMillis() - HttpServletMessageReceiver.this.timestampOfLastHeartbeatReceived > 25000L) {
                    logger.info("Timeout. Didn't receive a heartbeat through my HTTP connection for 25000ms");
                    readerRunnable.stop();
                    boolean successfullyConnected = false;
                    while (!HttpServletMessageReceiver.this.isStopped() && !successfullyConnected) {
                        try {
                            logger.info("Trying to re-connect to " + HttpServletMessageReceiver.this.url);
                            HttpServletMessageReceiver.this.connect();
                            logger.info("Successfully re-connected to " + HttpServletMessageReceiver.this.url);
                            successfullyConnected = true;
                        }
                        catch (IOException | InterruptedException e) {
                            logger.throwing(HttpServletMessageReceiver.class.getName(), "run", e);
                            logger.info("Error " + e.getMessage() + " trying to re-connect; will keep trying in a few seconds");
                            try {
                                Thread.sleep(3L);
                            }
                            catch (InterruptedException e1) {
                                logger.throwing(HttpServletMessageReceiver.class.getName(), "can't even sleep", e1);
                            }
                        }
                    }
                } else {
                    scheduler.schedule(this, 5000L, TimeUnit.MILLISECONDS);
                }
            }
        };
        scheduler.schedule(timeoutChecker, 5000L, TimeUnit.MILLISECONDS);
    }

    public void stop() throws IOException {
        logger.info("Stopping expedition HTTP receiver");
        this.setStop(true);
    }

    public boolean isStopped() {
        return this.stop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setStop(boolean stop) {
        if (stop != this.stop) {
            HttpServletMessageReceiver httpServletMessageReceiver = this;
            synchronized (httpServletMessageReceiver) {
                this.stop = stop;
                this.notifyAll();
            }
        }
    }

    public void receivedHeartbeatResponse() {
        logger.finest("received expedition HTTP heartbeat");
        this.timestampOfLastHeartbeatReceived = System.currentTimeMillis();
    }

    public static interface Receiver {
        public boolean received(byte[] var1);
    }
}

