/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.expeditionconnector;

import com.sap.sailing.domain.common.DeviceIdentifier;
import com.sap.sailing.domain.common.sensordata.ExpeditionExtendedSensorDataMetadata;
import com.sap.sailing.domain.common.tracking.GPSFixMoving;
import com.sap.sailing.domain.common.tracking.impl.DoubleVectorFixImpl;
import com.sap.sailing.expeditionconnector.DeviceRegistry;
import com.sap.sailing.expeditionconnector.ExpeditionListener;
import com.sap.sailing.expeditionconnector.ExpeditionMessage;
import com.sap.sailing.expeditionconnector.ExpeditionSensorDeviceIdentifier;
import com.sap.sailing.expeditionconnector.impl.ExpeditionMessageParser;
import com.sap.sailing.expeditionconnector.persistence.ExpeditionGpsDeviceIdentifier;
import com.sap.sailing.udpconnector.UDPReceiver;
import com.sap.sse.common.Timed;
import java.io.IOException;
import java.net.SocketException;
import java.util.HashMap;
import java.util.Map;

public class UDPExpeditionReceiver
extends UDPReceiver<ExpeditionMessage, ExpeditionListener> {
    private final Map<Integer, Long> delayBetweenMessageTimestampAndTimepointReceived;
    private final ExpeditionMessageParser parser;
    private final DeviceRegistry deviceRegistry;
    private static final Map<Integer, ExpeditionExtendedSensorDataMetadata> mapExpeditionMessageFieldIdToMetadata = new HashMap<Integer, ExpeditionExtendedSensorDataMetadata>();

    static {
        mapExpeditionMessageFieldIdToMetadata.put(18, ExpeditionExtendedSensorDataMetadata.HEEL);
        mapExpeditionMessageFieldIdToMetadata.put(19, ExpeditionExtendedSensorDataMetadata.TRIM);
        mapExpeditionMessageFieldIdToMetadata.put(20, ExpeditionExtendedSensorDataMetadata.RUDDER);
        mapExpeditionMessageFieldIdToMetadata.put(152, ExpeditionExtendedSensorDataMetadata.TACK_ANGLE);
        mapExpeditionMessageFieldIdToMetadata.put(172, ExpeditionExtendedSensorDataMetadata.RAKE_DEG);
        mapExpeditionMessageFieldIdToMetadata.put(173, ExpeditionExtendedSensorDataMetadata.DEFLECTOR_PERCENTAGE);
        mapExpeditionMessageFieldIdToMetadata.put(174, ExpeditionExtendedSensorDataMetadata.TARGET_HEEL);
        mapExpeditionMessageFieldIdToMetadata.put(22, ExpeditionExtendedSensorDataMetadata.FORESTAY_LOAD);
        mapExpeditionMessageFieldIdToMetadata.put(175, ExpeditionExtendedSensorDataMetadata.FORESTAY_PRESSURE);
        mapExpeditionMessageFieldIdToMetadata.put(176, ExpeditionExtendedSensorDataMetadata.DEFLECTOR_MILLIMETERS);
        mapExpeditionMessageFieldIdToMetadata.put(238, ExpeditionExtendedSensorDataMetadata.TARGET_BOATSPEED_P);
    }

    public static void main(String[] args) throws IOException {
        UDPExpeditionReceiver receiver = new UDPExpeditionReceiver(Integer.valueOf(args[0]));
        receiver.addListener(new ExpeditionListener(){

            public void received(ExpeditionMessage message) {
                System.out.println(message);
            }
        }, false);
        receiver.run();
    }

    public UDPExpeditionReceiver(int listeningOnPort) throws SocketException {
        this(listeningOnPort, null);
    }

    public UDPExpeditionReceiver(int listeningOnPort, DeviceRegistry deviceRegistry) throws SocketException {
        super(listeningOnPort);
        this.deviceRegistry = deviceRegistry;
        this.delayBetweenMessageTimestampAndTimepointReceived = new HashMap<Integer, Long>();
        this.parser = new ExpeditionMessageParser(this);
        this.addListener(msg -> this.produceAndStoreOptionalFixes((ExpeditionMessage)msg), true);
    }

    private void produceAndStoreOptionalFixes(ExpeditionMessage msg) {
        if (this.deviceRegistry != null) {
            ExpeditionSensorDeviceIdentifier sensorDeviceIdentifier;
            ExpeditionGpsDeviceIdentifier gpsDeviceIdentifier = this.deviceRegistry.getGpsDeviceIdentifier(msg.getBoatID());
            if (gpsDeviceIdentifier != null) {
                this.tryToProduceAndStoreGpsFix(msg, gpsDeviceIdentifier);
            }
            if ((sensorDeviceIdentifier = this.deviceRegistry.getSensorDeviceIdentifier(msg.getBoatID())) != null) {
                this.tryToProduceAndStoreSensorFix(msg, sensorDeviceIdentifier);
            }
        }
    }

    private void tryToProduceAndStoreSensorFix(ExpeditionMessage msg, ExpeditionSensorDeviceIdentifier sensorDeviceIdentifier) {
        int maxColumnIndex = -1;
        HashMap<Integer, Double> valuesPerDoubleVectorFixColumnIndices = new HashMap<Integer, Double>();
        for (Map.Entry<Integer, ExpeditionExtendedSensorDataMetadata> mapEntry : mapExpeditionMessageFieldIdToMetadata.entrySet()) {
            if (!msg.hasValue(mapEntry.getKey())) continue;
            valuesPerDoubleVectorFixColumnIndices.put(mapEntry.getValue().getColumnIndex(), msg.getValue(mapEntry.getKey()));
            maxColumnIndex = Math.max(maxColumnIndex, mapEntry.getValue().getColumnIndex());
        }
        Double[] vector = new Double[maxColumnIndex + 1];
        for (Map.Entry valuesPerDoubleVectorFixColumnIndex : valuesPerDoubleVectorFixColumnIndices.entrySet()) {
            vector[((Integer)valuesPerDoubleVectorFixColumnIndex.getKey()).intValue()] = (Double)valuesPerDoubleVectorFixColumnIndex.getValue();
        }
        DoubleVectorFixImpl fix = new DoubleVectorFixImpl(msg.getTimePoint(), vector);
        if (fix.hasValidData()) {
            this.deviceRegistry.getSensorFixStore().storeFix((DeviceIdentifier)sensorDeviceIdentifier, (Timed)fix);
        }
    }

    private void tryToProduceAndStoreGpsFix(ExpeditionMessage msg, ExpeditionGpsDeviceIdentifier gpsDeviceIdentifier) {
        GPSFixMoving fix = msg.getGPSFixMoving();
        if (fix != null) {
            this.deviceRegistry.getSensorFixStore().storeFix((DeviceIdentifier)gpsDeviceIdentifier, (Timed)fix);
        }
    }

    public Long getLastKnownMessageDelayInMillis(int boatID) {
        return this.delayBetweenMessageTimestampAndTimepointReceived.get(boatID);
    }

    public void updateLastKnownMessageDelay(int boatID, long timestampAsMillis) {
        this.delayBetweenMessageTimestampAndTimepointReceived.put(boatID, timestampAsMillis);
    }

    protected ExpeditionMessageParser getParser() {
        return this.parser;
    }
}

