/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.expeditionconnector;

import com.sap.sailing.expeditionconnector.impl.HttpServletMessageReceiver;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.URL;
import java.util.logging.Logger;

public class FromHttpToUdpMirror
implements HttpServletMessageReceiver.Receiver {
    private static final Logger logger = Logger.getLogger(FromHttpToUdpMirror.class.getName());
    private final DatagramSocket udpSocket;
    private final DatagramPacket udpPacket;
    private final byte[] buf;
    private final HttpServletMessageReceiver receiver;
    private final boolean verbose;

    public FromHttpToUdpMirror(URL url, int targetPort, boolean verbose) throws SocketException {
        this.verbose = verbose;
        this.buf = new byte[65536];
        this.udpSocket = new DatagramSocket();
        this.udpPacket = new DatagramPacket(this.buf, this.buf.length, InetAddress.getLoopbackAddress(), targetPort);
        this.receiver = new HttpServletMessageReceiver(url, this);
    }

    public void start() throws IOException, InterruptedException {
        this.receiver.connect();
    }

    public void stop() throws IOException {
        this.receiver.stop();
    }

    @Override
    public boolean received(byte[] bytes) {
        if (this.verbose) {
            logger.info("Forwarding: " + new String(bytes));
        }
        System.arraycopy(bytes, 0, this.buf, 0, bytes.length);
        this.udpPacket.setLength(bytes.length);
        try {
            this.udpSocket.send(this.udpPacket);
        }
        catch (IOException e) {
            logger.info("Exception while trying to forward message: " + e.getMessage());
            logger.throwing(FromHttpToUdpMirror.class.getName(), "received", e);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws InterruptedException, IOException {
        int i = 0;
        boolean verbose = false;
        URL url = null;
        Integer targetUDPPort = null;
        while (i < args.length && (url == null || targetUDPPort == null)) {
            if (args[i].equals("-v")) {
                verbose = true;
            } else if (url == null) {
                url = new URL(args[i]);
            } else {
                targetUDPPort = Integer.valueOf(args[i]);
            }
            ++i;
        }
        if (url != null && targetUDPPort != null) {
            FromHttpToUdpMirror mirror = new FromHttpToUdpMirror(url, targetUDPPort, verbose);
            mirror.start();
            while (true) {
                URL uRL = url;
                synchronized (uRL) {
                    url.wait();
                }
                logger.info("Continuing with " + mirror);
            }
        }
        FromHttpToUdpMirror.usage();
    }

    private static void usage() {
        System.err.println("Usage: java " + FromHttpToUdpMirror.class.getName() + " [-v] <url> <targetUDPPort>");
    }
}

