/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.datamining.ui.client.settings;

import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.FocusWidget;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.RadioButton;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sse.datamining.ui.client.StringMessages;
import com.sap.sse.datamining.ui.client.settings.AdvancedDataMiningSettings;
import com.sap.sse.datamining.ui.client.settings.ChangeLossStrategyFormatter;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.gwt.client.shared.components.SettingsDialogComponent;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class AdvancedDataMiningSettingsDialogComponent
implements SettingsDialogComponent<AdvancedDataMiningSettings> {
    private AdvancedDataMiningSettings initialSettings;
    private StringMessages stringMessages;
    private CheckBox developerOptionsCheckBox;
    private Map<AdvancedDataMiningSettings.ChangeLossStrategy, RadioButton> changeLossStrategyButtons;

    public AdvancedDataMiningSettingsDialogComponent(AdvancedDataMiningSettings initialSettings, StringMessages stringMessages) {
        this.initialSettings = initialSettings;
        this.stringMessages = stringMessages;
    }

    public Widget getAdditionalWidget(DataEntryDialog<?> dialog) {
        Grid grid = new Grid(2, 2);
        grid.setCellPadding(5);
        this.developerOptionsCheckBox = dialog.createCheckbox(this.stringMessages.developerOptions());
        this.developerOptionsCheckBox.setValue(Boolean.valueOf(this.initialSettings.isDeveloperOptions()));
        grid.setWidget(0, 0, (Widget)this.developerOptionsCheckBox);
        Label changeLossStrategyLabel = dialog.createLabel(this.stringMessages.changeLossStrategy());
        changeLossStrategyLabel.setTitle(this.stringMessages.changeLossStrageyTooltip());
        grid.setWidget(1, 0, (Widget)changeLossStrategyLabel);
        this.changeLossStrategyButtons = new HashMap<AdvancedDataMiningSettings.ChangeLossStrategy, RadioButton>();
        VerticalPanel changeLossStrategyButtonsPanel = new VerticalPanel();
        AdvancedDataMiningSettings.ChangeLossStrategy[] changeLossStrategyArray = AdvancedDataMiningSettings.ChangeLossStrategy.values();
        int n = changeLossStrategyArray.length;
        int n2 = 0;
        while (n2 < n) {
            AdvancedDataMiningSettings.ChangeLossStrategy strategy = changeLossStrategyArray[n2];
            String label = ChangeLossStrategyFormatter.format(strategy, this.stringMessages);
            RadioButton button = dialog.createRadioButton("changeLossStrategy", label);
            button.setTitle(ChangeLossStrategyFormatter.tooltipFor(strategy, this.stringMessages));
            this.changeLossStrategyButtons.put(strategy, button);
            changeLossStrategyButtonsPanel.add((Widget)button);
            ++n2;
        }
        this.changeLossStrategyButtons.get((Object)this.initialSettings.getChangeLossStrategy()).setValue(Boolean.valueOf(true));
        grid.setWidget(1, 1, (Widget)changeLossStrategyButtonsPanel);
        return grid;
    }

    public AdvancedDataMiningSettings getResult() {
        AdvancedDataMiningSettings.ChangeLossStrategy changeLossStrategy = null;
        for (Map.Entry<AdvancedDataMiningSettings.ChangeLossStrategy, RadioButton> entry : this.changeLossStrategyButtons.entrySet()) {
            if (!entry.getValue().getValue().booleanValue()) continue;
            changeLossStrategy = entry.getKey();
            break;
        }
        Objects.requireNonNull(changeLossStrategy, "Change loss strategy mustn't be null");
        return new AdvancedDataMiningSettings(this.developerOptionsCheckBox.getValue(), changeLossStrategy);
    }

    public DataEntryDialog.Validator<AdvancedDataMiningSettings> getValidator() {
        return null;
    }

    public FocusWidget getFocusWidget() {
        return null;
    }
}

