/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.datamining.ui.client.selection.statistic;

import com.google.gwt.i18n.client.LocaleInfo;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sse.common.Util;
import com.sap.sse.common.settings.SerializableSettings;
import com.sap.sse.datamining.shared.dto.StatisticQueryDefinitionDTO;
import com.sap.sse.datamining.shared.impl.dto.AggregationProcessorDefinitionDTO;
import com.sap.sse.datamining.shared.impl.dto.DataRetrieverChainDefinitionDTO;
import com.sap.sse.datamining.shared.impl.dto.DataRetrieverLevelDTO;
import com.sap.sse.datamining.shared.impl.dto.FunctionDTO;
import com.sap.sse.datamining.ui.client.AbstractDataMiningComponent;
import com.sap.sse.datamining.ui.client.AggregatorDefinitionChangedListener;
import com.sap.sse.datamining.ui.client.DataMiningServiceAsync;
import com.sap.sse.datamining.ui.client.DataMiningSettingsControl;
import com.sap.sse.datamining.ui.client.DataMiningSettingsInfo;
import com.sap.sse.datamining.ui.client.DataMiningSettingsInfoManager;
import com.sap.sse.datamining.ui.client.DataRetrieverChainDefinitionChangedListener;
import com.sap.sse.datamining.ui.client.ExtractionFunctionChangedListener;
import com.sap.sse.datamining.ui.client.StatisticChangedListener;
import com.sap.sse.datamining.ui.client.StatisticProvider;
import com.sap.sse.datamining.ui.client.selection.RetrieverLevelSettingsComponent;
import com.sap.sse.datamining.ui.client.selection.statistic.AggregatorGroup;
import com.sap.sse.datamining.ui.client.selection.statistic.AggregatorListBox;
import com.sap.sse.datamining.ui.client.selection.statistic.ExtractionFunctionSuggestBox;
import com.sap.sse.datamining.ui.client.selection.statistic.ExtractionFunctionWithContext;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.shared.components.Component;
import com.sap.sse.gwt.client.shared.components.CompositeSettings;
import com.sap.sse.gwt.client.shared.components.CompositeTabbedSettingsDialogComponent;
import com.sap.sse.gwt.client.shared.components.SettingsDialogComponent;
import com.sap.sse.gwt.client.shared.settings.ComponentContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;

public class SuggestBoxStatisticProvider
extends AbstractDataMiningComponent<CompositeSettings>
implements StatisticProvider {
    private static final String StatisticProviderStyle = "statisticProvider";
    private static final String StatisticProviderElementStyle = "statisticProviderElement";
    private static final String SuggestBoxContainerStyle = "statisticSuggestBoxContainer";
    private final DataMiningServiceAsync dataMiningService;
    private final ErrorReporter errorReporter;
    private final Set<DataRetrieverChainDefinitionChangedListener> retrieverChainListeners;
    private final Set<ExtractionFunctionChangedListener> extractionFunctionListeners;
    private final Set<AggregatorDefinitionChangedListener> aggregatorDefinitionListeners;
    private boolean isAwaitingReload;
    private int awaitingRetrieverChainStatistics;
    private int awaitingAggregators;
    private final DataMiningSettingsInfoManager settingsManager;
    private final DataMiningSettingsControl settingsControl;
    private final Map<DataRetrieverChainDefinitionDTO, HashMap<DataRetrieverLevelDTO, SerializableSettings>> settingsMap;
    private final List<Component<?>> retrieverLevelSettingsComponents;
    private final FlowPanel mainPanel;
    private final Map<String, Set<AggregationProcessorDefinitionDTO>> collectedAggregators;
    private final List<AggregatorGroup> availableAggregators;
    private final AggregatorListBox aggregatorListBox;
    private FunctionDTO identityFunction;
    private final List<ExtractionFunctionWithContext.IdentityFunctionWithContext> availableIdentityFunctions;
    private final List<ExtractionFunctionWithContext.StatisticWithContext> availableStatistics;
    private final ExtractionFunctionSuggestBox extractionFunctionSuggestBox;
    private final Collection<Runnable> initializationCompleteListeners = new ArrayList<Runnable>();
    private boolean initializationComplete = false;

    public SuggestBoxStatisticProvider(Component<?> parent, ComponentContext<?> componentContext, DataMiningServiceAsync dataMiningService, ErrorReporter errorReporter, DataMiningSettingsControl settingsControl, DataMiningSettingsInfoManager settingsManager) {
        super(parent, componentContext);
        this.dataMiningService = dataMiningService;
        this.errorReporter = errorReporter;
        this.retrieverChainListeners = new HashSet<DataRetrieverChainDefinitionChangedListener>();
        this.extractionFunctionListeners = new HashSet<ExtractionFunctionChangedListener>();
        this.aggregatorDefinitionListeners = new HashSet<AggregatorDefinitionChangedListener>();
        this.isAwaitingReload = false;
        this.settingsManager = settingsManager;
        this.settingsControl = settingsControl;
        this.settingsControl.addSettingsComponent(this);
        this.settingsMap = new HashMap<DataRetrieverChainDefinitionDTO, HashMap<DataRetrieverLevelDTO, SerializableSettings>>();
        this.retrieverLevelSettingsComponents = new ArrayList();
        this.collectedAggregators = new HashMap<String, Set<AggregationProcessorDefinitionDTO>>();
        this.availableAggregators = new ArrayList<AggregatorGroup>();
        this.aggregatorListBox = new AggregatorListBox("<" + this.getDataMiningStringMessages().any() + ">");
        this.aggregatorListBox.setValueChangeHandler(this::aggregatorSelectionChanged);
        this.aggregatorListBox.addStyleName(StatisticProviderElementStyle);
        this.aggregatorListBox.addStyleName("dataMiningListBox");
        this.aggregatorListBox.setEnabled(false);
        this.availableIdentityFunctions = new ArrayList<ExtractionFunctionWithContext.IdentityFunctionWithContext>();
        this.availableStatistics = new ArrayList<ExtractionFunctionWithContext.StatisticWithContext>();
        this.extractionFunctionSuggestBox = new ExtractionFunctionSuggestBox(extractionFunction -> {
            AggregatorGroup aggregator = (AggregatorGroup)this.aggregatorListBox.getValue();
            return aggregator == null || aggregator.supportsFunction((ExtractionFunctionWithContext)extractionFunction);
        });
        this.extractionFunctionSuggestBox.setValueChangeHandler(this::extractionFunctionSelectionChanged);
        this.extractionFunctionSuggestBox.getValueBox().addFocusHandler(e -> {
            this.extractionFunctionSuggestBox.getValueBox().selectAll();
            this.extractionFunctionSuggestBox.showSuggestionList();
        });
        this.extractionFunctionSuggestBox.getValueBox().addKeyUpHandler(e -> {
            int keyCode = e.getNativeEvent().getKeyCode();
            if (keyCode == 27) {
                this.extractionFunctionSuggestBox.hideSuggestionList();
                this.extractionFunctionSuggestBox.setFocus(false);
            }
        });
        this.extractionFunctionSuggestBox.getElement().setPropertyString("placeholder", this.getDataMiningStringMessages().searchAvailableStatistics());
        this.extractionFunctionSuggestBox.ensureDebugId("ExtractionFunctionSuggestBox");
        this.extractionFunctionSuggestBox.setLimit(Integer.MAX_VALUE);
        this.extractionFunctionSuggestBox.addStyleName(StatisticProviderElementStyle);
        this.extractionFunctionSuggestBox.setWidth("100%");
        SimplePanel suggestBoxContainer = new SimplePanel((Widget)this.extractionFunctionSuggestBox);
        suggestBoxContainer.addStyleName(StatisticProviderElementStyle);
        suggestBoxContainer.addStyleName(SuggestBoxContainerStyle);
        this.mainPanel = new FlowPanel();
        this.mainPanel.addStyleName(StatisticProviderStyle);
        this.mainPanel.add((Widget)this.aggregatorListBox);
        this.mainPanel.add((Widget)suggestBoxContainer);
    }

    @Override
    public void awaitReloadComponents() {
        this.isAwaitingReload = true;
    }

    @Override
    public boolean isAwaitingReload() {
        return this.isAwaitingReload;
    }

    @Override
    public void reloadComponents() {
        this.isAwaitingReload = false;
        this.updateContent();
    }

    private void updateContent() {
        final String localeName = LocaleInfo.getCurrentLocale().getLocaleName();
        this.dataMiningService.getDataRetrieverChainDefinitions(localeName, new AsyncCallback<ArrayList<DataRetrieverChainDefinitionDTO>>(){

            public void onSuccess(ArrayList<DataRetrieverChainDefinitionDTO> dataRetrieverChainDefinitions) {
                SuggestBoxStatisticProvider.this.settingsMap.clear();
                for (DataRetrieverChainDefinitionDTO retrieverChain : dataRetrieverChainDefinitions) {
                    if (!retrieverChain.hasSettings()) continue;
                    SuggestBoxStatisticProvider.this.settingsMap.put(retrieverChain, retrieverChain.getDefaultSettings());
                }
                SuggestBoxStatisticProvider.this.updateIdentityFunctions(localeName, dataRetrieverChainDefinitions);
                SuggestBoxStatisticProvider.this.updateStatistics(localeName, dataRetrieverChainDefinitions);
            }

            public void onFailure(Throwable caught) {
                SuggestBoxStatisticProvider.this.errorReporter.reportError("Error fetching the retriever chain definitions: " + caught.getMessage());
            }
        });
    }

    private void updateIdentityFunctions(String localeName, final Collection<DataRetrieverChainDefinitionDTO> retrieverChains) {
        this.availableIdentityFunctions.clear();
        if (retrieverChains.isEmpty()) {
            return;
        }
        this.dataMiningService.getIdentityFunction(localeName, new AsyncCallback<FunctionDTO>(){

            public void onSuccess(FunctionDTO identityFunction) {
                SuggestBoxStatisticProvider.this.identityFunction = identityFunction;
                for (DataRetrieverChainDefinitionDTO retrieverChain : retrieverChains) {
                    SuggestBoxStatisticProvider.this.availableIdentityFunctions.add(new ExtractionFunctionWithContext.IdentityFunctionWithContext(retrieverChain, identityFunction));
                }
                Collections.sort(SuggestBoxStatisticProvider.this.availableIdentityFunctions);
            }

            public void onFailure(Throwable caught) {
                SuggestBoxStatisticProvider.this.errorReporter.reportError("Error fetching the identity function: " + caught.getMessage());
            }
        });
    }

    private void updateStatistics(final String localeName, Collection<DataRetrieverChainDefinitionDTO> retrieverChains) {
        this.availableStatistics.clear();
        if (retrieverChains.isEmpty()) {
            this.extractionFunctionSuggestBox.setExtractionFunction(null);
            this.extractionFunctionSuggestBox.setSelectableValues(Collections.emptySet());
            return;
        }
        this.awaitingRetrieverChainStatistics = retrieverChains.size();
        this.awaitingAggregators = 0;
        for (final DataRetrieverChainDefinitionDTO retrieverChain : retrieverChains) {
            this.dataMiningService.getStatisticsFor(retrieverChain, localeName, new AsyncCallback<HashSet<FunctionDTO>>(){

                public void onSuccess(HashSet<FunctionDTO> statistics) {
                    SuggestBoxStatisticProvider.this.collectStatistics(localeName, retrieverChain, statistics);
                }

                public void onFailure(Throwable caught) {
                    SuggestBoxStatisticProvider.this.errorReporter.reportError("Error fetching the statistics for the retriever chain '" + retrieverChain + "': " + caught.getMessage());
                    SuggestBoxStatisticProvider.this.collectStatistics(localeName, retrieverChain, Collections.emptySet());
                }
            });
        }
    }

    private void collectStatistics(String localeName, DataRetrieverChainDefinitionDTO retrieverChain, Iterable<FunctionDTO> extractionFunctions) {
        for (final FunctionDTO extractionFunction : extractionFunctions) {
            this.availableStatistics.add(new ExtractionFunctionWithContext.StatisticWithContext(retrieverChain, extractionFunction));
            if (this.collectedAggregators.containsKey(extractionFunction.getReturnTypeName())) continue;
            ++this.awaitingAggregators;
            this.dataMiningService.getAggregatorDefinitionsFor(extractionFunction, localeName, new AsyncCallback<HashSet<AggregationProcessorDefinitionDTO>>(){

                public void onSuccess(HashSet<AggregationProcessorDefinitionDTO> aggregators) {
                    SuggestBoxStatisticProvider.this.collectAggregators(extractionFunction, aggregators);
                }

                public void onFailure(Throwable caught) {
                    SuggestBoxStatisticProvider.this.errorReporter.reportError("Error fetching the aggregators for " + extractionFunction, caught.getMessage());
                    SuggestBoxStatisticProvider.this.collectAggregators(null, null);
                }
            });
        }
        --this.awaitingRetrieverChainStatistics;
        if (this.awaitingRetrieverChainStatistics <= 0) {
            this.extractionFunctionSuggestBox.setExtractionFunction(null);
            this.extractionFunctionSuggestBox.setSelectableValues(this.availableStatistics);
            this.extractionFunctionSuggestBox.setGroupingSuggestionsByRetrieverChain(true);
            if (this.awaitingAggregators <= 0) {
                this.collectAggregators(null, null);
            }
        }
    }

    private void collectAggregators(FunctionDTO extractionFunction, Iterable<AggregationProcessorDefinitionDTO> aggregators) {
        if (extractionFunction != null) {
            String returnTypeName = extractionFunction.getReturnTypeName();
            Set<AggregationProcessorDefinitionDTO> aggregatorsForType = this.collectedAggregators.get(returnTypeName);
            if (aggregatorsForType == null) {
                aggregatorsForType = new HashSet<AggregationProcessorDefinitionDTO>();
                this.collectedAggregators.put(returnTypeName, aggregatorsForType);
            }
            Util.addAll(aggregators, aggregatorsForType);
        }
        --this.awaitingAggregators;
        if (this.awaitingAggregators <= 0) {
            HashMap<String, AggregatorGroup> aggregatorGroups = new HashMap<String, AggregatorGroup>();
            for (String returnTypeName : this.collectedAggregators.keySet()) {
                for (AggregationProcessorDefinitionDTO aggregator : this.collectedAggregators.get(returnTypeName)) {
                    String extractedTypeName;
                    String aggregatorKey = aggregator.getMessageKey();
                    AggregatorGroup aggregatorGroup = (AggregatorGroup)aggregatorGroups.get(aggregatorKey);
                    if (aggregatorGroup == null) {
                        aggregatorGroup = new AggregatorGroup(aggregatorKey);
                        aggregatorGroups.put(aggregatorKey, aggregatorGroup);
                    }
                    if (!aggregatorGroup.supportsType(extractedTypeName = aggregator.getExtractedTypeName())) {
                        aggregatorGroup.setForType(extractedTypeName, aggregator);
                    }
                    if (aggregatorGroup.supportsType(returnTypeName)) continue;
                    aggregatorGroup.setForType(returnTypeName, aggregator);
                }
            }
            this.availableAggregators.clear();
            this.availableAggregators.addAll(aggregatorGroups.values());
            Collections.sort(this.availableAggregators);
            this.aggregatorListBox.setValue(null, true);
            this.aggregatorListBox.setAcceptableValues(this.availableAggregators);
            this.aggregatorListBox.setEnabled(!this.availableAggregators.isEmpty());
            this.initializationComplete = true;
            this.initializationCompleteListeners.forEach(i -> i.run());
            this.initializationCompleteListeners.clear();
        }
    }

    private void aggregatorSelectionChanged(AggregatorGroup oldAggregator, AggregatorGroup newAggregator) {
        boolean currentAggregatorSupportsIdentityFunction = oldAggregator != null && oldAggregator.supportsFunction(this.identityFunction);
        boolean newAggregatorSupportsIdentityFunction = newAggregator != null && newAggregator.supportsFunction(this.identityFunction);
        List<ExtractionFunctionWithContext> selectableExtractionFunctions = newAggregatorSupportsIdentityFunction ? this.availableIdentityFunctions : this.availableStatistics;
        ExtractionFunctionWithContext currentExtractionFunction = this.extractionFunctionSuggestBox.getExtractionFunction();
        if (currentExtractionFunction != null && newAggregator != null && !newAggregator.supportsFunction(currentExtractionFunction)) {
            if (newAggregatorSupportsIdentityFunction && !currentAggregatorSupportsIdentityFunction) {
                for (ExtractionFunctionWithContext.IdentityFunctionWithContext identityFunction : this.availableIdentityFunctions) {
                    if (!identityFunction.getRetrieverChain().equals((Object)currentExtractionFunction.getRetrieverChain())) continue;
                    this.extractionFunctionSuggestBox.setExtractionFunction(identityFunction);
                    break;
                }
            } else {
                this.extractionFunctionSuggestBox.setExtractionFunction(null);
            }
        }
        this.extractionFunctionSuggestBox.setSelectableValues(selectableExtractionFunctions);
        this.extractionFunctionSuggestBox.setGroupingSuggestionsByRetrieverChain(!newAggregatorSupportsIdentityFunction);
        this.notifyAggregatorDefinitionListeners();
    }

    private void extractionFunctionSelectionChanged(ExtractionFunctionWithContext oldExtractionFunction, ExtractionFunctionWithContext newExtractionFunction) {
        DataRetrieverChainDefinitionDTO newRetrieverChain;
        this.aggregatorListBox.updateItemStyles(newExtractionFunction);
        AggregatorGroup aggregator = (AggregatorGroup)this.aggregatorListBox.getValue();
        if (aggregator != null && newExtractionFunction != null && !aggregator.supportsFunction(newExtractionFunction)) {
            this.aggregatorListBox.setValue(null, true);
        }
        DataRetrieverChainDefinitionDTO oldRetrieverChain = oldExtractionFunction == null ? null : oldExtractionFunction.getRetrieverChain();
        DataRetrieverChainDefinitionDTO dataRetrieverChainDefinitionDTO = newRetrieverChain = newExtractionFunction == null ? null : newExtractionFunction.getRetrieverChain();
        if (!Objects.equals(oldRetrieverChain, newRetrieverChain)) {
            this.notifyRetrieverChainListeners();
        }
        this.notifyExtractionFunctionListeners();
    }

    @Override
    public HashMap<DataRetrieverLevelDTO, SerializableSettings> getRetrieverSettings() {
        DataRetrieverChainDefinitionDTO retrieverChain = this.getDataRetrieverChainDefinition();
        if (retrieverChain != null && this.settingsMap.containsKey(retrieverChain)) {
            return this.settingsMap.get(retrieverChain);
        }
        return new HashMap<DataRetrieverLevelDTO, SerializableSettings>();
    }

    public boolean hasSettings() {
        DataRetrieverChainDefinitionDTO retrieverChain = this.getDataRetrieverChainDefinition();
        return retrieverChain != null && retrieverChain.hasSettings();
    }

    public SettingsDialogComponent<CompositeSettings> getSettingsDialogComponent(CompositeSettings settings) {
        this.retrieverLevelSettingsComponents.clear();
        this.retrieverLevelSettingsComponents.addAll(this.createSettingsComponentsFor(this.getDataRetrieverChainDefinition()));
        return new CompositeTabbedSettingsDialogComponent(this.retrieverLevelSettingsComponents);
    }

    private List<Component<?>> createSettingsComponentsFor(final DataRetrieverChainDefinitionDTO retrieverChain) {
        ArrayList settingsComponents = new ArrayList();
        for (Map.Entry<DataRetrieverLevelDTO, SerializableSettings> retrieverLevelSettings : this.settingsMap.get(retrieverChain).entrySet()) {
            final DataRetrieverLevelDTO retrieverLevel = retrieverLevelSettings.getKey();
            final Class<?> settingsType = retrieverLevelSettings.getValue().getClass();
            DataMiningSettingsInfo settingsInfo = this.settingsManager.getSettingsInfo(settingsType);
            settingsComponents.add((Component<?>)new RetrieverLevelSettingsComponent(this, this.getComponentContext(), retrieverLevel, settingsInfo.getId(), settingsInfo.getLocalizedName()){

                public SettingsDialogComponent<SerializableSettings> getSettingsDialogComponent(SerializableSettings settings) {
                    return SuggestBoxStatisticProvider.this.settingsManager.getSettingsInfo(settingsType).createSettingsDialogComponent((SerializableSettings)((HashMap)SuggestBoxStatisticProvider.this.settingsMap.get(retrieverChain)).get(retrieverLevel));
                }

                public void updateSettings(SerializableSettings newSettings) {
                    ((HashMap)SuggestBoxStatisticProvider.this.settingsMap.get(retrieverChain)).put(retrieverLevel, newSettings);
                }
            });
        }
        return settingsComponents;
    }

    public void updateSettings(CompositeSettings newSettings) {
        Map chainSettings = this.settingsMap.get(this.getDataRetrieverChainDefinition());
        for (Map.Entry settingsPerComponent : newSettings.getSettingsPerComponentId().entrySet()) {
            RetrieverLevelSettingsComponent component = (RetrieverLevelSettingsComponent)this.findComponentById((String)settingsPerComponent.getKey());
            SerializableSettings settings = (SerializableSettings)settingsPerComponent.getValue();
            chainSettings.put(component.getRetrieverLevel(), settings);
        }
        this.notifyRetrieverChainListeners();
    }

    private Component<?> findComponentById(String componentId) {
        for (Component<?> component : this.retrieverLevelSettingsComponents) {
            if (!component.getId().equals(componentId)) continue;
            return component;
        }
        return null;
    }

    public CompositeSettings getSettings() {
        HashMap<String, SerializableSettings> settings = new HashMap<String, SerializableSettings>();
        DataRetrieverChainDefinitionDTO retrieverChain = this.getDataRetrieverChainDefinition();
        if (retrieverChain != null) {
            for (Map.Entry<DataRetrieverLevelDTO, SerializableSettings> retrieverLevelSettings : this.settingsMap.get(retrieverChain).entrySet()) {
                DataRetrieverLevelDTO retrieverLevel = retrieverLevelSettings.getKey();
                Class<?> settingsType = retrieverLevelSettings.getValue().getClass();
                DataMiningSettingsInfo settingsInfo = this.settingsManager.getSettingsInfo(settingsType);
                RetrieverLevelSettingsComponent c = new RetrieverLevelSettingsComponent(this, this.getComponentContext(), retrieverLevel, settingsInfo.getId(), settingsInfo.getLocalizedName()){

                    public SettingsDialogComponent<SerializableSettings> getSettingsDialogComponent(SerializableSettings settings) {
                        return null;
                    }

                    public void updateSettings(SerializableSettings newSettings) {
                    }
                };
                settings.put(c.getId(), c.hasSettings() ? c.getSettings() : null);
            }
        }
        return new CompositeSettings(settings);
    }

    @Override
    public void applyQueryDefinition(StatisticQueryDefinitionDTO queryDefinition, Consumer<Iterable<String>> callback) {
        ArrayList<String> errorMessages = new ArrayList<String>();
        if (!this.initializationComplete) {
            this.initializationCompleteListeners.add(() -> this.applyQueryDefinition(queryDefinition, callback));
            return;
        }
        AggregationProcessorDefinitionDTO aggregator = queryDefinition.getAggregatorDefinition();
        AggregatorGroup aggregatorToSelect = null;
        for (AggregatorGroup availableAggregator : this.availableAggregators) {
            if (!availableAggregator.getKey().equals(aggregator.getMessageKey()) || !availableAggregator.supportsType(aggregator.getExtractedTypeName())) continue;
            aggregatorToSelect = availableAggregator;
            break;
        }
        this.aggregatorListBox.setValue(aggregatorToSelect, true);
        if (aggregatorToSelect == null) {
            errorMessages.add(this.getDataMiningStringMessages().aggregatorNotAvailable(aggregator.getDisplayName()));
        }
        DataRetrieverChainDefinitionDTO retrieverChain = queryDefinition.getDataRetrieverChainDefinition();
        FunctionDTO extractionFunction = queryDefinition.getStatisticToCalculate();
        boolean isIdentityFunction = this.identityFunction != null && this.identityFunction.equals((Object)extractionFunction);
        ExtractionFunctionWithContext extractionFunctionToSelect = null;
        if (isIdentityFunction) {
            ExtractionFunctionWithContext.IdentityFunctionWithContext identityFunctionWrapper = new ExtractionFunctionWithContext.IdentityFunctionWithContext(retrieverChain, extractionFunction);
            int index = this.availableIdentityFunctions.indexOf(identityFunctionWrapper);
            if (index != -1) {
                extractionFunctionToSelect = this.availableIdentityFunctions.get(index);
            }
        } else {
            ExtractionFunctionWithContext.StatisticWithContext statisticWrapper = new ExtractionFunctionWithContext.StatisticWithContext(retrieverChain, extractionFunction);
            int index = this.availableStatistics.indexOf(statisticWrapper);
            if (index != -1) {
                extractionFunctionToSelect = this.availableStatistics.get(index);
            }
        }
        this.extractionFunctionSuggestBox.setExtractionFunction(extractionFunctionToSelect);
        if (extractionFunctionToSelect != null) {
            this.setSettings(retrieverChain, queryDefinition.getRetrieverSettings());
        } else {
            errorMessages.add(this.getDataMiningStringMessages().statisticNotAvailable(extractionFunction.getDisplayName()));
        }
        callback.accept(errorMessages);
    }

    private void setSettings(DataRetrieverChainDefinitionDTO retrieverChain, HashMap<DataRetrieverLevelDTO, SerializableSettings> settings) {
        HashMap<DataRetrieverLevelDTO, SerializableSettings> newSettings = new HashMap<DataRetrieverLevelDTO, SerializableSettings>();
        int level = 0;
        while (level < retrieverChain.getLevelAmount()) {
            DataRetrieverLevelDTO retrieverLevel = retrieverChain.getRetrieverLevel(level);
            if (retrieverLevel.hasSettings()) {
                SerializableSettings levelSettings = settings.get(retrieverLevel);
                if (levelSettings == null) {
                    levelSettings = retrieverLevel.getDefaultSettings();
                }
                newSettings.put(retrieverLevel, levelSettings);
            }
            ++level;
        }
        this.settingsMap.put(retrieverChain, newSettings);
    }

    @Override
    public void addStatisticChangedListener(StatisticChangedListener listener) {
        this.retrieverChainListeners.add(listener);
        this.extractionFunctionListeners.add(listener);
        this.aggregatorDefinitionListeners.add(listener);
    }

    @Override
    public void addDataRetrieverChainDefinitionChangedListener(DataRetrieverChainDefinitionChangedListener listener) {
        this.retrieverChainListeners.add(listener);
    }

    private void notifyRetrieverChainListeners() {
        DataRetrieverChainDefinitionDTO dataRetrieverChainDefinition = this.getDataRetrieverChainDefinition();
        for (DataRetrieverChainDefinitionChangedListener listener : this.retrieverChainListeners) {
            listener.dataRetrieverChainDefinitionChanged(dataRetrieverChainDefinition);
        }
    }

    @Override
    public void addExtractionFunctionChangedListener(ExtractionFunctionChangedListener listener) {
        this.extractionFunctionListeners.add(listener);
    }

    private void notifyExtractionFunctionListeners() {
        FunctionDTO extractionFunction = this.getExtractionFunction();
        for (ExtractionFunctionChangedListener listener : this.extractionFunctionListeners) {
            listener.extractionFunctionChanged(extractionFunction);
        }
    }

    @Override
    public void addAggregatorDefinitionChangedListener(AggregatorDefinitionChangedListener listener) {
        this.aggregatorDefinitionListeners.add(listener);
    }

    private void notifyAggregatorDefinitionListeners() {
        AggregationProcessorDefinitionDTO aggregatorDefinition = this.getAggregatorDefinition();
        for (AggregatorDefinitionChangedListener listener : this.aggregatorDefinitionListeners) {
            listener.aggregatorDefinitionChanged(aggregatorDefinition);
        }
    }

    @Override
    public DataRetrieverChainDefinitionDTO getDataRetrieverChainDefinition() {
        ExtractionFunctionWithContext extractionFunction = this.extractionFunctionSuggestBox.getExtractionFunction();
        return extractionFunction == null ? null : extractionFunction.getRetrieverChain();
    }

    @Override
    public FunctionDTO getExtractionFunction() {
        ExtractionFunctionWithContext extractionFunction = this.extractionFunctionSuggestBox.getExtractionFunction();
        return extractionFunction == null ? null : extractionFunction.getExtractionFunction();
    }

    @Override
    public AggregationProcessorDefinitionDTO getAggregatorDefinition() {
        AggregatorGroup aggregator = (AggregatorGroup)this.aggregatorListBox.getValue();
        FunctionDTO extractionFunction = this.getExtractionFunction();
        if (aggregator == null || extractionFunction == null) {
            return null;
        }
        return aggregator.getForType(extractionFunction.getReturnTypeName());
    }

    public String getLocalizedShortName() {
        return this.getDataMiningStringMessages().statisticProvider();
    }

    public Widget getEntryWidget() {
        return this.mainPanel;
    }

    public boolean isVisible() {
        return this.mainPanel.isVisible();
    }

    public void setVisible(boolean visibility) {
        this.mainPanel.setVisible(visibility);
    }

    public String getDependentCssClassName() {
        return "globalStatisticsProvider";
    }

    public String getId() {
        return "GlobalStatisticProvider";
    }
}

