/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.datamining.ui.client.selection.statistic;

import com.sap.sse.datamining.shared.impl.dto.AggregationProcessorDefinitionDTO;
import com.sap.sse.datamining.shared.impl.dto.FunctionDTO;
import com.sap.sse.datamining.ui.client.selection.statistic.ExtractionFunctionWithContext;
import java.util.HashMap;
import java.util.Map;

class AggregatorGroup
implements Comparable<AggregatorGroup> {
    private final String key;
    private final Map<String, AggregationProcessorDefinitionDTO> aggregatorsBySupportedTypeName;
    private String displayName;

    public AggregatorGroup(String key) {
        this.key = key;
        this.aggregatorsBySupportedTypeName = new HashMap<String, AggregationProcessorDefinitionDTO>();
    }

    public String getKey() {
        return this.key;
    }

    public boolean supportsFunction(ExtractionFunctionWithContext extractionFunction) {
        return extractionFunction != null && this.supportsFunction(extractionFunction.getExtractionFunction());
    }

    public boolean supportsFunction(FunctionDTO function) {
        return function != null && this.supportsType(function.getReturnTypeName());
    }

    public boolean supportsType(String typeName) {
        return this.aggregatorsBySupportedTypeName.containsKey(typeName);
    }

    public AggregationProcessorDefinitionDTO getForType(String typeName) {
        return this.aggregatorsBySupportedTypeName.get(typeName);
    }

    public void setForType(String typeName, AggregationProcessorDefinitionDTO aggregator) {
        if (this.displayName == null) {
            this.displayName = aggregator.getDisplayName();
        }
        this.aggregatorsBySupportedTypeName.put(typeName, aggregator);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public int compareTo(AggregatorGroup other) {
        if (other == null) {
            return 1;
        }
        return this.displayName.compareToIgnoreCase(other.displayName);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.aggregatorsBySupportedTypeName == null ? 0 : this.aggregatorsBySupportedTypeName.hashCode());
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AggregatorGroup other = (AggregatorGroup)obj;
        if (this.aggregatorsBySupportedTypeName == null ? other.aggregatorsBySupportedTypeName != null : !this.aggregatorsBySupportedTypeName.equals(other.aggregatorsBySupportedTypeName)) {
            return false;
        }
        return !(this.key == null ? other.key != null : !this.key.equals(other.key));
    }
}

