/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.datamining.ui.client.selection;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.CheckboxCell;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.dom.builder.shared.DivBuilder;
import com.google.gwt.dom.builder.shared.TableCellBuilder;
import com.google.gwt.dom.builder.shared.TableRowBuilder;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.dom.client.NodeList;
import com.google.gwt.dom.client.Style;
import com.google.gwt.dom.client.TableCellElement;
import com.google.gwt.dom.client.TableRowElement;
import com.google.gwt.i18n.client.LocaleInfo;
import com.google.gwt.user.cellview.client.AbstractCellTable;
import com.google.gwt.user.cellview.client.CellTableBuilder;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.DataGrid;
import com.google.gwt.user.cellview.client.RowHoverEvent;
import com.google.gwt.user.cellview.client.TextColumn;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.DockLayoutPanel;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.CellPreviewEvent;
import com.google.gwt.view.client.DefaultSelectionEventManager;
import com.google.gwt.view.client.ListDataProvider;
import com.google.gwt.view.client.MultiSelectionModel;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.sap.sse.common.Util;
import com.sap.sse.common.settings.SerializableSettings;
import com.sap.sse.datamining.shared.DataMiningSession;
import com.sap.sse.datamining.shared.data.ReportParameterToDimensionFilterBindings;
import com.sap.sse.datamining.shared.dto.StatisticQueryDefinitionDTO;
import com.sap.sse.datamining.shared.impl.dto.DataRetrieverChainDefinitionDTO;
import com.sap.sse.datamining.shared.impl.dto.DataRetrieverLevelDTO;
import com.sap.sse.datamining.shared.impl.dto.FunctionDTO;
import com.sap.sse.datamining.shared.impl.dto.ReducedDimensionsDTO;
import com.sap.sse.datamining.ui.client.AbstractDataMiningComponent;
import com.sap.sse.datamining.ui.client.DataMiningServiceAsync;
import com.sap.sse.datamining.ui.client.DataRetrieverChainDefinitionProvider;
import com.sap.sse.datamining.ui.client.FilterSelectionChangedListener;
import com.sap.sse.datamining.ui.client.FilterSelectionPresenter;
import com.sap.sse.datamining.ui.client.FilterSelectionProvider;
import com.sap.sse.datamining.ui.client.ReportProvider;
import com.sap.sse.datamining.ui.client.StringMessages;
import com.sap.sse.datamining.ui.client.presentation.PlainFilterSelectionPresenter;
import com.sap.sse.datamining.ui.client.resources.DataMiningDataGridResources;
import com.sap.sse.datamining.ui.client.selection.DimensionFilterSelectionProvider;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.celltable.BaseCellTableBuilder;
import com.sap.sse.gwt.client.panels.AbstractFilterablePanel;
import com.sap.sse.gwt.client.shared.components.Component;
import com.sap.sse.gwt.client.shared.components.SettingsDialogComponent;
import com.sap.sse.gwt.client.shared.settings.ComponentContext;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class HierarchicalDimensionListFilterSelectionProvider
extends AbstractDataMiningComponent<SerializableSettings>
implements FilterSelectionProvider {
    private static final String DimensionListSubheaderAttribute = "subheader";
    private static final Style.Unit LayoutUnit = Style.Unit.PX;
    private static final double SelectionPresenterHeight = 100.0;
    private static final double DimensionSelectionWidth = 350.0;
    private static final double DimensionSelectionHeaderHeight = 30.0;
    private static final double FilterFilterDimensionsHeight = 40.0;
    private static final double FilterSelectionTableWidth = 250.0;
    private final DataMiningSession session;
    private final DataMiningServiceAsync dataMiningService;
    private final ErrorReporter errorReporter;
    private final DataRetrieverChainDefinitionProvider retrieverChainProvider;
    private final Set<FilterSelectionChangedListener> listeners;
    private boolean isAwaitingReload;
    private boolean isUpdatingFilterDimensions;
    private boolean ignoreSelectionChangedNotifications;
    private DataRetrieverChainDefinitionDTO retrieverChain;
    private ReducedDimensionsDTO reducedDimensions;
    private final List<DimensionWithContext> availableFilterDimensions;
    private final ListDataProvider<DimensionWithContext> filteredFilterDimensions;
    private final DockLayoutPanel mainPanel;
    private final Button clearSelectionButton;
    private final AbstractFilterablePanel<DimensionWithContext> filterFilterDimensionsPanel;
    private final MultiSelectionModel<DimensionWithContext> filterDimensionSelectionModel;
    private final DataGrid<DimensionWithContext> filterDimensionsList;
    private final Column<DimensionWithContext, Boolean> checkboxColumn;
    private final DockLayoutPanel dimensionFilterSelectionProvidersPanel;
    private final Map<DimensionWithContext, DimensionFilterSelectionProvider> dimensionFilterSelectionProviders;
    private boolean isUpdatingAvailableFilterValues;
    private final FilterSelectionPresenter filterSelectionPresenter;
    private final ScrollPanel filterSelectionPresenterContainer;
    private HashMap<DataRetrieverLevelDTO, HashMap<FunctionDTO, HashSet<? extends Serializable>>> selectionToBeApplied;
    private Consumer<Iterable<String>> selectionCallback;
    private final ReportProvider reportProvider;
    private final ReportParameterToDimensionFilterBindings reportParameterBindings;

    public HierarchicalDimensionListFilterSelectionProvider(Component<?> parent, ComponentContext<?> context, DataMiningSession session, DataMiningServiceAsync dataMiningService, ErrorReporter errorReporter, DataRetrieverChainDefinitionProvider retrieverChainProvider, ReportProvider reportProvider, ReportParameterToDimensionFilterBindings reportParameterBindings) {
        super(parent, context);
        this.session = session;
        this.dataMiningService = dataMiningService;
        this.errorReporter = errorReporter;
        this.retrieverChainProvider = retrieverChainProvider;
        this.reportProvider = reportProvider;
        this.reportParameterBindings = reportParameterBindings;
        retrieverChainProvider.addDataRetrieverChainDefinitionChangedListener(this);
        this.listeners = new HashSet<FilterSelectionChangedListener>();
        this.isAwaitingReload = false;
        this.retrieverChain = null;
        this.availableFilterDimensions = new ArrayList<DimensionWithContext>();
        this.filteredFilterDimensions = new ListDataProvider();
        StringMessages stringMessages = this.getDataMiningStringMessages();
        Label filterDimensionsSelectionTitleLabel = new Label(stringMessages.selectDimensionsToFilterBy());
        filterDimensionsSelectionTitleLabel.addStyleName("emphasizedLabel");
        filterDimensionsSelectionTitleLabel.addStyleName("dataMiningMarginLeft");
        filterDimensionsSelectionTitleLabel.addStyleName("filterDimensionsTitleLabel");
        this.clearSelectionButton = new Button(stringMessages.clear());
        this.clearSelectionButton.addStyleName("floatRight");
        this.clearSelectionButton.addStyleName("dataMiningMarginRight");
        this.clearSelectionButton.addClickHandler(e -> this.clearSelection());
        DataMiningDataGridResources resources = (DataMiningDataGridResources)GWT.create(DataMiningDataGridResources.class);
        this.filterDimensionsList = new DataGrid(Integer.MAX_VALUE, (DataGrid.Resources)resources);
        this.filterDimensionsList.setAutoHeaderRefreshDisabled(true);
        this.filterDimensionsList.setAutoFooterRefreshDisabled(true);
        this.filterDimensionsList.setTableBuilder((CellTableBuilder)new FilterDimensionsListBuilder((AbstractCellTable<DimensionWithContext>)this.filterDimensionsList, resources.dataGridStyle()));
        this.filteredFilterDimensions.addDataDisplay(this.filterDimensionsList);
        this.filterFilterDimensionsPanel = new AbstractFilterablePanel<DimensionWithContext>(null, this.filteredFilterDimensions, (com.sap.sse.gwt.client.StringMessages)stringMessages){

            public Iterable<String> getSearchableStrings(DimensionWithContext dimension) {
                return dimension.getMatchingStrings();
            }

            public AbstractCellTable<DimensionWithContext> getCellTable() {
                return HierarchicalDimensionListFilterSelectionProvider.this.filterDimensionsList;
            }
        };
        this.filterFilterDimensionsPanel.addStyleName("filterFilterDimensionsPanel");
        this.filterFilterDimensionsPanel.setSpacing(2);
        this.filterFilterDimensionsPanel.setWidth("100%");
        this.filterFilterDimensionsPanel.setHeight("100%");
        this.filterFilterDimensionsPanel.getTextBox().setWidth("100%");
        this.filterFilterDimensionsPanel.getTextBox().getElement().setPropertyString("placeholder", stringMessages.filterShownDimensions());
        this.filterDimensionSelectionModel = new MultiSelectionModel();
        this.filterDimensionSelectionModel.addSelectionChangeHandler(this::selectedFilterDimensionsChanged);
        this.filterDimensionsList.setSelectionModel(this.filterDimensionSelectionModel, (CellPreviewEvent.Handler)DefaultSelectionEventManager.createCustomManager((DefaultSelectionEventManager.EventTranslator)new CustomCheckboxEventTranslator()));
        this.checkboxColumn = new Column<DimensionWithContext, Boolean>((Cell)new CheckboxCell(true, false)){

            public Boolean getValue(DimensionWithContext object) {
                return HierarchicalDimensionListFilterSelectionProvider.this.filterDimensionSelectionModel.isSelected((Object)object);
            }
        };
        this.filterDimensionsList.addColumn(this.checkboxColumn);
        TextColumn<DimensionWithContext> dimensionColumn = new TextColumn<DimensionWithContext>(){

            public String getValue(DimensionWithContext object) {
                return object.getDimension().getDisplayName();
            }
        };
        this.filterDimensionsList.addColumn((Column)dimensionColumn);
        FlowPanel headerPanel = new FlowPanel();
        headerPanel.addStyleName("dataMiningMarginTop");
        headerPanel.add((Widget)filterDimensionsSelectionTitleLabel);
        headerPanel.add((Widget)this.clearSelectionButton);
        DockLayoutPanel filterDimensionsSelectionPanel = new DockLayoutPanel(LayoutUnit);
        filterDimensionsSelectionPanel.addNorth((Widget)headerPanel, 30.0);
        filterDimensionsSelectionPanel.addNorth(this.filterFilterDimensionsPanel, 40.0);
        filterDimensionsSelectionPanel.add(this.filterDimensionsList);
        this.dimensionFilterSelectionProviders = new HashMap<DimensionWithContext, DimensionFilterSelectionProvider>();
        this.dimensionFilterSelectionProvidersPanel = new DockLayoutPanel(LayoutUnit);
        this.dimensionFilterSelectionProvidersPanel.addStyleName("dimensionFilterSelectionTablesContainer");
        this.dimensionFilterSelectionProvidersPanel.addStyleName("dataMiningBorderLeft");
        this.filterSelectionPresenter = new PlainFilterSelectionPresenter(this, context, stringMessages, this);
        this.filterSelectionPresenterContainer = new ScrollPanel(this.filterSelectionPresenter.getEntryWidget());
        this.filterSelectionPresenterContainer.addStyleName("dataMiningBorderTop");
        this.mainPanel = new DockLayoutPanel(LayoutUnit);
        this.mainPanel.addSouth((Widget)this.filterSelectionPresenterContainer, 100.0);
        this.mainPanel.setWidgetHidden((Widget)this.filterSelectionPresenterContainer, true);
        this.mainPanel.addWest((Widget)filterDimensionsSelectionPanel, 350.0);
        this.mainPanel.add((Widget)this.dimensionFilterSelectionProvidersPanel);
        this.updateControls();
    }

    @Override
    public void awaitReloadComponents() {
        this.isAwaitingReload = true;
    }

    @Override
    public boolean isAwaitingReload() {
        return this.isAwaitingReload;
    }

    @Override
    public void reloadComponents() {
        this.isAwaitingReload = false;
        this.updateFilterDimensions();
    }

    @Override
    public void dataRetrieverChainDefinitionChanged(DataRetrieverChainDefinitionDTO newDataRetrieverChainDefinition) {
        if (!Objects.equals(this.retrieverChain, newDataRetrieverChainDefinition)) {
            this.retrieverChain = newDataRetrieverChainDefinition;
            if (!this.isAwaitingReload) {
                this.updateFilterDimensions();
            }
        }
    }

    private void updateFilterDimensions() {
        HashMap<DataRetrieverLevelDTO, HashMap<FunctionDTO, HashSet<? extends Serializable>>> currentSelection = this.getSelection();
        if (!currentSelection.isEmpty()) {
            this.selectionToBeApplied = currentSelection;
            this.selectionCallback = EmptyApplyCallback;
        }
        if (this.retrieverChain != null) {
            this.isUpdatingFilterDimensions = true;
            this.clearContent();
            this.dataMiningService.getReducedDimensionsMappedByLevelFor(this.retrieverChain, LocaleInfo.getCurrentLocale().getLocaleName(), new AsyncCallback<ReducedDimensionsDTO>(){

                public void onSuccess(ReducedDimensionsDTO result) {
                    HierarchicalDimensionListFilterSelectionProvider.this.reducedDimensions = result;
                    for (Map.Entry entry : HierarchicalDimensionListFilterSelectionProvider.this.reducedDimensions.getReducedDimensions().entrySet()) {
                        DataRetrieverLevelDTO retrieverlevel = (DataRetrieverLevelDTO)entry.getKey();
                        for (FunctionDTO dimension : (HashSet)entry.getValue()) {
                            HierarchicalDimensionListFilterSelectionProvider.this.availableFilterDimensions.add(new DimensionWithContext(dimension, retrieverlevel));
                        }
                    }
                    HierarchicalDimensionListFilterSelectionProvider.this.availableFilterDimensions.sort(null);
                    HierarchicalDimensionListFilterSelectionProvider.this.filterFilterDimensionsPanel.updateAll((Iterable)HierarchicalDimensionListFilterSelectionProvider.this.availableFilterDimensions);
                    HierarchicalDimensionListFilterSelectionProvider.this.updateControls();
                    if (HierarchicalDimensionListFilterSelectionProvider.this.selectionToBeApplied != null) {
                        HierarchicalDimensionListFilterSelectionProvider.this.ignoreSelectionChangedNotifications = true;
                        HierarchicalDimensionListFilterSelectionProvider.this.setSelection(HierarchicalDimensionListFilterSelectionProvider.this.selectionToBeApplied, HierarchicalDimensionListFilterSelectionProvider.this.selectionCallback);
                        HierarchicalDimensionListFilterSelectionProvider.this.selectionToBeApplied = null;
                        HierarchicalDimensionListFilterSelectionProvider.this.selectionCallback = null;
                    }
                    HierarchicalDimensionListFilterSelectionProvider.this.isUpdatingFilterDimensions = false;
                }

                public void onFailure(Throwable caught) {
                    HierarchicalDimensionListFilterSelectionProvider.this.errorReporter.reportError("Error fetching the dimensions of the retriever chain from the server: " + caught.getMessage());
                    HierarchicalDimensionListFilterSelectionProvider.this.updateControls();
                    HierarchicalDimensionListFilterSelectionProvider.this.selectionToBeApplied = null;
                    HierarchicalDimensionListFilterSelectionProvider.this.selectionCallback = null;
                    HierarchicalDimensionListFilterSelectionProvider.this.isUpdatingFilterDimensions = false;
                }
            });
        } else {
            this.clearContent();
            this.updateControls();
        }
    }

    private void clearContent() {
        boolean notifyListeners = !this.getSelection().isEmpty();
        this.reducedDimensions = null;
        this.availableFilterDimensions.clear();
        this.filterDimensionSelectionModel.clear();
        this.filterFilterDimensionsPanel.removeAll();
        if (notifyListeners) {
            this.notifyListeners();
        }
    }

    private void updateControls() {
        boolean controlsEnabled = !this.availableFilterDimensions.isEmpty();
        this.clearSelectionButton.setEnabled(controlsEnabled);
        this.filterFilterDimensionsPanel.getTextBox().setEnabled(controlsEnabled);
    }

    @Override
    public void applyQueryDefinition(StatisticQueryDefinitionDTO queryDefinition, Consumer<Iterable<String>> callback) {
        DataRetrieverChainDefinitionDTO retrieverChain = queryDefinition.getDataRetrieverChainDefinition();
        this.selectionToBeApplied = queryDefinition.getFilterSelection();
        this.selectionCallback = callback;
        if (!this.isUpdatingFilterDimensions && !this.isAwaitingReload && retrieverChain.equals((Object)this.retrieverChain)) {
            this.ignoreSelectionChangedNotifications = true;
            ReportParameterToDimensionFilterBindings stash = new ReportParameterToDimensionFilterBindings(this.reportParameterBindings);
            this.filterDimensionSelectionModel.clear();
            this.filterDimensionSelectionModel.getSelectedSet();
            this.reportParameterBindings.set(stash);
            this.setSelection(this.selectionToBeApplied, this.selectionCallback);
            this.selectionToBeApplied = null;
            this.selectionCallback = null;
        }
    }

    private void setSelection(HashMap<DataRetrieverLevelDTO, HashMap<FunctionDTO, HashSet<? extends Serializable>>> filterSelection, Consumer<Iterable<String>> callback) {
        HashSet<InnerSelectionCallback> innerCallbacks = new HashSet<InnerSelectionCallback>();
        ArrayList<String> callbackMessages = new ArrayList<String>();
        ArrayList<DimensionWithContext> missingDimensions = new ArrayList<DimensionWithContext>();
        for (DataRetrieverLevelDTO retrieverLevel : filterSelection.keySet()) {
            HashMap<FunctionDTO, HashSet<? extends Serializable>> levelSelection = filterSelection.get(retrieverLevel);
            for (FunctionDTO dimension : levelSelection.keySet()) {
                DimensionWithContext dimensionWithContext = new DimensionWithContext(dimension, retrieverLevel);
                int index = this.availableFilterDimensions.indexOf(dimensionWithContext);
                if (index != -1) {
                    InnerSelectionCallback innerCallback = new InnerSelectionCallback(callbackMessages, innerCallbacks, callback);
                    innerCallbacks.add(innerCallback);
                    this.setDimensionSelection(this.availableFilterDimensions.get(index), (Collection<? extends Serializable>)levelSelection.get(dimension), innerCallback);
                    continue;
                }
                missingDimensions.add(dimensionWithContext);
            }
        }
        if (!missingDimensions.isEmpty()) {
            String listedDimensions = missingDimensions.stream().map(d -> d.getDimension().getDisplayName()).collect(Collectors.joining(", "));
            callbackMessages.add(this.getDataMiningStringMessages().filterDimensionsAreNotAvailable(listedDimensions));
        }
        if (!innerCallbacks.isEmpty()) {
            for (InnerSelectionCallback innerCallback : innerCallbacks) {
                innerCallback.canPublishMessages = true;
            }
        } else {
            this.setSelectionCompleted(callback, callbackMessages);
        }
    }

    private void setSelectionCompleted(Consumer<Iterable<String>> callback, Iterable<String> messages) {
        HashMap<DataRetrieverLevelDTO, HashMap<FunctionDTO, HashSet<? extends Serializable>>> selection = this.getSelection();
        this.ignoreSelectionChangedNotifications = false;
        Runnable finalizeSelection = () -> {
            this.mainPanel.setWidgetHidden((Widget)this.filterSelectionPresenterContainer, selection.isEmpty());
            this.filterSelectionPresenter.selectionChanged();
            callback.accept(messages);
        };
        if (this.dimensionFilterSelectionProviders.size() > 1) {
            this.isUpdatingAvailableFilterValues = false;
            this.updateAvailableFilterValues(this.retrieverChain.getRetrieverLevel(0), null, finalizeSelection);
        } else {
            finalizeSelection.run();
        }
    }

    @Override
    public void setFilterSelectionForUnreducedDimension(FunctionDTO unreducedDimension, Serializable filterValue, Runnable onCompletion) {
        FunctionDTO reducedDimension = this.reducedDimensions == null ? unreducedDimension : this.reducedDimensions.getReducedDimension(unreducedDimension);
        DimensionWithContext dimensionToChange = null;
        for (DimensionWithContext dimensionWithContext : this.availableFilterDimensions) {
            if (!dimensionWithContext.getDimension().equals((Object)reducedDimension)) continue;
            dimensionToChange = dimensionWithContext;
            break;
        }
        if (dimensionToChange != null) {
            this.ignoreSelectionChangedNotifications = true;
            DimensionWithContext changedDimension = dimensionToChange;
            this.setDimensionSelection(dimensionToChange, Collections.singleton(filterValue), m -> {
                this.ignoreSelectionChangedNotifications = false;
                if (this.dimensionFilterSelectionProviders.size() > 1) {
                    this.updateAvailableFilterValues(changedDimension.getRetrieverLevel(), changedDimension, onCompletion);
                } else {
                    onCompletion.run();
                }
            });
        }
    }

    private void setDimensionSelection(DimensionWithContext dimension, Collection<? extends Serializable> items, Consumer<Iterable<String>> callback) {
        DimensionFilterSelectionProvider selectionProvider;
        if (this.filterDimensionSelectionModel.isSelected((Object)dimension)) {
            selectionProvider = this.dimensionFilterSelectionProviders.get(dimension);
        } else {
            selectionProvider = this.addDimensionFilterSelectionProvider(dimension);
            this.filterDimensionSelectionModel.setSelected((Object)dimension, true);
        }
        selectionProvider.setSelection(items, callback);
    }

    private void selectedFilterDimensionsChanged(SelectionChangeEvent event) {
        HashSet<DimensionWithContext> displayedDimensions = new HashSet<DimensionWithContext>(this.dimensionFilterSelectionProviders.keySet());
        for (DimensionWithContext displayedDimension : displayedDimensions) {
            if (this.filterDimensionSelectionModel.isSelected((Object)displayedDimension)) continue;
            this.removeDimensionFilterSelectionProvider(displayedDimension);
        }
        for (DimensionWithContext selectedDimension : this.filterDimensionSelectionModel.getSelectedSet()) {
            if (this.dimensionFilterSelectionProviders.containsKey(selectedDimension)) continue;
            this.addDimensionFilterSelectionProvider(selectedDimension);
        }
    }

    private DimensionFilterSelectionProvider addDimensionFilterSelectionProvider(DimensionWithContext dimension) {
        DimensionFilterSelectionProvider selectionProvider = new DimensionFilterSelectionProvider(this, this.getComponentContext(), this.dataMiningService, this.errorReporter, this.session, this.retrieverChainProvider, this, dimension.getRetrieverLevel(), dimension.getDimension(), this.reportParameterBindings, this.reportProvider);
        selectionProvider.addListener(() -> this.filterSelectionChanged(dimension));
        this.dimensionFilterSelectionProviders.put(dimension, selectionProvider);
        DimensionWithContext nextDimension = null;
        for (DimensionWithContext displayedDimension : this.dimensionFilterSelectionProviders.keySet()) {
            if (displayedDimension.compareTo(dimension) <= 0 || nextDimension != null && displayedDimension.compareTo(nextDimension) >= 0) continue;
            nextDimension = displayedDimension;
        }
        Widget beforeWidget = nextDimension != null ? this.dimensionFilterSelectionProviders.get(nextDimension).getEntryWidget() : null;
        this.dimensionFilterSelectionProvidersPanel.insertWest(selectionProvider.getEntryWidget(), 250.0, beforeWidget);
        return selectionProvider;
    }

    private void removeDimensionFilterSelectionProvider(DimensionWithContext dimension) {
        DimensionFilterSelectionProvider selectionProvider = this.dimensionFilterSelectionProviders.get(dimension);
        if (selectionProvider != null) {
            selectionProvider.removedFromContainer();
            selectionProvider.clearSelection();
            this.dimensionFilterSelectionProviders.remove(dimension);
            this.dimensionFilterSelectionProvidersPanel.remove(selectionProvider.getEntryWidget());
            this.dimensionFilterSelectionProvidersPanel.animate(0);
        }
    }

    private void filterSelectionChanged(DimensionWithContext changedDimension) {
        if (!this.isUpdatingAvailableFilterValues && !this.ignoreSelectionChangedNotifications) {
            this.updateAvailableFilterValues(changedDimension.getRetrieverLevel(), changedDimension, this::notifyListeners);
        }
    }

    private void updateAvailableFilterValues(DataRetrieverLevelDTO fromRetrieverLevel, DimensionWithContext exceptDimension, Runnable onCompletion) {
        if (this.isUpdatingAvailableFilterValues) {
            throw new IllegalStateException("Update of availabe filter values already in progress");
        }
        ArrayList<DimensionWithContext> dimensionsToUpdate = new ArrayList<DimensionWithContext>();
        for (DimensionWithContext dimension : this.dimensionFilterSelectionProviders.keySet()) {
            if (dimension.getRetrieverLevel().getLevel() < fromRetrieverLevel.getLevel()) continue;
            dimensionsToUpdate.add(dimension);
        }
        dimensionsToUpdate.sort(null);
        this.isUpdatingAvailableFilterValues = true;
        this.updateDimensionFilterSelectionProviders(dimensionsToUpdate.iterator(), exceptDimension, onCompletion);
    }

    private void updateDimensionFilterSelectionProviders(Iterator<DimensionWithContext> dimensionIterator, DimensionWithContext exceptDimension, Runnable onCompletion) {
        if (dimensionIterator.hasNext()) {
            DimensionWithContext dimension = dimensionIterator.next();
            if (dimension.equals(exceptDimension)) {
                this.updateDimensionFilterSelectionProviders(dimensionIterator, exceptDimension, onCompletion);
            } else {
                DimensionFilterSelectionProvider selectionProvider = this.dimensionFilterSelectionProviders.get(dimension);
                HashSet<? extends Serializable> selectionBefore = selectionProvider.getSelection();
                selectionProvider.updateContent(() -> {
                    boolean selectionChanged;
                    boolean bl = selectionChanged = !selectionBefore.equals(selectionProvider.getSelection());
                    if (selectionChanged) {
                        this.isUpdatingAvailableFilterValues = false;
                        this.updateAvailableFilterValues(dimension.getRetrieverLevel(), dimension, onCompletion);
                    } else {
                        this.updateDimensionFilterSelectionProviders(dimensionIterator, exceptDimension, onCompletion);
                    }
                });
            }
        } else {
            this.isUpdatingAvailableFilterValues = false;
            onCompletion.run();
        }
    }

    @Override
    public HashMap<DataRetrieverLevelDTO, HashMap<FunctionDTO, HashSet<? extends Serializable>>> getSelection() {
        HashMap<DataRetrieverLevelDTO, HashMap<FunctionDTO, HashSet<? extends Serializable>>> filterSelection = new HashMap<DataRetrieverLevelDTO, HashMap<FunctionDTO, HashSet<? extends Serializable>>>();
        for (DimensionWithContext dimensionWithContext : this.dimensionFilterSelectionProviders.keySet()) {
            DataRetrieverLevelDTO retrieverLevel = dimensionWithContext.getRetrieverLevel();
            FunctionDTO dimension = dimensionWithContext.getDimension();
            HashSet<? extends Serializable> dimensionFilterSelection = this.dimensionFilterSelectionProviders.get(dimensionWithContext).getSelection();
            if (dimensionFilterSelection.isEmpty()) continue;
            HashMap<Object, HashSet<Serializable>> retrieverFilterSelection = filterSelection.get(retrieverLevel);
            if (retrieverFilterSelection == null) {
                retrieverFilterSelection = new HashMap();
                filterSelection.put(retrieverLevel, retrieverFilterSelection);
            }
            retrieverFilterSelection.put(dimension, dimensionFilterSelection);
        }
        return filterSelection;
    }

    @Override
    public void clearSelection() {
        for (DimensionFilterSelectionProvider selectionProvider : this.dimensionFilterSelectionProviders.values()) {
            selectionProvider.clearSelection();
        }
    }

    @Override
    public void addSelectionChangedListener(FilterSelectionChangedListener listener) {
        this.listeners.add(listener);
    }

    private void notifyListeners() {
        this.mainPanel.setWidgetHidden((Widget)this.filterSelectionPresenterContainer, this.getSelection().isEmpty());
        for (FilterSelectionChangedListener listener : this.listeners) {
            listener.selectionChanged();
        }
    }

    public String getLocalizedShortName() {
        return this.getClass().getSimpleName();
    }

    public Widget getEntryWidget() {
        return this.mainPanel;
    }

    public boolean isVisible() {
        return this.mainPanel.isVisible();
    }

    public void setVisible(boolean visibility) {
        this.mainPanel.setVisible(visibility);
    }

    public String getDependentCssClassName() {
        return "hierarchicalDimensionListFilterSelectionProvider";
    }

    public boolean hasSettings() {
        return false;
    }

    public SettingsDialogComponent<SerializableSettings> getSettingsDialogComponent(SerializableSettings settings) {
        return null;
    }

    public void updateSettings(SerializableSettings newSettings) {
    }

    public SerializableSettings getSettings() {
        return null;
    }

    public String getId() {
        return "HierarchicalDimensionListFilterSelectionProvider";
    }

    private class CustomCheckboxEventTranslator
    implements DefaultSelectionEventManager.EventTranslator<DimensionWithContext> {
        private CustomCheckboxEventTranslator() {
        }

        public boolean clearCurrentSelection(CellPreviewEvent<DimensionWithContext> event) {
            return false;
        }

        public DefaultSelectionEventManager.SelectAction translateSelectionEvent(CellPreviewEvent<DimensionWithContext> event) {
            DefaultSelectionEventManager.SelectAction action = DefaultSelectionEventManager.SelectAction.TOGGLE;
            NativeEvent nativeEvent = event.getNativeEvent();
            Element targetRow = Element.as((JavaScriptObject)nativeEvent.getEventTarget());
            while (!TableRowElement.is((Element)targetRow) && targetRow != null) {
                targetRow = targetRow.getParentElement();
            }
            if (targetRow != null && targetRow.hasAttribute(HierarchicalDimensionListFilterSelectionProvider.DimensionListSubheaderAttribute)) {
                action = DefaultSelectionEventManager.SelectAction.IGNORE;
            }
            return action;
        }
    }

    private static class DimensionWithContext
    implements Comparable<DimensionWithContext> {
        private final FunctionDTO dimension;
        private final DataRetrieverLevelDTO retrieverLevel;
        private Collection<String> matchingStrings;

        public DimensionWithContext(FunctionDTO dimension, DataRetrieverLevelDTO retrieverLevel) {
            this.dimension = dimension;
            this.retrieverLevel = retrieverLevel;
        }

        public FunctionDTO getDimension() {
            return this.dimension;
        }

        public DataRetrieverLevelDTO getRetrieverLevel() {
            return this.retrieverLevel;
        }

        public Collection<String> getMatchingStrings() {
            if (this.matchingStrings == null) {
                this.matchingStrings = new ArrayList<String>(2);
                this.matchingStrings.add(this.dimension.getDisplayName());
                this.matchingStrings.add(this.retrieverLevel.getRetrievedDataType().getDisplayName());
            }
            return this.matchingStrings;
        }

        @Override
        public int compareTo(DimensionWithContext o) {
            int retrieverLevelComparison = this.retrieverLevel.compareTo(o.retrieverLevel);
            if (retrieverLevelComparison != 0) {
                return retrieverLevelComparison;
            }
            return this.dimension.compareTo(o.dimension);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.dimension == null ? 0 : this.dimension.hashCode());
            result = 31 * result + (this.retrieverLevel == null ? 0 : this.retrieverLevel.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DimensionWithContext other = (DimensionWithContext)obj;
            if (this.dimension == null ? other.dimension != null : !this.dimension.equals((Object)other.dimension)) {
                return false;
            }
            return !(this.retrieverLevel == null ? other.retrieverLevel != null : !this.retrieverLevel.equals((Object)other.retrieverLevel));
        }
    }

    private class FilterDimensionsListBuilder
    extends BaseCellTableBuilder<DimensionWithContext> {
        private final String headerStyle;
        private final String subHeaderStyle;
        private final String spacedSubHeaderStyle;
        private final String subHeaderLabelStyle;
        private final String firstColumnStyle;
        private final String hoveredRowStyle;
        private final String hoveredRowCellStyle;
        private final String clearFocus;

        public FilterDimensionsListBuilder(AbstractCellTable<DimensionWithContext> cellTable, DataMiningDataGridResources.DataMiningDataGridStyle style) {
            super(cellTable);
            this.headerStyle = style.dataGridHeader();
            this.subHeaderStyle = style.dataGridSubHeader();
            this.firstColumnStyle = style.dataGridFirstColumn();
            this.spacedSubHeaderStyle = style.dataGridSpacedSubHeader();
            this.hoveredRowStyle = style.dataGridHoveredRow();
            this.hoveredRowCellStyle = style.dataGridHoveredRowCell();
            this.subHeaderLabelStyle = style.dataGridSubHeaderLabel();
            this.clearFocus = style.dataGridClearFocus();
            cellTable.addRowHoverHandler(new RowHoverEvent.Handler(){

                public void onRowHover(RowHoverEvent event) {
                    TableRowElement tr = event.getHoveringRow();
                    if (tr.hasAttribute(HierarchicalDimensionListFilterSelectionProvider.DimensionListSubheaderAttribute)) {
                        tr.removeClassName(FilterDimensionsListBuilder.this.hoveredRowStyle);
                        NodeList cells = tr.getCells();
                        int i = 0;
                        while (i < cells.getLength()) {
                            ((TableCellElement)cells.getItem(i)).removeClassName(FilterDimensionsListBuilder.this.hoveredRowCellStyle);
                            ++i;
                        }
                    }
                }
            });
        }

        public void buildRowImpl(DimensionWithContext rowValue, int absRowIndex) {
            DataRetrieverLevelDTO valueLevel = rowValue.getRetrieverLevel();
            DataRetrieverLevelDTO previousLevel = null;
            if (absRowIndex > 0) {
                previousLevel = ((DimensionWithContext)HierarchicalDimensionListFilterSelectionProvider.this.filteredFilterDimensions.getList().get(absRowIndex - 1)).getRetrieverLevel();
            }
            if (!Objects.equals(previousLevel, valueLevel)) {
                StringBuilder styleBuilder = new StringBuilder();
                styleBuilder.append(this.subHeaderStyle).append(" ").append(this.headerStyle).append(" ").append(this.clearFocus);
                if (absRowIndex != 0) {
                    styleBuilder.append(" ").append(this.spacedSubHeaderStyle);
                }
                String style = styleBuilder.toString();
                String subHeaderText = valueLevel.getRetrievedDataType().getDisplayName();
                TableRowBuilder subHeaderBuilder = (TableRowBuilder)((TableRowBuilder)this.startRow().className(this.clearFocus)).attribute(HierarchicalDimensionListFilterSelectionProvider.DimensionListSubheaderAttribute, subHeaderText);
                ((TableCellBuilder)subHeaderBuilder.startTD().className(String.valueOf(style) + " " + this.firstColumnStyle)).endTD();
                TableCellBuilder headerCellBuilder = subHeaderBuilder.startTD();
                headerCellBuilder.colSpan(this.cellTable.getColumnCount() - 1).className(style);
                ((DivBuilder)((DivBuilder)headerCellBuilder.startDiv().className(this.subHeaderLabelStyle)).text(subHeaderText)).endDiv();
                headerCellBuilder.endTD();
                subHeaderBuilder.endTR();
            }
            super.buildRowImpl((Object)rowValue, absRowIndex);
        }
    }

    private class InnerSelectionCallback
    implements Consumer<Iterable<String>> {
        private final Collection<String> allMessages;
        private final Set<InnerSelectionCallback> innerCallbacks;
        private final Consumer<Iterable<String>> outerCallback;
        private boolean canPublishMessages;

        public InnerSelectionCallback(Collection<String> allMessages, Set<InnerSelectionCallback> innerCallbacks, Consumer<Iterable<String>> outerCallback) {
            this.allMessages = allMessages;
            this.innerCallbacks = innerCallbacks;
            this.outerCallback = outerCallback;
        }

        @Override
        public void accept(Iterable<String> messages) {
            Util.addAll(messages, this.allMessages);
            this.innerCallbacks.remove(this);
            if (this.canPublishMessages && this.innerCallbacks.isEmpty()) {
                HierarchicalDimensionListFilterSelectionProvider.this.setSelectionCompleted(this.outerCallback, this.allMessages);
            }
        }
    }
}

