/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.datamining.ui.client.selection;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sse.common.settings.Settings;
import com.sap.sse.datamining.shared.dto.StatisticQueryDefinitionDTO;
import com.sap.sse.datamining.ui.client.AbstractDataMiningComponent;
import com.sap.sse.datamining.ui.client.DataMiningServiceAsync;
import com.sap.sse.datamining.ui.client.QueryDefinitionChangedListener;
import com.sap.sse.datamining.ui.client.QueryDefinitionProvider;
import com.sap.sse.datamining.ui.client.StringMessages;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.shared.components.Component;
import com.sap.sse.gwt.client.shared.settings.ComponentContext;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public abstract class AbstractQueryDefinitionProvider<SettingsType extends Settings>
extends AbstractDataMiningComponent<SettingsType>
implements QueryDefinitionProvider<SettingsType> {
    private final DataMiningServiceAsync dataMiningService;
    private final ErrorReporter errorReporter;
    private final Timer dataminingComponentsChangedTimer;
    private final int timerDelayInMillis = 30000;
    private Date componentsChangedTimepoint;
    private final DialogBox componentsChangedDialog;
    private boolean blockChangeNotification;
    private final Set<QueryDefinitionChangedListener> listeners;

    public AbstractQueryDefinitionProvider(Component<?> parent, ComponentContext<?> context, DataMiningServiceAsync dataMiningService, ErrorReporter errorReporter) {
        super(parent, context);
        this.dataMiningService = dataMiningService;
        this.errorReporter = errorReporter;
        this.dataminingComponentsChangedTimer = new Timer(){

            public void run() {
                AbstractQueryDefinitionProvider.this.getDataMiningService().getComponentsChangedTimepoint(new AsyncCallback<Date>(){

                    public void onFailure(Throwable caught) {
                        AbstractQueryDefinitionProvider.this.errorReporter.reportError(AbstractQueryDefinitionProvider.this.getDataMiningStringMessages().errorFetchingComponentsChangedTimepoint(caught.getMessage()));
                        AbstractQueryDefinitionProvider.this.dataminingComponentsChangedTimer.schedule(30000);
                    }

                    public void onSuccess(Date componentsChangedTimepoint) {
                        if (componentsChangedTimepoint.after(AbstractQueryDefinitionProvider.this.componentsChangedTimepoint)) {
                            AbstractQueryDefinitionProvider.this.componentsChangedTimepoint = componentsChangedTimepoint;
                            AbstractQueryDefinitionProvider.this.componentsChangedDialog.center();
                        }
                        AbstractQueryDefinitionProvider.this.dataminingComponentsChangedTimer.schedule(30000);
                    }
                });
            }
        };
        this.componentsChangedDialog = this.createComponentsChangedDialog();
        this.blockChangeNotification = false;
        this.listeners = new HashSet<QueryDefinitionChangedListener>();
        this.getDataMiningService().getComponentsChangedTimepoint(new AsyncCallback<Date>(){

            public void onFailure(Throwable caught) {
                AbstractQueryDefinitionProvider.this.errorReporter.reportError(AbstractQueryDefinitionProvider.this.getDataMiningStringMessages().errorFetchingComponentsChangedTimepoint(caught.getMessage()));
            }

            public void onSuccess(Date componentsChangedTimepoint) {
                AbstractQueryDefinitionProvider.this.componentsChangedTimepoint = componentsChangedTimepoint;
                AbstractQueryDefinitionProvider.this.dataminingComponentsChangedTimer.schedule(30000);
            }
        });
    }

    private DialogBox createComponentsChangedDialog() {
        DialogBox componentsChangedDialog = new DialogBox(false, true);
        componentsChangedDialog.setAnimationEnabled(true);
        componentsChangedDialog.setText(this.getDataMiningStringMessages().dataMiningComponentsHaveBeenUpdated());
        VerticalPanel contentPanel = new VerticalPanel();
        contentPanel.setSpacing(5);
        contentPanel.add((Widget)new HTML(new SafeHtmlBuilder().appendEscapedLines(this.getDataMiningStringMessages().dataMiningComponentsNeedReloadDialogMessage()).toSafeHtml()));
        FlowPanel buttonPanel = new FlowPanel();
        buttonPanel.addStyleName("floatRight");
        contentPanel.add((Widget)buttonPanel);
        Button reloadButton = new Button(this.getDataMiningStringMessages().reload());
        reloadButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                AbstractQueryDefinitionProvider.this.componentsChangedDialog.hide();
                AbstractQueryDefinitionProvider.this.reloadComponents();
            }
        });
        reloadButton.addStyleName("dataMiningMarginLeft");
        buttonPanel.add((Widget)reloadButton);
        Button closeButton = new Button(this.getDataMiningStringMessages().close());
        closeButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                AbstractQueryDefinitionProvider.this.componentsChangedDialog.hide();
            }
        });
        closeButton.addStyleName("dataMiningMarginLeft");
        buttonPanel.add((Widget)closeButton);
        componentsChangedDialog.setWidget((Widget)contentPanel);
        return componentsChangedDialog;
    }

    @Override
    public Iterable<String> validateQueryDefinition(StatisticQueryDefinitionDTO queryDefinition) {
        ArrayList<String> errorMessages = new ArrayList<String>();
        if (queryDefinition != null) {
            StringMessages stringMessages = this.getDataMiningStringMessages();
            if (queryDefinition.getStatisticToCalculate() == null || queryDefinition.getDataRetrieverChainDefinition() == null) {
                errorMessages.add(stringMessages.noStatisticSelectedError());
            } else {
                if (queryDefinition.getAggregatorDefinition() == null) {
                    errorMessages.add(stringMessages.noAggregatorSelectedError());
                }
                if (queryDefinition.getDimensionsToGroupBy().isEmpty()) {
                    errorMessages.add(stringMessages.noDimensionToGroupBySelectedError());
                }
            }
        }
        return errorMessages;
    }

    @Override
    public void addQueryDefinitionChangedListener(QueryDefinitionChangedListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeQueryDefinitionChangedListener(QueryDefinitionChangedListener listener) {
        this.listeners.remove(listener);
    }

    protected void setBlockChangeNotification(boolean block) {
        this.blockChangeNotification = block;
    }

    protected void notifyQueryDefinitionChanged() {
        if (!this.blockChangeNotification) {
            StatisticQueryDefinitionDTO queryDefinition = this.getQueryDefinition();
            for (QueryDefinitionChangedListener listener : this.listeners) {
                listener.queryDefinitionChanged(queryDefinition);
            }
        }
    }

    protected DataMiningServiceAsync getDataMiningService() {
        return this.dataMiningService;
    }

    protected ErrorReporter getErrorReporter() {
        return this.errorReporter;
    }
}

