/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.datamining.ui.client.presentation.dataproviders;

import com.sap.sse.common.Speed;
import com.sap.sse.datamining.shared.impl.dto.QueryResultDTO;
import com.sap.sse.datamining.ui.client.StringMessages;
import com.sap.sse.datamining.ui.client.presentation.dataproviders.AbstractNumericDataProviderWithStaticMappings;
import java.util.LinkedHashMap;
import java.util.function.Function;

public class SpeedDataProvider
extends AbstractNumericDataProviderWithStaticMappings<Speed> {
    private static final String BEAUFORT = "Beaufort";
    private static final String KILOMETERS_PER_HOUR = "KilometersPerHour";
    private static final String KNOTS = "Knots";
    private static final String METERS_PER_SECOND = "MetersPerSecond";
    private static final String STATUTE_MILES_PER_HOUR = "StatuteMilesPerHour";

    public SpeedDataProvider() {
        super(Speed.class, SpeedDataProvider.getMappings());
    }

    private static LinkedHashMap<String, Function<Speed, Number>> getMappings() {
        LinkedHashMap<String, Function<Speed, Number>> mappings = new LinkedHashMap<String, Function<Speed, Number>>();
        mappings.put(BEAUFORT, speed -> speed.getBeaufort());
        mappings.put(KILOMETERS_PER_HOUR, speed -> speed.getKilometersPerHour());
        mappings.put(KNOTS, speed -> speed.getKnots());
        mappings.put(METERS_PER_SECOND, speed -> speed.getMetersPerSecond());
        mappings.put(STATUTE_MILES_PER_HOUR, speed -> speed.getStatuteMilesPerHour());
        return mappings;
    }

    @Override
    public String getDefaultDataKeyFor(QueryResultDTO<?> result) {
        return KNOTS;
    }

    @Override
    public String getLocalizedNameForDataKey(QueryResultDTO<?> result, StringMessages stringMessages, String dataKey) {
        switch (dataKey) {
            case "Beaufort": {
                return stringMessages.beaufort();
            }
            case "KilometersPerHour": {
                return stringMessages.kilometersPerHour();
            }
            case "Knots": {
                return stringMessages.knots();
            }
            case "MetersPerSecond": {
                return stringMessages.metersPerSecond();
            }
            case "StatuteMilesPerHour": {
                return stringMessages.statuteMilesPerHour();
            }
        }
        throw new IllegalArgumentException("The given data key '" + dataKey + "' isn't valid");
    }
}

