/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.datamining.ui.client.presentation.dataproviders;

import com.sap.sse.common.Util;
import com.sap.sse.datamining.shared.GroupKey;
import com.sap.sse.datamining.shared.impl.dto.QueryResultDTO;
import com.sap.sse.datamining.ui.client.StringMessages;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public abstract class AbstractNumericDataProvider<T extends Serializable> {
    private final Class<T> resultType;

    protected AbstractNumericDataProvider(Class<T> resultType) {
        this.resultType = resultType;
    }

    public Class<T> getResultType() {
        return this.resultType;
    }

    public abstract Collection<String> getDataKeys(QueryResultDTO<?> var1);

    public abstract boolean isValidDataKey(QueryResultDTO<?> var1, String var2);

    public abstract String getDefaultDataKeyFor(QueryResultDTO<?> var1);

    public abstract String getLocalizedNameForDataKey(QueryResultDTO<?> var1, StringMessages var2, String var3);

    protected abstract Function<T, Number> getMapping(QueryResultDTO<?> var1, String var2);

    public Map<GroupKey, Number> getData(QueryResultDTO<?> result, String dataKey) {
        if (!this.acceptsResultsOfType(result.getResultType())) {
            throw new IllegalArgumentException("This data provider doesn't work for results of the type '" + result.getResultType() + "'");
        }
        Function<Serializable, Number> mapping = this.getMapping(result, dataKey);
        if (mapping == null) {
            throw new IllegalArgumentException("The given data key '" + dataKey + "' isn't valid");
        }
        HashMap<GroupKey, Number> data = new HashMap<GroupKey, Number>();
        Map results = result.getResults();
        for (GroupKey groupKey : results.keySet()) {
            Serializable value = (Serializable)results.get(groupKey);
            data.put(groupKey, mapping.apply(value));
        }
        return data;
    }

    public Map<GroupKey, Util.Triple<Number, Number, Long>> getErrorData(QueryResultDTO<?> result, String dataKey) {
        return null;
    }

    public boolean acceptsResultsOfType(String type) {
        return this.getResultType().getName().equals(type);
    }
}

