/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.datamining.ui.client.presentation;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.text.shared.Renderer;
import com.google.gwt.user.client.ui.DeckLayoutPanel;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ValueListBox;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sse.common.settings.Settings;
import com.sap.sse.datamining.shared.dto.StatisticQueryDefinitionDTO;
import com.sap.sse.datamining.shared.impl.dto.QueryResultDTO;
import com.sap.sse.datamining.ui.client.AbstractDataMiningComponent;
import com.sap.sse.datamining.ui.client.ResultsPresenter;
import com.sap.sse.datamining.ui.client.presentation.AbstractNumericResultsPresenter;
import com.sap.sse.datamining.ui.client.presentation.AbstractResultsPresenter;
import com.sap.sse.datamining.ui.client.presentation.PlainResultsPresenter;
import com.sap.sse.datamining.ui.client.presentation.ResultsChart;
import com.sap.sse.gwt.client.shared.components.Component;
import com.sap.sse.gwt.client.shared.components.SettingsDialogComponent;
import com.sap.sse.gwt.client.shared.controls.AbstractObjectRenderer;
import com.sap.sse.gwt.client.shared.settings.ComponentContext;
import java.util.ArrayList;
import java.util.List;

public class MultiResultsPresenter
extends AbstractDataMiningComponent<Settings>
implements ResultsPresenter<Settings> {
    private final DeckLayoutPanel presenterPanel;
    private final HorizontalPanel controlsPanel;
    private final ValueListBox<PresenterDescriptor<Object>> presentersListBox;
    private AbstractResultsPresenter<?> currentPresenter;
    private List<PresenterDescriptor<Object>> availablePresenters = new ArrayList<PresenterDescriptor<Object>>();

    public MultiResultsPresenter(Component<?> parent, ComponentContext<?> context, ResultsChart.DrillDownCallback drillDownCallback) {
        super(parent, context);
        this.availablePresenters.add(new ColumnChartDescriptor(drillDownCallback));
        this.availablePresenters.add(new ColumnChartDescriptorWithErrorBars(drillDownCallback));
        this.availablePresenters.add(new PlainDescriptor());
        this.presenterPanel = new DeckLayoutPanel();
        this.controlsPanel = new HorizontalPanel();
        this.controlsPanel.setSpacing(5);
        this.controlsPanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
        this.controlsPanel.add((Widget)new Label(String.valueOf(this.getDataMiningStringMessages().choosePresentation()) + ":"));
        this.presentersListBox = new ValueListBox((Renderer)new AbstractObjectRenderer<PresenterDescriptor<? extends Object>>(){

            protected String convertObjectToString(PresenterDescriptor<? extends Object> nonNullObject) {
                return nonNullObject.getName();
            }
        });
        this.presentersListBox.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<PresenterDescriptor<Object>>(){

            public void onValueChange(ValueChangeEvent<PresenterDescriptor<Object>> event) {
                MultiResultsPresenter.this.setCurrentPresenter(((PresenterDescriptor)event.getValue()).getPresenter());
            }
        });
        this.controlsPanel.add(this.presentersListBox);
        this.presentersListBox.setValue(this.availablePresenters.get(0), false);
        this.presentersListBox.setAcceptableValues(this.availablePresenters);
        this.setCurrentPresenter(this.availablePresenters.get(0).getPresenter());
    }

    private void setCurrentPresenter(AbstractResultsPresenter<?> presenter) {
        this.controlsPanel.removeFromParent();
        presenter.addControl((Widget)this.controlsPanel);
        if (presenter instanceof AbstractNumericResultsPresenter && this.currentPresenter instanceof AbstractNumericResultsPresenter) {
            String dataKey = ((AbstractNumericResultsPresenter)this.currentPresenter).getSelectedDataKey();
            ((AbstractNumericResultsPresenter)presenter).setSelectedDataKey(dataKey);
        }
        this.currentPresenter = presenter;
        this.presenterPanel.setWidget((IsWidget)this.currentPresenter.getEntryWidget());
        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                MultiResultsPresenter.this.presenterPanel.onResize();
            }
        });
    }

    @Override
    public QueryResultDTO<?> getCurrentResult() {
        return this.currentPresenter.getCurrentResult();
    }

    @Override
    public StatisticQueryDefinitionDTO getCurrentQueryDefinition() {
        return this.currentPresenter.getCurrentQueryDefinition();
    }

    @Override
    public void showResult(StatisticQueryDefinitionDTO queryDefinition, QueryResultDTO<?> result) {
        for (PresenterDescriptor<Object> descriptor : this.availablePresenters) {
            descriptor.getPresenter().showResult(queryDefinition, result);
        }
    }

    @Override
    public void showError(StatisticQueryDefinitionDTO queryDefinition, String error) {
        for (PresenterDescriptor<Object> descriptor : this.availablePresenters) {
            descriptor.getPresenter().showError(queryDefinition, error);
        }
    }

    @Override
    public void showError(String mainError, Iterable<String> detailedErrors, StatisticQueryDefinitionDTO queryDefinition) {
        for (PresenterDescriptor<Object> descriptor : this.availablePresenters) {
            descriptor.getPresenter().showError(mainError, detailedErrors, queryDefinition);
        }
    }

    @Override
    public void showBusyIndicator() {
        for (PresenterDescriptor<Object> descriptor : this.availablePresenters) {
            descriptor.getPresenter().showBusyIndicator();
        }
    }

    public String getLocalizedShortName() {
        return this.getDataMiningStringMessages().multiResultsPresenter();
    }

    public Widget getEntryWidget() {
        return this.presenterPanel;
    }

    public boolean isVisible() {
        return this.presenterPanel.isVisible();
    }

    public void setVisible(boolean visibility) {
        this.presenterPanel.setVisible(visibility);
    }

    public boolean hasSettings() {
        return false;
    }

    public SettingsDialogComponent<Settings> getSettingsDialogComponent(Settings settings) {
        return null;
    }

    public void updateSettings(Settings newSettings) {
    }

    public Settings getSettings() {
        return null;
    }

    public String getDependentCssClassName() {
        return "multiResultsPresenter";
    }

    public String getId() {
        return "MultiResultsPresenter";
    }

    private abstract class AbstractColumnChartDescriptor
    implements PresenterDescriptor<Object> {
        private final ResultsChart presenter;
        private final String name;

        public AbstractColumnChartDescriptor(String name, boolean showErrorBars, ResultsChart.DrillDownCallback drillDownCallback) {
            this.name = name;
            this.presenter = new ResultsChart(MultiResultsPresenter.this, MultiResultsPresenter.this.getComponentContext(), showErrorBars, drillDownCallback);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public AbstractResultsPresenter<?> getPresenter() {
            return this.presenter;
        }
    }

    private class ColumnChartDescriptor
    extends AbstractColumnChartDescriptor {
        public ColumnChartDescriptor(ResultsChart.DrillDownCallback drillDownCallback) {
            super(MultiResultsPresenter.this.getDataMiningStringMessages().columnChart(), false, drillDownCallback);
        }
    }

    private class ColumnChartDescriptorWithErrorBars
    extends AbstractColumnChartDescriptor {
        public ColumnChartDescriptorWithErrorBars(ResultsChart.DrillDownCallback drillDownCallback) {
            super(MultiResultsPresenter.this.getDataMiningStringMessages().columnChartWithErrorBars(), true, drillDownCallback);
        }
    }

    private class PlainDescriptor
    implements PresenterDescriptor<Object> {
        private final AbstractResultsPresenter<?> presenter;

        public PlainDescriptor() {
            this.presenter = new PlainResultsPresenter(MultiResultsPresenter.this, MultiResultsPresenter.this.getComponentContext());
        }

        @Override
        public String getName() {
            return MultiResultsPresenter.this.getDataMiningStringMessages().plainText();
        }

        @Override
        public AbstractResultsPresenter<?> getPresenter() {
            return this.presenter;
        }
    }

    private static interface PresenterDescriptor<ResultType> {
        public String getName();

        public AbstractResultsPresenter<?> getPresenter();
    }
}

