/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.datamining.ui.client.presentation;

import com.google.gwt.dom.client.Style;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import com.google.gwt.user.client.ui.DeckLayoutPanel;
import com.google.gwt.user.client.ui.DockLayoutPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sse.common.settings.Settings;
import com.sap.sse.datamining.shared.GroupKey;
import com.sap.sse.datamining.shared.dto.StatisticQueryDefinitionDTO;
import com.sap.sse.datamining.shared.impl.dto.QueryResultDTO;
import com.sap.sse.datamining.ui.client.AbstractDataMiningComponent;
import com.sap.sse.datamining.ui.client.ResultsPresenter;
import com.sap.sse.datamining.ui.client.WithControls;
import com.sap.sse.gwt.client.shared.components.Component;
import com.sap.sse.gwt.client.shared.settings.ComponentContext;

public abstract class AbstractResultsPresenter<SettingsType extends Settings>
extends AbstractDataMiningComponent<SettingsType>
implements ResultsPresenter<SettingsType>,
WithControls {
    private ResultsPresenterState state;
    private final DockLayoutPanel mainPanel = new DockLayoutPanel(Style.Unit.PX);
    private final HorizontalPanel controlsPanel = new HorizontalPanel();
    protected final DeckLayoutPanel presentationPanel;
    private final HTML errorLabel;
    private final HTML labeledBusyIndicator;
    private StatisticQueryDefinitionDTO currentQueryDefinition;
    private QueryResultDTO<?> currentResult;
    private boolean isCurrentResultSimple;

    public AbstractResultsPresenter(Component<?> parent, ComponentContext<?> context) {
        super(parent, context);
        this.controlsPanel.setSpacing(5);
        this.controlsPanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
        this.mainPanel.addNorth((Widget)this.controlsPanel, 40.0);
        this.presentationPanel = new DeckLayoutPanel();
        this.mainPanel.add((Widget)this.presentationPanel);
        this.errorLabel = new HTML();
        this.errorLabel.setStyleName("chart-importantMessage");
        this.labeledBusyIndicator = new HTML(this.getDataMiningStringMessages().runningQuery());
        this.labeledBusyIndicator.setStyleName("chart-busyMessage");
        this.showError(null, this.getDataMiningStringMessages().runAQuery());
    }

    @Override
    public void addControl(Widget controlWidget) {
        this.controlsPanel.add(controlWidget);
    }

    @Override
    public void removeControl(Widget controlWidget) {
        this.controlsPanel.remove(controlWidget);
    }

    @Override
    public void showResult(StatisticQueryDefinitionDTO queryDefinition, QueryResultDTO<?> result) {
        if (result != null && !result.isEmpty()) {
            this.getPresentationWidget().removeFromParent();
            this.currentResult = result;
            this.currentQueryDefinition = queryDefinition;
            this.updateCurrentResultInfo();
            this.internalShowResults(queryDefinition, this.getCurrentResult());
            if (this.state != ResultsPresenterState.RESULT) {
                this.mainPanel.setWidgetHidden((Widget)this.controlsPanel, this.controlsPanel.getWidgetCount() == 0);
                this.presentationPanel.setWidget((IsWidget)this.getPresentationWidget());
                this.state = ResultsPresenterState.RESULT;
            }
        } else {
            this.showError(queryDefinition, String.valueOf(this.getDataMiningStringMessages().noDataFound()) + ".");
        }
    }

    protected abstract void internalShowResults(StatisticQueryDefinitionDTO var1, QueryResultDTO<?> var2);

    protected abstract Widget getPresentationWidget();

    @Override
    public void showError(StatisticQueryDefinitionDTO queryDefinition, String error) {
        this.showError(queryDefinition, SafeHtmlUtils.fromString((String)error));
    }

    @Override
    public void showError(String mainError, Iterable<String> detailedErrors, StatisticQueryDefinitionDTO queryDefinition) {
        StringBuilder errorBuilder = new StringBuilder(String.valueOf(mainError) + ":<br /><ul>");
        for (String detailedError : detailedErrors) {
            errorBuilder.append("<li>" + detailedError + "</li>");
        }
        errorBuilder.append("</ul>");
        this.showError(queryDefinition, SafeHtmlUtils.fromTrustedString((String)errorBuilder.toString()));
    }

    private void showError(StatisticQueryDefinitionDTO queryDefinition, SafeHtml error) {
        if (this.state != ResultsPresenterState.ERROR) {
            this.mainPanel.setWidgetHidden((Widget)this.controlsPanel, true);
            this.presentationPanel.setWidget((IsWidget)this.errorLabel);
            this.state = ResultsPresenterState.ERROR;
        }
        this.errorLabel.setHTML(error);
        this.currentResult = null;
        this.currentQueryDefinition = queryDefinition;
        this.updateCurrentResultInfo();
    }

    @Override
    public void showBusyIndicator() {
        if (this.state != ResultsPresenterState.BUSY) {
            this.mainPanel.setWidgetHidden((Widget)this.controlsPanel, true);
            this.presentationPanel.setWidget((IsWidget)this.labeledBusyIndicator);
            this.state = ResultsPresenterState.BUSY;
        }
        this.currentResult = null;
        this.updateCurrentResultInfo();
    }

    private void updateCurrentResultInfo() {
        boolean isSimple = false;
        if (this.currentResult != null) {
            isSimple = true;
            for (GroupKey groupKey : this.getCurrentResult().getResults().keySet()) {
                int size = groupKey.size();
                if (size == 1) continue;
                isSimple = false;
                break;
            }
        }
        this.isCurrentResultSimple = isSimple;
    }

    protected boolean isCurrentResultSimple() {
        return this.isCurrentResultSimple;
    }

    @Override
    public QueryResultDTO<?> getCurrentResult() {
        return this.currentResult;
    }

    @Override
    public StatisticQueryDefinitionDTO getCurrentQueryDefinition() {
        return this.currentQueryDefinition;
    }

    public Widget getEntryWidget() {
        return this.mainPanel;
    }

    public boolean isVisible() {
        return this.mainPanel.isVisible();
    }

    public void setVisible(boolean visibility) {
        this.mainPanel.setVisible(visibility);
    }

    private static enum ResultsPresenterState {
        BUSY,
        ERROR,
        RESULT;

    }
}

