/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.igtimiadapter.websocket;

import com.sap.sailing.domain.igtimiadapter.IgtimiConnection;
import com.sap.sailing.domain.igtimiadapter.LiveDataConnection;
import com.sap.sailing.domain.igtimiadapter.websocket.LiveDataConnectionFactory;
import com.sap.sailing.domain.igtimiadapter.websocket.LiveDataConnectionWrapper;
import com.sap.sailing.domain.igtimiadapter.websocket.WebSocketConnectionManager;
import com.sap.sse.common.Util;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class LiveDataConnectionFactoryImpl
implements LiveDataConnectionFactory {
    private static final Logger logger = Logger.getLogger(LiveDataConnectionFactoryImpl.class.getName());
    private final IgtimiConnection connection;
    private final Map<Set<String>, LiveDataConnection> dataConnectionsForDeviceSerialNumbers;
    private final Map<LiveDataConnection, Set<String>> deviceSerialNumersForDataConnections;
    private final Map<LiveDataConnection, Integer> usageCounts;

    public LiveDataConnectionFactoryImpl(IgtimiConnection connection) {
        this.connection = connection;
        this.dataConnectionsForDeviceSerialNumbers = new HashMap<Set<String>, LiveDataConnection>();
        this.deviceSerialNumersForDataConnections = new HashMap<LiveDataConnection, Set<String>>();
        this.usageCounts = new HashMap<LiveDataConnection, Integer>();
    }

    @Override
    public synchronized LiveDataConnection getOrCreateLiveDataConnection(Iterable<String> deviceSerialNumbers) throws Exception {
        LiveDataConnectionWrapper finalResult;
        if (deviceSerialNumbers == null || Util.isEmpty(deviceSerialNumbers)) {
            logger.info("Not creating a live Igtimi data connection for an empty set of device serial numbers through connection " + this.connection);
            finalResult = null;
        } else {
            HashSet deviceSerialNumbersAsSet = new HashSet();
            Util.addAll(deviceSerialNumbers, deviceSerialNumbersAsSet);
            LiveDataConnection result = this.dataConnectionsForDeviceSerialNumbers.get(deviceSerialNumbersAsSet);
            if (result == null) {
                logger.info("Didn't find an existing Igtimi LiveDataConnection for devices " + deviceSerialNumbersAsSet + "; creating one...");
                result = new WebSocketConnectionManager(this.connection, deviceSerialNumbers);
                this.dataConnectionsForDeviceSerialNumbers.put(deviceSerialNumbersAsSet, result);
                this.deviceSerialNumersForDataConnections.put(result, deviceSerialNumbersAsSet);
            } else {
                logger.info("Found an existing Igtimi LiveDataConnection for devices " + deviceSerialNumbersAsSet + "; using it.");
            }
            Integer usageCount = this.usageCounts.get(result);
            if (usageCount == null) {
                usageCount = 0;
            }
            usageCount = usageCount + 1;
            this.usageCounts.put(result, usageCount);
            finalResult = new LiveDataConnectionWrapper(this, result);
        }
        return finalResult;
    }

    public synchronized void stop(LiveDataConnection actualConnection) throws Exception {
        Integer usageCount = this.usageCounts.get(actualConnection);
        if (usageCount == null || usageCount == 0) {
            logger.warning("Strange: the Igtimi live data connection " + actualConnection + " is released by another client although no client should be using it anymore.");
        } else if ((usageCount = Integer.valueOf(usageCount - 1)) == 0) {
            this.usageCounts.remove(actualConnection);
            Set<String> deviceSerialNumbersAsSet = this.deviceSerialNumersForDataConnections.remove(actualConnection);
            this.dataConnectionsForDeviceSerialNumbers.remove(deviceSerialNumbersAsSet);
            actualConnection.stop();
        } else {
            this.usageCounts.put(actualConnection, usageCount);
        }
    }
}

