/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.igtimiadapter.shared;

import com.sap.sailing.declination.Declination;
import com.sap.sailing.declination.DeclinationService;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.common.impl.KnotSpeedWithBearingImpl;
import com.sap.sailing.domain.common.impl.WindImpl;
import com.sap.sailing.domain.common.scalablevalue.impl.ScalableBearing;
import com.sap.sailing.domain.common.scalablevalue.impl.ScalablePosition;
import com.sap.sailing.domain.common.scalablevalue.impl.ScalableSpeed;
import com.sap.sailing.domain.igtimiadapter.BulkFixReceiver;
import com.sap.sailing.domain.igtimiadapter.IgtimiFixReceiverAdapter;
import com.sap.sailing.domain.igtimiadapter.IgtimiWindListener;
import com.sap.sailing.domain.igtimiadapter.datatypes.AWA;
import com.sap.sailing.domain.igtimiadapter.datatypes.AWS;
import com.sap.sailing.domain.igtimiadapter.datatypes.BatteryLevel;
import com.sap.sailing.domain.igtimiadapter.datatypes.COG;
import com.sap.sailing.domain.igtimiadapter.datatypes.Fix;
import com.sap.sailing.domain.igtimiadapter.datatypes.GpsLatLong;
import com.sap.sailing.domain.igtimiadapter.datatypes.HDG;
import com.sap.sailing.domain.igtimiadapter.datatypes.HDGM;
import com.sap.sailing.domain.igtimiadapter.datatypes.SOG;
import com.sap.sailing.domain.igtimiadapter.datatypes.Type;
import com.sap.sailing.domain.tracking.DynamicTrackWithRemove;
import com.sap.sailing.domain.tracking.impl.DynamicTrackWithRemoveImpl;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Speed;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Timed;
import com.sap.sse.common.Util;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IgtimiWindReceiver
implements BulkFixReceiver {
    private static final Logger logger = Logger.getLogger(IgtimiWindReceiver.class.getName());
    private final ConcurrentMap<String, DynamicTrackWithRemove<AWA>> awaTracks;
    private final ConcurrentMap<String, DynamicTrackWithRemove<AWS>> awsTracks;
    private final ConcurrentMap<String, DynamicTrackWithRemove<GpsLatLong>> gpsTracks;
    private final ConcurrentMap<String, DynamicTrackWithRemove<COG>> cogTracks;
    private final ConcurrentMap<String, DynamicTrackWithRemove<SOG>> sogTracks;
    private final ConcurrentMap<String, DynamicTrackWithRemove<HDG>> hdgTracks;
    private final ConcurrentMap<String, DynamicTrackWithRemove<HDGM>> hdgmTracks;
    private final ConcurrentMap<String, DynamicTrackWithRemove<BatteryLevel>> batteryLevelTracks;
    private final FixReceiver receiver = new FixReceiver();
    private final DeclinationService declinationService;
    private final ConcurrentMap<IgtimiWindListener, IgtimiWindListener> listeners;

    public IgtimiWindReceiver(DeclinationService declinationService) {
        this.declinationService = declinationService;
        this.listeners = new ConcurrentHashMap<IgtimiWindListener, IgtimiWindListener>();
        this.awaTracks = new ConcurrentHashMap<String, DynamicTrackWithRemove<AWA>>();
        this.awsTracks = new ConcurrentHashMap<String, DynamicTrackWithRemove<AWS>>();
        this.gpsTracks = new ConcurrentHashMap<String, DynamicTrackWithRemove<GpsLatLong>>();
        this.cogTracks = new ConcurrentHashMap<String, DynamicTrackWithRemove<COG>>();
        this.sogTracks = new ConcurrentHashMap<String, DynamicTrackWithRemove<SOG>>();
        this.hdgTracks = new ConcurrentHashMap<String, DynamicTrackWithRemove<HDG>>();
        this.hdgmTracks = new ConcurrentHashMap<String, DynamicTrackWithRemove<HDGM>>();
        this.batteryLevelTracks = new ConcurrentHashMap<String, DynamicTrackWithRemove<BatteryLevel>>();
    }

    private <T extends Fix> DynamicTrackWithRemove<T> getTrack(String deviceSerialNumber, Map<String, DynamicTrackWithRemove<T>> tracksByDeviceSerialNumber) {
        DynamicTrackWithRemoveImpl result = tracksByDeviceSerialNumber.get(deviceSerialNumber);
        if (result == null) {
            result = new DynamicTrackWithRemoveImpl("Track for Igtimi wind track for device " + deviceSerialNumber);
            tracksByDeviceSerialNumber.put(deviceSerialNumber, (DynamicTrackWithRemove<T>)result);
        }
        return result;
    }

    @Override
    public void received(Iterable<Fix> fixes) {
        final ArrayList awsFixes = new ArrayList();
        for (Fix fix : fixes) {
            fix.notify(this.receiver);
            fix.notify(new IgtimiFixReceiverAdapter(){

                @Override
                public void received(AWS fix) {
                    awsFixes.add(fix);
                }
            });
        }
        logger.finest("Received " + Util.size(awsFixes) + " wind fixes");
        boolean loggedWindFixGenerationProblem = false;
        for (AWS aws : awsFixes) {
            try {
                Util.Pair<Wind, Set<Fix>> windAndFixesUsed = this.getWind(aws.getTimePoint(), aws.getSensor().getDeviceSerialNumber());
                if (windAndFixesUsed.getA() != null) {
                    this.notifyListeners((Wind)windAndFixesUsed.getA(), (Set)windAndFixesUsed.getB(), aws.getSensor().getDeviceSerialNumber());
                    continue;
                }
                if (loggedWindFixGenerationProblem) continue;
                logger.info("Not enough information to build a Wind fix out of data provided by sensor " + aws.getSensor() + ". AWS received but most probably HDG or HDGM not received (yet) - check your compass.");
                loggedWindFixGenerationProblem = true;
            }
            catch (IOException | ClassNotFoundException | ParseException e) {
                logger.log(Level.INFO, "Exception while trying to construct Wind fix from Igtimi fix " + aws, e);
            }
        }
    }

    public void addListener(IgtimiWindListener listener) {
        this.listeners.put(listener, listener);
    }

    private void notifyListeners(Wind wind, Set<Fix> fixesUsed, String deviceSerialNumber) {
        for (IgtimiWindListener listener : this.listeners.keySet()) {
            listener.windDataReceived(wind, fixesUsed, deviceSerialNumber);
        }
    }

    private Util.Pair<Wind, Set<Fix>> getWind(TimePoint timePoint, String deviceSerialNumber) throws ClassNotFoundException, IOException, ParseException {
        WindImpl result;
        HashSet<Fix> fixesUsed = new HashSet<Fix>();
        DynamicTrackWithRemove<BatteryLevel> batteryLevelTrack = this.getBatteryLevelTrack(deviceSerialNumber);
        this.addFixUsedIfNotNull(batteryLevelTrack, timePoint, fixesUsed);
        DynamicTrackWithRemove<AWA> awaTrack = this.getAwaTrack(deviceSerialNumber);
        Bearing awaFrom = (Bearing)awaTrack.getInterpolatedValue(timePoint, a -> new ScalableBearing(a.getApparentWindAngle()));
        this.addFixUsedIfNotNull(awaTrack, timePoint, fixesUsed);
        Bearing awa = awaFrom == null ? null : awaFrom.reverse();
        DynamicTrackWithRemove<AWS> awsTrack = this.getAwsTrack(deviceSerialNumber);
        Speed aws = (Speed)awsTrack.getInterpolatedValue(timePoint, a -> new ScalableSpeed(a.getApparentWindSpeed()));
        this.addFixUsedIfNotNull(awsTrack, timePoint, fixesUsed);
        DynamicTrackWithRemove<GpsLatLong> gpsTrack = this.getGpsTrack(deviceSerialNumber);
        Position pos = (Position)gpsTrack.getInterpolatedValue(timePoint, g -> new ScalablePosition(g.getPosition()));
        this.addFixUsedIfNotNull(gpsTrack, timePoint, fixesUsed);
        if (pos != null) {
            Bearing heading = this.getHeading(timePoint, deviceSerialNumber, pos, fixesUsed);
            if (awa != null && aws != null && heading != null) {
                Bearing apparentWindDirection = heading.add(awa);
                KnotSpeedWithBearingImpl apparentWindSpeedWithDirection = new KnotSpeedWithBearingImpl(aws.getKnots(), apparentWindDirection);
                DynamicTrackWithRemove<SOG> sogTrack = this.getSogTrack(deviceSerialNumber);
                Speed sog = (Speed)sogTrack.getInterpolatedValue(timePoint, s -> new ScalableSpeed(s.getSpeedOverGround()));
                this.addFixUsedIfNotNull(sogTrack, timePoint, fixesUsed);
                DynamicTrackWithRemove<COG> cogTrack = this.getCogTrack(deviceSerialNumber);
                Bearing cog = (Bearing)cogTrack.getInterpolatedValue(timePoint, c -> new ScalableBearing(c.getCourseOverGround()));
                this.addFixUsedIfNotNull(cogTrack, timePoint, fixesUsed);
                if (sog != null && cog != null) {
                    KnotSpeedWithBearingImpl sogCog = new KnotSpeedWithBearingImpl(sog.getKnots(), cog);
                    SpeedWithBearing trueWindSpeedAndDirection = apparentWindSpeedWithDirection.add((SpeedWithBearing)sogCog);
                    result = new WindImpl(pos, timePoint, trueWindSpeedAndDirection);
                } else {
                    result = null;
                }
            } else {
                result = null;
            }
        } else {
            result = null;
        }
        return new Util.Pair(result, fixesUsed);
    }

    private <FixType extends Fix> void addFixUsedIfNotNull(DynamicTrackWithRemove<FixType> trackToCleanUp, TimePoint timePoint, Set<Fix> fixesUsed) {
        Fix fix = (Fix)trackToCleanUp.getLastFixAtOrBefore(timePoint);
        if (fix != null) {
            fixesUsed.add(fix);
            trackToCleanUp.removeAllUpToExcluding((Timed)fix);
        }
    }

    private Bearing getHeading(TimePoint timePoint, String deviceSerialNumber, Position position, Set<Fix> fixesUsed) throws ClassNotFoundException, IOException, ParseException {
        Bearing trueHeading;
        DynamicTrackWithRemove<HDG> hdgTrack = this.getHdgTrack(deviceSerialNumber);
        DynamicTrackWithRemove<HDGM> hdgmTrack = this.getHdgmTrack(deviceSerialNumber);
        Bearing hdg = (Bearing)hdgTrack.getInterpolatedValue(timePoint, h -> new ScalableBearing(h.getTrueHeading()));
        if (hdg != null) {
            trueHeading = hdg;
        } else {
            Bearing hdgm = (Bearing)hdgmTrack.getInterpolatedValue(timePoint, h -> new ScalableBearing(h.getMagneticHeading()));
            if (hdgm != null) {
                if (this.declinationService == null) {
                    trueHeading = hdgm;
                } else {
                    try {
                        Declination declination = this.declinationService.getDeclination(timePoint, position, 5000L);
                        trueHeading = hdgm.add(declination.getBearingCorrectedTo(timePoint));
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "Correction of declination was requested but unsuccessful. Can't correct heading " + hdgm + "@" + timePoint + " by declination. Forwarding exception.");
                        throw e;
                    }
                }
            } else {
                trueHeading = null;
            }
        }
        this.addFixUsedIfNotNull(hdgTrack, timePoint, fixesUsed);
        this.addFixUsedIfNotNull(hdgmTrack, timePoint, fixesUsed);
        return trueHeading;
    }

    private DynamicTrackWithRemove<AWA> getAwaTrack(String deviceSerialNumber) {
        return this.getTrack(deviceSerialNumber, this.awaTracks);
    }

    private DynamicTrackWithRemove<AWS> getAwsTrack(String deviceSerialNumber) {
        return this.getTrack(deviceSerialNumber, this.awsTracks);
    }

    private DynamicTrackWithRemove<GpsLatLong> getGpsTrack(String deviceSerialNumber) {
        return this.getTrack(deviceSerialNumber, this.gpsTracks);
    }

    private DynamicTrackWithRemove<COG> getCogTrack(String deviceSerialNumber) {
        return this.getTrack(deviceSerialNumber, this.cogTracks);
    }

    private DynamicTrackWithRemove<SOG> getSogTrack(String deviceSerialNumber) {
        return this.getTrack(deviceSerialNumber, this.sogTracks);
    }

    private DynamicTrackWithRemove<HDG> getHdgTrack(String deviceSerialNumber) {
        return this.getTrack(deviceSerialNumber, this.hdgTracks);
    }

    private DynamicTrackWithRemove<HDGM> getHdgmTrack(String deviceSerialNumber) {
        return this.getTrack(deviceSerialNumber, this.hdgmTracks);
    }

    private DynamicTrackWithRemove<BatteryLevel> getBatteryLevelTrack(String deviceSerialNumber) {
        return this.getTrack(deviceSerialNumber, this.batteryLevelTracks);
    }

    public Type[] getFixTypes() {
        return new Type[]{Type.AWA, Type.AWS, Type.HDG, Type.HDGM, Type.gps_latlong, Type.COG, Type.SOG};
    }

    private class FixReceiver
    extends IgtimiFixReceiverAdapter {
        private FixReceiver() {
        }

        @Override
        public void received(AWA fix) {
            IgtimiWindReceiver.this.getAwaTrack(fix.getSensor().getDeviceSerialNumber()).add((Timed)fix);
        }

        @Override
        public void received(AWS fix) {
            IgtimiWindReceiver.this.getAwsTrack(fix.getSensor().getDeviceSerialNumber()).add((Timed)fix);
        }

        @Override
        public void received(GpsLatLong fix) {
            IgtimiWindReceiver.this.getGpsTrack(fix.getSensor().getDeviceSerialNumber()).add((Timed)fix);
        }

        @Override
        public void received(COG fix) {
            IgtimiWindReceiver.this.getCogTrack(fix.getSensor().getDeviceSerialNumber()).add((Timed)fix);
        }

        @Override
        public void received(SOG fix) {
            IgtimiWindReceiver.this.getSogTrack(fix.getSensor().getDeviceSerialNumber()).add((Timed)fix);
        }

        @Override
        public void received(HDG fix) {
            IgtimiWindReceiver.this.getHdgTrack(fix.getSensor().getDeviceSerialNumber()).add((Timed)fix);
        }

        @Override
        public void received(HDGM fix) {
            IgtimiWindReceiver.this.getHdgmTrack(fix.getSensor().getDeviceSerialNumber()).add((Timed)fix);
        }

        @Override
        public void received(BatteryLevel fix) {
            IgtimiWindReceiver.this.getBatteryLevelTrack(fix.getSensor().getDeviceSerialNumber()).add((Timed)fix);
        }
    }
}

