/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.igtimiadapter.datatypes;

import com.sap.sailing.domain.igtimiadapter.datatypes.AWA;
import com.sap.sailing.domain.igtimiadapter.datatypes.AWS;
import com.sap.sailing.domain.igtimiadapter.datatypes.AntCbst;
import com.sap.sailing.domain.igtimiadapter.datatypes.AntHrm;
import com.sap.sailing.domain.igtimiadapter.datatypes.BatteryLevel;
import com.sap.sailing.domain.igtimiadapter.datatypes.COG;
import com.sap.sailing.domain.igtimiadapter.datatypes.File;
import com.sap.sailing.domain.igtimiadapter.datatypes.Fix;
import com.sap.sailing.domain.igtimiadapter.datatypes.GpsAltitude;
import com.sap.sailing.domain.igtimiadapter.datatypes.GpsLatLong;
import com.sap.sailing.domain.igtimiadapter.datatypes.GpsQualityHdop;
import com.sap.sailing.domain.igtimiadapter.datatypes.GpsQualityIndicator;
import com.sap.sailing.domain.igtimiadapter.datatypes.GpsQualitySatCount;
import com.sap.sailing.domain.igtimiadapter.datatypes.HDG;
import com.sap.sailing.domain.igtimiadapter.datatypes.HDGM;
import com.sap.sailing.domain.igtimiadapter.datatypes.SOG;
import com.sap.sailing.domain.igtimiadapter.datatypes.STW;
import java.util.HashMap;
import java.util.Map;

public enum Type {
    gps_latlong(1, GpsLatLong.class),
    gps_quality_indicator(2, GpsQualityIndicator.class),
    gps_quality_sat_count(3, GpsQualitySatCount.class),
    gps_quality_hdop(4, GpsQualityHdop.class),
    gps_altitude(5, GpsAltitude.class),
    COG(6, COG.class),
    HDGM(7, HDGM.class),
    HDG(8, HDG.class),
    SOG(9, SOG.class),
    STW(10, STW.class),
    AWA(11, AWA.class),
    AWS(12, AWS.class),
    ant_hrm(13, AntHrm.class),
    ant_cbst(14, AntCbst.class),
    File(16, File.class),
    battery_level(50, BatteryLevel.class);

    private final int code;
    private final Class<? extends Fix> fixClass;
    private static final Map<Integer, Type> typeByCode;
    private static final Map<Class<? extends Fix>, Type> typeByClass;

    static {
        typeByCode = new HashMap<Integer, Type>();
        typeByClass = new HashMap<Class<? extends Fix>, Type>();
        Type[] typeArray = Type.values();
        int n = typeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Type type = typeArray[n2];
            typeByCode.put(type.getCode(), type);
            typeByClass.put(type.getFixClass(), type);
            ++n2;
        }
    }

    public int getCode() {
        return this.code;
    }

    public Class<? extends Fix> getFixClass() {
        return this.fixClass;
    }

    private Type(int code, Class<? extends Fix> fixClass) {
        this.code = code;
        this.fixClass = fixClass;
    }

    public static Type getType(Class<? extends Fix> fixClass) {
        return typeByClass.get(fixClass);
    }

    public static Type valueOf(String string) {
        return Enum.valueOf(Type.class, string);
    }
}

