/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.tracking.impl;

import com.sap.sailing.domain.common.NoWindError;
import com.sap.sailing.domain.common.NoWindException;
import com.sap.sailing.domain.tracking.MarkPassing;
import com.sap.sailing.domain.tracking.TrackedLeg;
import com.sap.sailing.domain.tracking.TrackedLegOfCompetitor;
import com.sap.sailing.domain.tracking.WindLegTypeAndLegBearingAndORCPerformanceCurveCache;
import com.sap.sailing.domain.tracking.WindPositionMode;
import com.sap.sse.common.Distance;
import com.sap.sse.common.TimePoint;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public class WindwardToGoComparator
implements Comparator<TrackedLegOfCompetitor> {
    private final TrackedLeg trackedLeg;
    private final TimePoint timePoint;
    private final Map<TrackedLegOfCompetitor, Distance> wwdtgCache;
    private final WindLegTypeAndLegBearingAndORCPerformanceCurveCache windAndLegTypeCache;

    public WindwardToGoComparator(TrackedLeg trackedLeg, TimePoint timePoint, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        this.trackedLeg = trackedLeg;
        this.timePoint = timePoint;
        this.wwdtgCache = new HashMap<TrackedLegOfCompetitor, Distance>();
        this.windAndLegTypeCache = cache;
    }

    @Override
    public int compare(TrackedLegOfCompetitor o1, TrackedLegOfCompetitor o2) {
        assert (o1.getLeg() == o2.getLeg());
        try {
            int result;
            boolean o2HasFinishedLeg;
            MarkPassing o1MarkPassingForLegEnd = this.trackedLeg.getTrackedRace().getMarkPassing(o1.getCompetitor(), this.trackedLeg.getLeg().getTo());
            MarkPassing o2MarkPassingForLegEnd = this.trackedLeg.getTrackedRace().getMarkPassing(o2.getCompetitor(), this.trackedLeg.getLeg().getTo());
            boolean o1HasFinishedLeg = o1MarkPassingForLegEnd != null && o1MarkPassingForLegEnd.getTimePoint().compareTo((Object)this.timePoint) <= 0;
            boolean bl = o2HasFinishedLeg = o2MarkPassingForLegEnd != null && o2MarkPassingForLegEnd.getTimePoint().compareTo((Object)this.timePoint) <= 0;
            if (o1HasFinishedLeg) {
                result = o2HasFinishedLeg ? o1MarkPassingForLegEnd.getTimePoint().compareTo((Object)o2MarkPassingForLegEnd.getTimePoint()) : -1;
            } else if (o2HasFinishedLeg) {
                result = 1;
            } else if (o1.hasStartedLeg(this.timePoint)) {
                if (o2.hasStartedLeg(this.timePoint)) {
                    Distance o1d = this.getWindwardDistanceToGo(o1);
                    Distance o2d = this.getWindwardDistanceToGo(o2);
                    result = o1d == null ? (o2d == null ? 0 : 1) : (o2d == null ? 1 : o1d.compareTo((Object)o2d));
                } else {
                    result = -1;
                }
            } else {
                result = o2.hasStartedLeg(this.timePoint) ? 1 : 0;
            }
            return result;
        }
        catch (NoWindException e) {
            throw new NoWindError(e);
        }
    }

    private Distance getWindwardDistanceToGo(TrackedLegOfCompetitor o1) throws NoWindException {
        Distance result = this.wwdtgCache.get(o1);
        if (result == null) {
            result = o1.getWindwardDistanceToGo(this.timePoint, WindPositionMode.LEG_MIDDLE, this.windAndLegTypeCache);
            this.wwdtgCache.put(o1, result);
        }
        return result;
    }
}

