/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.tracking.impl;

import com.sap.sailing.domain.common.CourseChange;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.common.confidence.Weigher;
import com.sap.sailing.domain.common.confidence.impl.PositionAndTimePointWeigher;
import com.sap.sailing.domain.common.tracking.impl.CompactionNotPossibleException;
import com.sap.sailing.domain.common.tracking.impl.PreciseCompactWindImpl;
import com.sap.sailing.domain.common.tracking.impl.VeryCompactWindImpl;
import com.sap.sailing.domain.confidence.ConfidenceBasedWindAverager;
import com.sap.sailing.domain.confidence.ConfidenceFactory;
import com.sap.sailing.domain.shared.tracking.impl.TrackImpl;
import com.sap.sailing.domain.tracking.WindListener;
import com.sap.sailing.domain.tracking.WindTrack;
import com.sap.sailing.domain.tracking.WindWithConfidence;
import com.sap.sailing.domain.tracking.impl.WindComparator;
import com.sap.sailing.domain.tracking.impl.WindWithConfidenceImpl;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Distance;
import com.sap.sse.common.Duration;
import com.sap.sse.common.Speed;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Timed;
import com.sap.sse.common.Util;
import com.sap.sse.common.util.MappingIterator;
import com.sap.sse.shared.util.impl.ArrayListNavigableSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WindTrackImpl
extends TrackImpl<Wind>
implements WindTrack {
    private static final long serialVersionUID = 6882509533928049084L;
    private static final Logger logger = Logger.getLogger(WindTrackImpl.class.getName());
    protected static final double DEFAULT_BASE_CONFIDENCE = 0.9;
    private final double baseConfidence;
    private long millisecondsOverWhichToAverage;
    private final boolean useSpeed;
    protected final Weigher<Util.Pair<Position, TimePoint>> weigher;
    private transient Set<WindListener> listeners;
    private final boolean losslessCompaction;

    public WindTrackImpl(long millisecondsOverWhichToAverage, boolean useSpeed, String nameForReadWriteLock) {
        this(millisecondsOverWhichToAverage, 0.9, useSpeed, nameForReadWriteLock);
    }

    public WindTrackImpl(long millisecondsOverWhichToAverage, double baseConfidence, boolean useSpeed, String nameForReadWriteLock) {
        this(millisecondsOverWhichToAverage, baseConfidence, useSpeed, nameForReadWriteLock, false);
    }

    public WindTrackImpl(long millisecondsOverWhichToAverage, double baseConfidence, boolean useSpeed, String nameForReadWriteLock, boolean losslessCompaction) {
        super(new ArrayListNavigableSet(WindComparator.INSTANCE), nameForReadWriteLock);
        this.baseConfidence = baseConfidence;
        this.millisecondsOverWhichToAverage = millisecondsOverWhichToAverage;
        this.listeners = new HashSet<WindListener>();
        this.useSpeed = useSpeed;
        this.losslessCompaction = losslessCompaction;
        this.weigher = this.createPositionAndTimePointWeigher();
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        this.listeners = new HashSet<WindListener>();
    }

    @Override
    public Duration getResolutionOutsideOfWhichNoFixWillBeReturned() {
        return null;
    }

    protected Wind getDummyFix(TimePoint timePoint) {
        return new DummyWind(timePoint);
    }

    @Override
    public void setMillisecondsOverWhichToAverage(long millisecondsOverWhichToAverage) {
        long oldMillis = millisecondsOverWhichToAverage;
        this.millisecondsOverWhichToAverage = millisecondsOverWhichToAverage;
        this.notifyListenersAboutAveragingChange(oldMillis, millisecondsOverWhichToAverage);
    }

    @Override
    public long getMillisecondsOverWhichToAverageWind() {
        return this.millisecondsOverWhichToAverage;
    }

    @Override
    public boolean add(Wind fix) {
        return super.add((Timed)fix);
    }

    @Override
    public void add(Iterable<Wind> fixesToAdd) {
        ArrayList<Wind> fixesAdded = new ArrayList<Wind>(Util.size(fixesToAdd));
        for (Wind wind : fixesToAdd) {
            Wind compactWind = this.compactify(wind);
            if (!super.add((Timed)compactWind, false)) continue;
            fixesAdded.add(compactWind);
        }
        if (!fixesAdded.isEmpty()) {
            this.notifyListenersAboutReceive(fixesAdded);
        }
    }

    @Override
    public boolean add(Wind wind, boolean replace) {
        Wind compactWind = this.compactify(wind);
        boolean result = super.add((Timed)compactWind, replace);
        this.notifyListenersAboutReceive(compactWind);
        return result;
    }

    private Wind compactify(Wind wind) {
        PreciseCompactWindImpl compactWind;
        try {
            compactWind = this.losslessCompaction ? new PreciseCompactWindImpl(wind) : new VeryCompactWindImpl(wind);
        }
        catch (CompactionNotPossibleException e) {
            logger.log(Level.FINE, "Couldn't compact wind fix " + wind + ". Using lossless compactification instead.", e);
            compactWind = new PreciseCompactWindImpl(wind);
        }
        return compactWind;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListenersAboutReceive(Wind wind) {
        Set<WindListener> set = this.listeners;
        synchronized (set) {
            for (WindListener listener : this.listeners) {
                try {
                    listener.windDataReceived(wind);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "WindListener " + listener + " threw exception " + e.getMessage());
                    logger.log(Level.SEVERE, "notifyListenersAboutReceive(Wind)", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListenersAboutReceive(Iterable<Wind> winds) {
        Set<WindListener> set = this.listeners;
        synchronized (set) {
            for (WindListener listener : this.listeners) {
                try {
                    listener.windDataReceived(winds);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "WindListener " + listener + " threw exception " + e.getMessage());
                    logger.log(Level.SEVERE, "notifyListenersAboutReceive(Wind)", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListenersAboutAveragingChange(long oldMillisecondsOverWhichToAverage, long newMillisecondsOverWhichToAverage) {
        Set<WindListener> set = this.listeners;
        synchronized (set) {
            for (WindListener listener : this.listeners) {
                try {
                    listener.windAveragingChanged(oldMillisecondsOverWhichToAverage, newMillisecondsOverWhichToAverage);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "WindListener " + listener + " threw exception " + e.getMessage());
                    logger.log(Level.SEVERE, "notifyListenersAboutAveragingChange(long, long)", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListenersAboutRemoval(Wind wind) {
        Set<WindListener> set = this.listeners;
        synchronized (set) {
            for (WindListener listener : this.listeners) {
                try {
                    listener.windDataRemoved(wind);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "WindListener " + listener + " threw exception " + e.getMessage());
                    logger.log(Level.SEVERE, "notifyListenersAboutRemoval(Wind)", e);
                }
            }
        }
    }

    @Override
    public Wind getAveragedWind(Position p, TimePoint at) {
        WindWithConfidence<Util.Pair<Position, TimePoint>> estimatedWindUnsynchronized = this.getAveragedWindUnsynchronized(p, at);
        return estimatedWindUnsynchronized == null ? null : (Wind)estimatedWindUnsynchronized.getObject();
    }

    @Override
    public WindWithConfidence<Util.Pair<Position, TimePoint>> getAveragedWindWithConfidence(Position p, TimePoint at) {
        return this.getAveragedWindUnsynchronized(p, at);
    }

    protected WindWithConfidence<Util.Pair<Position, TimePoint>> getAveragedWindUnsynchronized(Position p, TimePoint at) {
        this.lockForRead();
        try {
            WindWithConfidence<Util.Pair<Position, TimePoint>> average;
            ArrayList<WindWithConfidence<Util.Pair<Position, TimePoint>>> windFixesToAverage = new ArrayList<WindWithConfidence<Util.Pair<Position, TimePoint>>>();
            ConfidenceBasedWindAverager<Util.Pair<Position, TimePoint>> windAverager = ConfidenceFactory.INSTANCE.createWindAverager(this.weigher);
            Util.Pair relativeTo = new Util.Pair((Object)p, (Object)at);
            Iterator<WindWithConfidence<Util.Pair<Position, TimePoint>>> beforeIter = this.getInternalFixesLimitedHeadSetDescendingIterator(at);
            this.collectFixesInOneDirection(beforeIter, windFixesToAverage);
            Iterator<WindWithConfidence<Util.Pair<Position, TimePoint>>> afterIter = this.getInternalFixesLimitedTailSetIterator(at);
            this.collectFixesInOneDirection(afterIter, windFixesToAverage);
            if (windFixesToAverage.isEmpty()) {
                return null;
            }
            WindWithConfidence<Util.Pair<Position, TimePoint>> windWithConfidence = average = windAverager.getAverage(windFixesToAverage, (Util.Pair<Position, TimePoint>)relativeTo);
            return windWithConfidence;
        }
        finally {
            this.unlockAfterRead();
        }
    }

    protected Iterator<WindWithConfidence<Util.Pair<Position, TimePoint>>> getInternalFixesLimitedHeadSetDescendingIterator(TimePoint endingAt) {
        return new MappingIterator(this.getInternalFixes().headSet(new DummyWind(endingAt), false).descendingIterator(), wind -> this.createWindWithConfidence((Wind)wind));
    }

    protected Iterator<WindWithConfidence<Util.Pair<Position, TimePoint>>> getInternalFixesLimitedTailSetIterator(TimePoint startingAt) {
        return new MappingIterator(this.getInternalFixes().tailSet(new DummyWind(startingAt), true).iterator(), wind -> this.createWindWithConfidence((Wind)wind));
    }

    private void collectFixesInOneDirection(Iterator<WindWithConfidence<Util.Pair<Position, TimePoint>>> fixIter, Collection<WindWithConfidence<Util.Pair<Position, TimePoint>>> windFixesToAverage) {
        long newDistanceToFirst;
        TimePoint firstTimePointInDirection;
        long distanceToFirst = 0L;
        WindWithConfidence<Util.Pair<Position, TimePoint>> nextWindFix = null;
        if (fixIter.hasNext()) {
            nextWindFix = fixIter.next();
            firstTimePointInDirection = ((Wind)nextWindFix.getObject()).getTimePoint();
            distanceToFirst = Math.abs(firstTimePointInDirection.asMillis() - ((Wind)nextWindFix.getObject()).getTimePoint().asMillis());
            windFixesToAverage.add(nextWindFix);
        } else {
            firstTimePointInDirection = null;
        }
        if (fixIter.hasNext()) {
            nextWindFix = fixIter.next();
            newDistanceToFirst = Math.abs(firstTimePointInDirection.asMillis() - ((Wind)nextWindFix.getObject()).getTimePoint().asMillis());
        } else {
            nextWindFix = null;
            newDistanceToFirst = distanceToFirst;
        }
        while (nextWindFix != null && newDistanceToFirst <= this.getMillisecondsOverWhichToAverageWind() / 2L) {
            windFixesToAverage.add(nextWindFix);
            distanceToFirst = newDistanceToFirst;
            if (fixIter.hasNext()) {
                nextWindFix = fixIter.next();
                newDistanceToFirst = Math.abs(firstTimePointInDirection.asMillis() - ((Wind)nextWindFix.getObject()).getTimePoint().asMillis());
                continue;
            }
            nextWindFix = null;
            newDistanceToFirst = distanceToFirst;
        }
    }

    private PositionAndTimePointWeigher createPositionAndTimePointWeigher() {
        return new PositionAndTimePointWeigher(WIND_HALF_CONFIDENCE_DURATION, WIND_HALF_CONFIDENCE_DISTANCE);
    }

    private WindWithConfidenceImpl<Util.Pair<Position, TimePoint>> createWindWithConfidence(Wind wind) {
        return new WindWithConfidenceImpl<Util.Pair<Position, TimePoint>>(wind, this.getConfidenceOfInternalWindFixUnsynchronized(wind), new Util.Pair((Object)wind.getPosition(), (Object)wind.getTimePoint()), this.useSpeed);
    }

    protected boolean isUseSpeed() {
        return this.useSpeed;
    }

    protected double getConfidenceOfInternalWindFixUnsynchronized(Wind windFix) {
        return this.getBaseConfidence();
    }

    private double getBaseConfidence() {
        return this.baseConfidence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        this.lockForRead();
        try {
            StringBuilder result = new StringBuilder();
            WindTrackImpl windTrackImpl = this;
            synchronized (windTrackImpl) {
                for (Wind wind : this.getRawFixes()) {
                    result.append(wind);
                    result.append(" avg(");
                    result.append(this.getMillisecondsOverWhichToAverageWind());
                    if (wind == null) {
                        result.append("ms)");
                    } else {
                        result.append("ms): ");
                        result.append(this.getAveragedWind(wind.getPosition(), wind.getTimePoint()));
                    }
                    result.append("\n");
                }
            }
            String string = result.toString();
            return string;
        }
        finally {
            this.unlockAfterRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toCSV() {
        this.lockForRead();
        try {
            StringBuilder result = new StringBuilder();
            WindTrackImpl windTrackImpl = this;
            synchronized (windTrackImpl) {
                for (Wind wind : this.getRawFixes()) {
                    this.append(result, wind);
                    Wind estimate = this.getAveragedWind(wind.getPosition(), wind.getTimePoint());
                    this.append(result, estimate);
                    result.append("\n");
                }
            }
            String string = result.toString();
            return string;
        }
        finally {
            this.unlockAfterRead();
        }
    }

    private void append(StringBuilder result, Wind wind) {
        result.append(wind.getTimePoint().asMillis());
        result.append("\t");
        result.append(wind.getKnots());
        result.append("\t");
        result.append(wind.getFrom().getDegrees());
        result.append("\t");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(WindListener listener) {
        Set<WindListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void remove(Wind wind) {
        this.lockForWrite();
        try {
            this.getInternalRawFixes().remove(this.compactify(wind));
        }
        finally {
            this.unlockAfterWrite();
        }
        this.notifyListenersAboutRemoval(wind);
    }

    protected static class DummyWind
    extends TrackImpl.DummyTimed
    implements Wind {
        private static final long serialVersionUID = -311172509910032149L;
        private final Position position;

        public DummyWind(TimePoint timePoint) {
            this(timePoint, null);
        }

        public DummyWind(TimePoint timePoint, Position position) {
            super(timePoint);
            this.position = position;
        }

        public Position getPosition() {
            return this.position;
        }

        public Bearing getBearing() {
            return null;
        }

        public Position travelTo(Position pos, TimePoint from, TimePoint to) {
            return null;
        }

        public double getKnots() {
            return 0.0;
        }

        public double getMetersPerSecond() {
            return 0.0;
        }

        public double getKilometersPerHour() {
            return 0.0;
        }

        public Distance travel(TimePoint from, TimePoint to) {
            return null;
        }

        public Duration getDuration(Distance distance) {
            return null;
        }

        public SpeedWithBearing add(SpeedWithBearing other) {
            return null;
        }

        public int compareTo(Speed o) {
            return 0;
        }

        public Bearing getFrom() {
            return null;
        }

        public double getBeaufort() {
            return 0.0;
        }

        public SpeedWithBearing applyCourseChange(CourseChange courseChange) {
            return null;
        }

        public CourseChange getCourseChangeRequiredToReach(SpeedWithBearing targetSpeedWithBearing) {
            return null;
        }

        public Speed projectTo(Position position, Bearing bearing) {
            return null;
        }

        public double getStatuteMilesPerHour() {
            return 0.0;
        }

        public Distance travel(Duration duration) {
            return null;
        }

        public double divide(Speed speed) {
            return 0.0;
        }
    }
}

