/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.tracking.impl;

import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.shared.tracking.impl.PartialNavigableSetView;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.domain.tracking.WindWithConfidence;
import com.sap.sailing.domain.tracking.impl.TrackedRaceImpl;
import com.sap.sailing.domain.tracking.impl.WindTrackImpl;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import java.util.NavigableSet;

public abstract class VirtualWindTrackImpl
extends WindTrackImpl {
    private static final long serialVersionUID = 6317321456089655749L;
    private final TrackedRace trackedRace;

    protected VirtualWindTrackImpl(TrackedRace trackedRace, long millisecondsOverWhichToAverage, double baseConfidence, boolean useSpeed) {
        super(millisecondsOverWhichToAverage, baseConfidence, useSpeed, String.valueOf(VirtualWindTrackImpl.class.getSimpleName()) + " for race " + trackedRace.getRace().getName());
        this.trackedRace = trackedRace;
    }

    protected TrackedRace getTrackedRace() {
        return this.trackedRace;
    }

    protected NavigableSet<Wind> getInternalFixes() {
        return new PartialNavigableSetView<Wind>(this.getInternalRawFixes()){

            protected boolean isValid(Wind e) {
                return e != null;
            }
        };
    }

    @Override
    public Wind getAveragedWind(Position p, TimePoint at) {
        WindWithConfidence<Util.Pair<Position, TimePoint>> windWithConfidence = this.getAveragedWindUnsynchronized(p, at);
        return windWithConfidence == null ? null : (Wind)windWithConfidence.getObject();
    }

    @Override
    public WindWithConfidence<Util.Pair<Position, TimePoint>> getAveragedWindWithConfidence(Position p, TimePoint at) {
        Object adjustedAt;
        WindWithConfidence<Util.Pair<Position, TimePoint>> result = null;
        TimePoint startOfRace = this.getTrackedRace().getStartOfRace();
        TimePoint timePointOfNewestEvent = this.getTrackedRace().getTimePointOfNewestEvent();
        if (startOfRace != null) {
            TimePoint fourMinutesBeforeRaceStartTimePoint = startOfRace.minus(TrackedRaceImpl.TIME_BEFORE_START_TO_TRACK_WIND_MILLIS);
            adjustedAt = timePointOfNewestEvent != null ? (at.compareTo((Object)fourMinutesBeforeRaceStartTimePoint) < 0 ? fourMinutesBeforeRaceStartTimePoint : (at.compareTo((Object)timePointOfNewestEvent) > 0 ? timePointOfNewestEvent : at)) : fourMinutesBeforeRaceStartTimePoint;
        } else {
            adjustedAt = timePointOfNewestEvent != null ? timePointOfNewestEvent : null;
        }
        if (adjustedAt != null) {
            result = this.getAveragedWindUnsynchronized(p, (TimePoint)adjustedAt);
        }
        return result;
    }
}

