/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.tracking.impl;

import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.WindSource;
import com.sap.sailing.domain.tracking.WindWithConfidence;
import com.sap.sailing.domain.tracking.impl.TrackedRaceImpl;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.shared.util.impl.ApproximateTime;
import com.sap.sse.util.ThreadPoolUtil;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ShortTimeWindCache {
    private static final Logger logger = Logger.getLogger(ShortTimeWindCache.class.getName());
    private final ConcurrentMap<Util.Triple<Position, TimePoint, Set<WindSource>>, WindWithConfidence<Util.Pair<Position, TimePoint>>> cache;
    private final ConcurrentLinkedDeque<Util.Pair<Long, Util.Triple<Position, TimePoint, Set<WindSource>>>> order;
    private ScheduledFuture<?> invalidatorHandle;
    private final long preserveHowManyMilliseconds;
    private final TrackedRaceImpl trackedRace;
    private long hits;
    private long misses;

    public ShortTimeWindCache(TrackedRaceImpl trackedRace, long preserveHowManyMilliseconds) {
        this.trackedRace = trackedRace;
        this.preserveHowManyMilliseconds = preserveHowManyMilliseconds;
        this.cache = new ConcurrentHashMap<Util.Triple<Position, TimePoint, Set<WindSource>>, WindWithConfidence<Util.Pair<Position, TimePoint>>>();
        this.order = new ConcurrentLinkedDeque();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(Util.Triple<Position, TimePoint, Set<WindSource>> key, WindWithConfidence<Util.Pair<Position, TimePoint>> wind) {
        this.cache.put(key, wind);
        ConcurrentLinkedDeque<Util.Pair<Long, Util.Triple<Position, TimePoint, Set<WindSource>>>> concurrentLinkedDeque = this.order;
        synchronized (concurrentLinkedDeque) {
            long timestamp = this.preserveHowManyMilliseconds > 1000L ? ApproximateTime.approximateNow().asMillis() : System.currentTimeMillis();
            this.order.add((Util.Pair<Long, Util.Triple<Position, TimePoint, Set<WindSource>>>)new Util.Pair((Object)timestamp, key));
            this.ensureTimerIsRunning();
        }
    }

    public void clearCache() {
        this.cache.clear();
        this.order.clear();
    }

    public void clearCacheEntriesAtPositionsAndTimePointsWithWindSource(List<Util.Pair<Position, TimePoint>> changedWindMeasurements, WindSource windSourceWithChange) {
        Util.Triple cachedKey = (Util.Triple)this.order.peekFirst().getB();
        if (!((Set)cachedKey.getC()).contains(windSourceWithChange) && changedWindMeasurements.contains(new Util.Pair((Object)((Position)cachedKey.getA()), (Object)((TimePoint)cachedKey.getB())))) {
            this.order.pollFirst();
            this.cache.remove(cachedKey);
        }
    }

    public void clearCacheEntriesWithWindSource(WindSource windSourceWithChange) {
        Util.Triple cachedKey = (Util.Triple)this.order.peekFirst().getB();
        if (!((Set)cachedKey.getC()).contains(windSourceWithChange)) {
            this.order.pollFirst();
            this.cache.remove(cachedKey);
        }
    }

    protected WindWithConfidence<Util.Pair<Position, TimePoint>> getWindWithConfidence(Position p, TimePoint at, Set<WindSource> windSourcesToExclude) {
        Util.Triple key = new Util.Triple((Object)p, (Object)at, windSourcesToExclude);
        WindWithConfidence<Util.Pair<Position, TimePoint>> wind = (WindWithConfidence<Util.Pair<Position, TimePoint>>)this.cache.get(key);
        if (wind == null) {
            ++this.misses;
            wind = this.trackedRace.getWindWithConfidenceUncached(p, at, windSourcesToExclude);
            if (wind != null) {
                this.add((Util.Triple<Position, TimePoint, Set<WindSource>>)key, wind);
            }
        } else {
            ++this.hits;
        }
        if ((this.hits + this.misses) % 100000L == 0L && logger.isLoggable(Level.FINE)) {
            logger.fine("hits: " + this.hits + ", misses: " + this.misses);
        }
        return wind;
    }

    private void ensureTimerIsRunning() {
        if (this.invalidatorHandle == null) {
            this.invalidatorHandle = ThreadPoolUtil.INSTANCE.getDefaultForegroundTaskThreadPoolExecutor().scheduleAtFixedRate(new CacheInvalidator(), this.preserveHowManyMilliseconds, this.preserveHowManyMilliseconds, TimeUnit.MILLISECONDS);
        }
    }

    private class CacheInvalidator
    implements Runnable {
        private CacheInvalidator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Util.Pair next;
            long oldestToKeep = System.currentTimeMillis() - ShortTimeWindCache.this.preserveHowManyMilliseconds;
            while ((next = (Util.Pair)ShortTimeWindCache.this.order.peekFirst()) != null && (Long)next.getA() < oldestToKeep) {
                ShortTimeWindCache.this.order.pollFirst();
                ShortTimeWindCache.this.cache.remove(next.getB());
            }
            ConcurrentLinkedDeque concurrentLinkedDeque = ShortTimeWindCache.this.order;
            synchronized (concurrentLinkedDeque) {
                if (ShortTimeWindCache.this.order.isEmpty()) {
                    ShortTimeWindCache.this.invalidatorHandle.cancel(false);
                    ShortTimeWindCache.this.invalidatorHandle = null;
                }
            }
        }
    }
}

