/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.tracking.impl;

import com.sap.sailing.domain.common.tracking.SensorFix;
import com.sap.sailing.domain.shared.tracking.AddResult;
import com.sap.sailing.domain.tracking.DynamicSensorFixTrack;
import com.sap.sailing.domain.tracking.SensorFixTrackListener;
import com.sap.sailing.domain.tracking.impl.DynamicMappedTrackImpl;
import com.sap.sailing.domain.tracking.impl.TrackListenerCollection;
import com.sap.sse.common.Timed;
import com.sap.sse.common.WithID;
import java.io.Serializable;
import java.util.function.Consumer;

public class SensorFixTrackImpl<ItemType extends WithID & Serializable, FixT extends SensorFix>
extends DynamicMappedTrackImpl<ItemType, FixT>
implements DynamicSensorFixTrack<ItemType, FixT> {
    private static final long serialVersionUID = 6383421895429843002L;
    private final String trackName;
    private final TrackListenerCollection<ItemType, FixT, SensorFixTrackListener<ItemType, FixT>> listeners;

    public SensorFixTrackImpl(ItemType trackedItem, String trackName, String nameForReadWriteLock) {
        super(trackedItem, nameForReadWriteLock);
        this.trackName = trackName;
        this.listeners = new TrackListenerCollection();
    }

    @Override
    public boolean add(FixT fix, boolean replace) {
        boolean result;
        this.lockForWrite();
        try {
            boolean firstFixInTrack = this.getRawFixes().isEmpty();
            AddResult addResult = this.addWithoutLocking((Timed)fix, replace);
            boolean bl = result = addResult == AddResult.ADDED || addResult == AddResult.REPLACED;
            if (result) {
                this.notifyListeners(listener -> listener.fixReceived(fix, (WithID)this.getTrackedItem(), this.trackName, firstFixInTrack, addResult));
            }
        }
        finally {
            this.unlockAfterWrite();
        }
        return result;
    }

    protected void notifyListeners(Consumer<SensorFixTrackListener<ItemType, FixT>> notification) {
        this.listeners.getListeners().forEach(notification);
    }

    @Override
    public void addListener(SensorFixTrackListener<ItemType, FixT> listener) {
        this.listeners.addListener(listener);
    }

    @Override
    public void removeListener(SensorFixTrackListener<ItemType, FixT> listener) {
        this.listeners.removeListener(listener);
    }

    @Override
    public String getTrackName() {
        return this.trackName;
    }
}

