/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.tracking.impl;

import com.sap.sailing.domain.common.racelog.Flags;
import com.sap.sailing.domain.tracking.RaceAbortedListener;
import com.sap.sailing.domain.tracking.impl.UpdateHandler;
import java.io.IOException;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.logging.Logger;
import org.json.simple.parser.ParseException;

public class RaceAbortedHandler
extends UpdateHandler
implements RaceAbortedListener {
    private static final String ACTION = "update_race_status";
    private static final Logger logger = Logger.getLogger(RaceAbortedHandler.class.getName());

    public RaceAbortedHandler(URI updateURI, String tracTracApiToken, Serializable eventId, Serializable raceId) {
        super(updateURI, ACTION, tracTracApiToken, eventId, raceId);
    }

    @Override
    public void raceAborted(Flags flag) throws MalformedURLException, IOException {
        if (!this.isActive()) {
            logger.info("Not sending race abort notification to TracTrac because no URL has been provided.");
            return;
        }
        String raceStatus = flag == Flags.AP ? "POSTPONED" : "ABORTED";
        HashMap<String, String> additionalArgs = new HashMap<String, String>();
        additionalArgs.put("race_status", raceStatus);
        URL raceAbortedURL = this.buildUpdateURL(additionalArgs);
        logger.info("Using " + this.eraseSecurityRelatedValuesFromURL(raceAbortedURL.toString()) + " for the race aborted notification!");
        HttpURLConnection connection = (HttpURLConnection)raceAbortedURL.openConnection();
        try {
            connection = this.setConnectionProperties(connection);
            try {
                this.checkAndLogUpdateResponse(connection);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            } else {
                logger.severe("Connection to TracTrac race aborted URL " + this.eraseSecurityRelatedValuesFromURL(raceAbortedURL.toString()) + " could not be established");
            }
        }
    }
}

