/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.tracking.impl;

import com.sap.sailing.domain.common.tracking.GPSFix;
import com.sap.sailing.domain.common.tracking.impl.PreciseCompactGPSFixImpl;
import com.sap.sailing.domain.common.tracking.impl.VeryCompactGPSFixImpl;
import com.sap.sailing.domain.tracking.DynamicGPSFixTrack;
import com.sap.sailing.domain.tracking.impl.GPSFixTrackImpl;
import com.sap.sse.common.Timed;

public class DynamicGPSFixTrackImpl<ItemType>
extends GPSFixTrackImpl<ItemType, GPSFix>
implements DynamicGPSFixTrack<ItemType, GPSFix> {
    private static final long serialVersionUID = 4035953954507697564L;

    public DynamicGPSFixTrackImpl(ItemType trackedItem, long millisecondsOverWhichToAverage) {
        this(trackedItem, millisecondsOverWhichToAverage, false);
    }

    public DynamicGPSFixTrackImpl(ItemType trackedItem, long millisecondsOverWhichToAverage, boolean losslessCompaction) {
        super(trackedItem, millisecondsOverWhichToAverage, losslessCompaction);
    }

    @Override
    public boolean addGPSFix(GPSFix gpsFix) {
        return this.add(gpsFix, true);
    }

    @Override
    public boolean add(GPSFix fix) {
        return super.add((Timed)fix);
    }

    @Override
    public boolean add(GPSFix fix, boolean replace) {
        return super.add(this.isLosslessCompaction() ? new PreciseCompactGPSFixImpl(fix) : new VeryCompactGPSFixImpl(fix), replace);
    }

    @Override
    public void setMillisecondsOverWhichToAverage(long millisecondsOverWhichToAverage) {
        super.setMillisecondsOverWhichToAverage(millisecondsOverWhichToAverage);
    }
}

