/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.tracking;

import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.common.impl.MeterDistance;
import com.sap.sailing.domain.tracking.DynamicTrack;
import com.sap.sailing.domain.tracking.WindListener;
import com.sap.sailing.domain.tracking.WindWithConfidence;
import com.sap.sse.common.Distance;
import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;

public interface WindTrack
extends DynamicTrack<Wind> {
    public static final long DEFAULT_MILLISECONDS_OVER_WHICH_TO_AVERAGE_WIND = 30000L;
    public static final Distance WIND_HALF_CONFIDENCE_DISTANCE = new MeterDistance(100.0);
    public static final Duration WIND_HALF_CONFIDENCE_DURATION = Duration.ONE_SECOND.times(5L);

    public Wind getAveragedWind(Position var1, TimePoint var2);

    public WindWithConfidence<Util.Pair<Position, TimePoint>> getAveragedWindWithConfidence(Position var1, TimePoint var2);

    public void addListener(WindListener var1);

    public void add(Iterable<Wind> var1);

    public void remove(Wind var1);

    public void setMillisecondsOverWhichToAverage(long var1);

    public long getMillisecondsOverWhichToAverageWind();

    public Duration getResolutionOutsideOfWhichNoFixWillBeReturned();
}

