/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.tracking;

import com.sap.sailing.domain.abstractlog.race.RaceLog;
import com.sap.sailing.domain.abstractlog.race.RaceLogWindFixEvent;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.WindFixesFinder;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.common.confidence.BearingWithConfidence;
import com.sap.sailing.domain.common.confidence.BearingWithConfidenceCluster;
import com.sap.sailing.domain.common.confidence.Weigher;
import com.sap.sailing.domain.common.confidence.impl.BearingWithConfidenceImpl;
import com.sap.sailing.domain.tracking.RaceLogWindFixDeclinationHelper;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.domain.tracking.WindSummary;
import com.sap.sailing.domain.tracking.WindWithConfidence;
import com.sap.sailing.domain.tracking.impl.WindSummaryImpl;
import com.sap.sailing.domain.tracking.impl.WindWithConfidenceImpl;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Speed;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class RaceWindCalculator {
    public WindSummary getWindSummary(TrackedRace trackedRace, RaceLog raceLog) {
        WindSummary windSummary = trackedRace != null ? this.getTrackedRaceWindSummary(trackedRace) : this.getWindSummaryFromRaceLog(raceLog);
        return windSummary;
    }

    private WindSummary getTrackedRaceWindSummary(TrackedRace trackedRace) {
        WindSummary result;
        TimePoint startOfRace = trackedRace.getStartOfRace();
        if (startOfRace == null) {
            result = null;
        } else {
            TimePoint finishedTime = trackedRace.getFinishedTime();
            TimePoint endOfRace = trackedRace.getEndOfRace();
            TimePoint finishTime = finishedTime == null ? (endOfRace == null ? MillisecondsTimePoint.now().minus(trackedRace.getDelayToLiveInMillis()) : endOfRace) : finishedTime;
            TimePoint newestEvent = trackedRace.getTimePointOfNewestEvent();
            TimePoint toTimePoint = newestEvent != null && newestEvent.before(finishTime) ? newestEvent : finishTime;
            TimePoint middleOfRace = startOfRace.plus(startOfRace.until(toTimePoint).divide(2L));
            List<TimePoint> pointsToGetWind = Arrays.asList(startOfRace, middleOfRace, toTimePoint);
            ArrayList<WindWithConfidence<Util.Pair<Position, TimePoint>>> windFixesToUse = new ArrayList<WindWithConfidence<Util.Pair<Position, TimePoint>>>(3);
            for (TimePoint timePoint : pointsToGetWind) {
                WindWithConfidence<Util.Pair<Position, TimePoint>> windFixToUse = this.getWindFromTrackedRace(timePoint, trackedRace);
                if (windFixToUse == null) continue;
                windFixesToUse.add(windFixToUse);
            }
            result = this.createWindSummaryFromWindFixes(middleOfRace, windFixesToUse);
        }
        return result;
    }

    private WindSummary createWindSummaryFromWindFixes(TimePoint middleOfRace, List<WindWithConfidence<Util.Pair<Position, TimePoint>>> windFixesToUse) {
        WindSummaryImpl result;
        Speed minTrueWindSpeed = null;
        Speed maxTrueWindSpeed = null;
        BearingWithConfidenceCluster bwcc = new BearingWithConfidenceCluster((Weigher)new Weigher<TimePoint>(){
            private static final long serialVersionUID = -5779398785058438328L;

            public double getConfidence(TimePoint fix, TimePoint request) {
                return 1.0;
            }
        });
        for (WindWithConfidence<Util.Pair<Position, TimePoint>> windFixToUse : windFixesToUse) {
            bwcc.add((BearingWithConfidence)new BearingWithConfidenceImpl(((Wind)windFixToUse.getObject()).getBearing(), windFixToUse.getConfidence(), (Object)((Wind)windFixToUse.getObject()).getTimePoint()));
            if (minTrueWindSpeed == null || minTrueWindSpeed.compareTo((Object)((Speed)windFixToUse.getObject())) > 0) {
                minTrueWindSpeed = (Speed)windFixToUse.getObject();
            }
            if (maxTrueWindSpeed != null && maxTrueWindSpeed.compareTo((Object)((Speed)windFixToUse.getObject())) >= 0) continue;
            maxTrueWindSpeed = (Speed)windFixToUse.getObject();
        }
        if (minTrueWindSpeed != null && maxTrueWindSpeed != null) {
            BearingWithConfidence average = bwcc.getAverage((Object)middleOfRace);
            result = new WindSummaryImpl(((Bearing)average.getObject()).reverse(), minTrueWindSpeed, maxTrueWindSpeed);
        } else {
            result = null;
        }
        return result;
    }

    public Wind checkForLatestWindFixFromRaceLog(RaceLog raceLog) {
        WindFixesFinder windFixesFinder;
        List windList;
        Wind result = raceLog == null ? null : (!(windList = (List)(windFixesFinder = new WindFixesFinder(raceLog)).analyze()).isEmpty() ? new RaceLogWindFixDeclinationHelper().getOptionallyDeclinationCorrectedWind((RaceLogWindFixEvent)windList.get(windList.size() - 1)) : null);
        return result;
    }

    public WindSummary getWindSummaryFromRaceLog(RaceLog raceLog) {
        WindSummary result;
        if (raceLog == null) {
            result = null;
        } else {
            WindFixesFinder windFixesFinder = new WindFixesFinder(raceLog);
            List windList = (List)windFixesFinder.analyze();
            if (!windList.isEmpty()) {
                int[] nArray = new int[3];
                nArray[1] = windList.size() / 2;
                nArray[2] = windList.size() - 1;
                int[] indicesToUse = nArray;
                ArrayList<WindWithConfidence<Util.Pair<Position, TimePoint>>> windFixesToUse = new ArrayList<WindWithConfidence<Util.Pair<Position, TimePoint>>>(indicesToUse.length);
                int[] nArray2 = indicesToUse;
                int n = indicesToUse.length;
                int n2 = 0;
                while (n2 < n) {
                    int i = nArray2[n2];
                    Wind wind = new RaceLogWindFixDeclinationHelper().getOptionallyDeclinationCorrectedWind((RaceLogWindFixEvent)windList.get(i));
                    WindWithConfidenceImpl<Util.Pair> windWithConfidence = new WindWithConfidenceImpl<Util.Pair>(wind, 1.0, new Util.Pair((Object)wind.getPosition(), (Object)wind.getTimePoint()), true);
                    windFixesToUse.add(windWithConfidence);
                    ++n2;
                }
                result = this.createWindSummaryFromWindFixes(((Wind)((WindWithConfidence)windFixesToUse.get(1)).getObject()).getTimePoint(), windFixesToUse);
            } else {
                result = null;
            }
        }
        return result;
    }

    public WindWithConfidence<Util.Pair<Position, TimePoint>> getWindFromTrackedRace(TimePoint timePoint, TrackedRace trackedRace) {
        WindWithConfidence<Util.Pair<Position, TimePoint>> averagedWindWithConfidence = trackedRace.getWindWithConfidence(trackedRace.getCenterOfCourse(timePoint), timePoint);
        WindWithConfidence<Util.Pair<Position, TimePoint>> result = averagedWindWithConfidence != null && ((Wind)averagedWindWithConfidence.getObject()).getKnots() >= 0.05 ? averagedWindWithConfidence : null;
        return result;
    }
}

