/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.tracking;

import com.sap.sailing.declination.Declination;
import com.sap.sailing.declination.DeclinationService;
import com.sap.sailing.domain.abstractlog.race.RaceLogWindFixEvent;
import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.common.impl.KnotSpeedWithBearingImpl;
import com.sap.sailing.domain.common.impl.WindImpl;
import com.sap.sse.common.Duration;
import java.io.IOException;
import java.text.ParseException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RaceLogWindFixDeclinationHelper {
    private static final Logger logger = Logger.getLogger(RaceLogWindFixDeclinationHelper.class.getName());

    public Wind getOptionallyDeclinationCorrectedWind(RaceLogWindFixEvent event) {
        Wind wind;
        if (event.isMagnetic()) {
            Wind magneticNorthBasedWindFix = event.getWindFix();
            DeclinationService declinationService = DeclinationService.INSTANCE;
            try {
                Declination declination = declinationService.getDeclination(magneticNorthBasedWindFix.getTimePoint(), magneticNorthBasedWindFix.getPosition(), Duration.ONE_SECOND.times(5L).asMillis());
                wind = new WindImpl(magneticNorthBasedWindFix.getPosition(), magneticNorthBasedWindFix.getTimePoint(), (SpeedWithBearing)new KnotSpeedWithBearingImpl(magneticNorthBasedWindFix.getKnots(), magneticNorthBasedWindFix.getBearing().add(declination.getBearingCorrectedTo(magneticNorthBasedWindFix.getTimePoint()))));
            }
            catch (IOException | ParseException e) {
                logger.log(Level.SEVERE, "Error trying to correct magnetic wind fix " + magneticNorthBasedWindFix + " by declination. " + "Using uncorrected magnetic wind direction instead.", e);
                wind = magneticNorthBasedWindFix;
            }
        } else {
            wind = event.getWindFix();
        }
        return wind;
    }
}

