/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.tracking;

import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Duration;
import com.sap.sse.common.Speed;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.impl.DegreeBearingImpl;

public interface ManeuverCurveBoundaries {
    public TimePoint getTimePointBefore();

    public TimePoint getTimePointAfter();

    public SpeedWithBearing getSpeedWithBearingBefore();

    public SpeedWithBearing getSpeedWithBearingAfter();

    default public Bearing getMiddleCourse() {
        double middleCourseDeg = (this.getSpeedWithBearingBefore().getBearing().getDegrees() + this.getDirectionChangeInDegrees() / 2.0) % 360.0;
        if (middleCourseDeg < 0.0) {
            middleCourseDeg += 360.0;
        }
        return new DegreeBearingImpl(middleCourseDeg);
    }

    public double getDirectionChangeInDegrees();

    default public Duration getDuration() {
        return this.getTimePointBefore().until(this.getTimePointAfter());
    }

    public Speed getLowestSpeed();

    public Speed getHighestSpeed();
}

